/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    String title;
    TitledBorder border;
    MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            CollapsiblePanel.this.toggleVisibility();
        }
    };
    ComponentListener contentComponentListener = new ComponentAdapter(){

        public void componentShown(ComponentEvent e) {
            CollapsiblePanel.this.updateBorderTitle();
        }

        public void componentHidden(ComponentEvent e) {
            CollapsiblePanel.this.updateBorderTitle();
        }
    };

    public CollapsiblePanel(String title) {
        this.title = title;
        this.border = BorderFactory.createTitledBorder(title);
        this.setBorder(this.border);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.addMouseListener(this.mouseListener);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.firePropertyChange("title", this.title, this.title);
    }

    public Component add(Component comp) {
        comp.addComponentListener(this.contentComponentListener);
        Component r = super.add(comp);
        this.updateBorderTitle();
        return r;
    }

    public Component add(String name, Component comp) {
        comp.addComponentListener(this.contentComponentListener);
        Component r = super.add(name, comp);
        this.updateBorderTitle();
        return r;
    }

    public Component add(Component comp, int index) {
        comp.addComponentListener(this.contentComponentListener);
        Component r = super.add(comp, index);
        this.updateBorderTitle();
        return r;
    }

    public void add(Component comp, Object constraints) {
        comp.addComponentListener(this.contentComponentListener);
        super.add(comp, constraints);
        this.updateBorderTitle();
    }

    public void add(Component comp, Object constraints, int index) {
        comp.addComponentListener(this.contentComponentListener);
        super.add(comp, constraints, index);
        this.updateBorderTitle();
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        comp.removeComponentListener(this.contentComponentListener);
        super.remove(index);
    }

    public void remove(Component comp) {
        comp.removeComponentListener(this.contentComponentListener);
        super.remove(comp);
    }

    public void removeAll() {
        for (Component c : this.getComponents()) {
            c.removeComponentListener(this.contentComponentListener);
        }
        super.removeAll();
    }

    protected void toggleVisibility() {
        this.toggleVisibility(this.hasInvisibleComponent());
    }

    protected void toggleVisibility(boolean visible) {
        for (Component c : this.getComponents()) {
            c.setVisible(visible);
        }
        this.updateBorderTitle();
    }

    protected void updateBorderTitle() {
        String arrow = "";
        if (this.getComponentCount() > 0) {
            arrow = this.hasInvisibleComponent() ? "\u25bd" : "\u25b3";
        }
        this.border.setTitle(this.title + " " + arrow);
        this.repaint();
    }

    protected final boolean hasInvisibleComponent() {
        for (Component c : this.getComponents()) {
            if (c.isVisible()) continue;
            return true;
        }
        return false;
    }
}

