/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lu.uni.adtool.ui.CollapsiblePanel;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainView<Type>
extends JPanel
implements ItemListener {
    static final long serialVersionUID = 152365011570211223L;
    private int id;
    private DomainCanvas<Type> canvas;
    private MainWindow parent;
    private JCheckBox labelBox;
    private JCheckBox allLabelBox;
    private JCheckBox nodeSizeBox;
    private JCheckBox markEditableBox;
    private JButton closeDomain;

    public DomainView(MainWindow newParent, DomainCanvas newCanvas, int newId) {
        super(new BorderLayout());
        this.id = newId;
        this.canvas = newCanvas;
        this.parent = newParent;
        this.initLayout();
    }

    private void initLayout() {
        this.labelBox = new JCheckBox("Show Labels");
        this.labelBox.setMnemonic(76);
        this.labelBox.setSelected(false);
        this.labelBox.addItemListener(this);
        this.allLabelBox = new JCheckBox("Show Computed Values for Subtrees");
        this.allLabelBox.setMnemonic(86);
        this.allLabelBox.setSelected(true);
        this.allLabelBox.addItemListener(this);
        this.markEditableBox = new JCheckBox("Mark Editable Nodes");
        this.markEditableBox.setMnemonic(77);
        this.markEditableBox.setSelected(this.canvas.isMarkEditable());
        this.markEditableBox.addItemListener(this);
        this.canvas.setLocalExtentProvider(false);
        this.canvas.setShowLabels(false);
        this.canvas.setShowAllLabels(true);
        this.nodeSizeBox = new JCheckBox("Local Node Size");
        this.nodeSizeBox.setMnemonic(83);
        this.nodeSizeBox.setSelected(false);
        this.nodeSizeBox.addItemListener(this);
        CollapsiblePanel optionsPanel = new CollapsiblePanel("Options");
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 2));
        this.closeDomain = new JButton("Remove Domain");
        final MainWindow window = this.parent;
        this.closeDomain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(DomainView.this.parent.getFrame(), "Do you really want to remove the domain? If you select \"Yes\", all domain values and computations will be lost.", "New Tree", 0);
                if (result == 0) {
                    window.removeDomain(DomainView.this.id);
                }
            }
        });
        checkBoxPanel.add(this.closeDomain);
        checkBoxPanel.add(this.labelBox);
        checkBoxPanel.add(this.nodeSizeBox);
        checkBoxPanel.add(this.markEditableBox);
        checkBoxPanel.add(this.allLabelBox);
        optionsPanel.add(checkBoxPanel);
        optionsPanel.toggleVisibility(true);
        JScrollPane scrollPane = new JScrollPane(this.canvas);
        scrollPane.add(new JLabel("test"));
        this.canvas.setVisible(true);
        scrollPane.setAutoscrolls(true);
        this.canvas.setScrollPane(scrollPane);
        this.add(scrollPane);
        this.add((Component)optionsPanel, "Last");
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        if (this.canvas == null) {
            this.getMainWindow().getStatusBar().reportError("Associated canvas is null");
            return;
        }
        ItemSelectable source = e.getItemSelectable();
        if (source == this.labelBox) {
            if (e.getStateChange() == 2) {
                this.canvas.setShowLabels(false);
            } else {
                this.canvas.setShowLabels(true);
            }
        }
        if (source == this.allLabelBox) {
            if (e.getStateChange() == 2) {
                this.canvas.setShowAllLabels(false);
            } else {
                this.canvas.setShowAllLabels(true);
            }
        }
        if (source == this.markEditableBox) {
            if (e.getStateChange() == 2) {
                this.canvas.setMarkEditable(false);
            } else {
                this.canvas.setMarkEditable(true);
            }
        }
        if (source == this.nodeSizeBox) {
            if (e.getStateChange() == 2) {
                this.canvas.setLocalExtentProvider(false);
            } else {
                this.canvas.setLocalExtentProvider(true);
            }
        }
    }

    public final DomainCanvas<Type> getCanvas() {
        return this.canvas;
    }

    public final int getId() {
        return this.id;
    }

    public MainWindow getMainWindow() {
        return this.parent;
    }

    public final void onClose() {
        this.canvas.getTree().removeTreeChangeListener(this.canvas);
        this.canvas.getTree().deregisterSizeCanvas(this.canvas);
    }

    public final Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("/icons/new.png"));
    }
}

