/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.ChoiceFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import lu.uni.adtool.domains.rings.LMHEValue;
import lu.uni.adtool.ui.InputDialog;

public class LMHEDialog
extends InputDialog {
    static final long serialVersionUID = 66412346112819771L;

    public LMHEDialog(Frame frame) {
        super(frame, "Enter values from the set {L, M, H, E}");
    }

    public final void actionPerformed(ActionEvent e) {
        if ("L".equals(e.getActionCommand())) {
            this.setValue(1.0);
        } else if ("M".equals(e.getActionCommand())) {
            this.setValue(2.0);
        } else if ("H".equals(e.getActionCommand())) {
            this.setValue(3.0);
        } else if ("E".equals(e.getActionCommand())) {
            this.setValue(4.0);
        } else if ("Infinity".equals(e.getActionCommand())) {
            this.setValue(LMHEValue.INF);
        } else if ("\u221e".equals(e.getActionCommand())) {
            this.setValue(LMHEValue.INF);
        } else {
            super.actionPerformed(e);
        }
    }

    protected final boolean isValid(double d) {
        LMHEValue v;
        return d >= 1.0 && d <= 4.0 && (double)(v = new LMHEValue((int)d)).getValue() == d;
    }

    protected final void setValue(double d) {
        this.value = new LMHEValue((int)d);
        this.valueField.setValue(d);
    }

    protected final void createLayout(boolean showDefault) {
        this.errorMsg.setText("You must enter value from the set {L, M, H, E}!");
        double[] choices = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        String[] choiceNames = new String[]{"L", "M", "H", "E", "\u221e"};
        ChoiceFormat f = new ChoiceFormat(choices, choiceNames);
        this.valueField = new JFormattedTextField(f);
        this.valueField.addKeyListener(this);
        if (showDefault) {
            this.valueField.setValue(new Double(((LMHEValue)this.value).getValue()));
        }
        this.valueField.setColumns(15);
        this.valueField.addPropertyChangeListener("value", this);
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 8, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 4;
        inputPane.add((Component)this.valueField, c);
        c.gridwidth = 1;
        c.gridy = 1;
        JButton button = new JButton("L");
        button.setActionCommand("L");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridy = 1;
        c.gridx = 1;
        button = new JButton("M");
        button.setActionCommand("M");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("H");
        button.setActionCommand("H");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        button = new JButton("E");
        button.setActionCommand("E");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        this.contentPane.add((Component)inputPane, "Center");
        this.pack();
    }
}

