/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import lu.uni.adtool.Options;

public class LogView
extends JPanel {
    private static final long serialVersionUID = -1627291937521951134L;
    private LinkedList<String> messages = new LinkedList();
    private JTextPane log;
    private JScrollPane scrollPane;

    public LogView() {
        super(new BorderLayout());
        this.messages.clear();
        this.initLayout();
    }

    private void initLayout() {
        this.log = new JTextPane();
        this.log.setEditable(false);
        this.log.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.log);
        this.scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Message Log:"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add(this.scrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        JButton clearLog = new JButton("Clear Log");
        clearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogView.this.clearLog();
            }
        });
        buttonPanel.add(clearLog);
        this.add((Component)buttonPanel, "Last");
    }

    private void updateText() {
        String text = "<html>";
        for (String s : this.messages) {
            text = text + s + "<br>";
        }
        this.log.setText(text + "</html>");
    }

    private void clearLog() {
        this.messages.clear();
        this.updateText();
    }

    private String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void addMessage(String s) {
        if (this.messages.size() > Options.log_noLinesSaved) {
            this.messages.removeFirst();
        }
        this.messages.add("<font color='gray'>" + this.getTimeStamp() + " - </font>" + s);
        this.updateText();
    }
}

