/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import lu.uni.adtool.domains.rings.RealG0;
import lu.uni.adtool.ui.InputDialog;

public class RealG0Dialog
extends InputDialog {
    static final long serialVersionUID = 458586363646948463L;

    public RealG0Dialog(Frame frame) {
        super(frame, "Enter non-negative real number");
    }

    public void actionPerformed(ActionEvent e) {
        if ("-100".equals(e.getActionCommand())) {
            this.add(-100);
        } else if ("-10".equals(e.getActionCommand())) {
            this.add(-10);
        } else if ("-1".equals(e.getActionCommand())) {
            this.add(-1);
        } else if ("+1".equals(e.getActionCommand())) {
            this.add(1);
        } else if ("+10".equals(e.getActionCommand())) {
            this.add(10);
        } else if ("+100".equals(e.getActionCommand())) {
            this.add(100);
        } else if ("/1000".equals(e.getActionCommand())) {
            this.times(0.001);
        } else if ("/100".equals(e.getActionCommand())) {
            this.times(0.01);
        } else if ("/10".equals(e.getActionCommand())) {
            this.times(0.1);
        } else if ("x10".equals(e.getActionCommand())) {
            this.times(10.0);
        } else if ("x100".equals(e.getActionCommand())) {
            this.times(100.0);
        } else if ("x1000".equals(e.getActionCommand())) {
            this.times(1000.0);
        } else if ("Infinity".equals(e.getActionCommand())) {
            this.setValue(Double.POSITIVE_INFINITY);
        } else if ("Zero".equals(e.getActionCommand())) {
            this.setValue(0.0);
        } else {
            super.actionPerformed(e);
        }
    }

    protected final boolean isValid(double d) {
        RealG0 v;
        return d >= 0.0 && (v = new RealG0(d)).getValue() == d;
    }

    protected final void setValue(double d) {
        this.value = new RealG0(d);
        this.valueField.setValue(d);
    }

    protected void createLayout(boolean showDefault) {
        this.errorMsg.setText("Please enter non-negative real number.");
        DecimalFormat f = new DecimalFormat();
        f.setMaximumFractionDigits(50);
        this.valueField = new JFormattedTextField(f);
        this.valueField.addKeyListener(this);
        if (showDefault) {
            this.valueField.setValue(new Double(((RealG0)this.value).getValue()));
        }
        this.valueField.setColumns(15);
        this.valueField.addPropertyChangeListener("value", this);
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 8, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        JButton button = new JButton("-100");
        button.setActionCommand("-100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        button = new JButton("-10");
        button.setActionCommand("-10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("-1");
        button.setActionCommand("-1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        c.gridwidth = 2;
        inputPane.add((Component)this.valueField, c);
        c.gridwidth = 1;
        c.gridx = 5;
        button = new JButton("+1");
        button.setActionCommand("+1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 6;
        button = new JButton("+10");
        button.setActionCommand("+10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 7;
        button = new JButton("+100");
        button.setActionCommand("+100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridy = 1;
        c.gridx = 0;
        button = new JButton("/1000");
        button.setActionCommand("/1000");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        button = new JButton("/100");
        button.setActionCommand("/100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("/10");
        button.setActionCommand("/10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        button = new JButton("Zero");
        button.setActionCommand("Zero");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 4;
        button = new JButton("Infinity");
        button.setActionCommand("Infinity");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 5;
        button = new JButton("x10");
        button.setActionCommand("x10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 6;
        button = new JButton("x100");
        button.setActionCommand("x100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 7;
        button = new JButton("x1000");
        button.setActionCommand("x1000");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        this.contentPane.add((Component)inputPane, "Center");
        this.pack();
    }

    private void add(int i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid(d + (double)i) || d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.setValue(d += (double)i);
    }

    private void times(double i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid(d * i) || d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.setValue(d *= i);
    }
}

