/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui.printview;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;
import lu.uni.adtool.Options;
import lu.uni.adtool.ui.printview.JPrintPreviewPane;

public class InputPages
extends JTextField
implements MouseListener,
FocusListener,
KeyListener {
    private static final long serialVersionUID = -8002905579485573764L;
    JPrintPreviewPane parent;

    public InputPages(JPrintPreviewPane pane) {
        super(new Integer(Options.print_noPages).toString());
        this.parent = pane;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        this.setEditable(true);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.setEditable(true);
    }

    public void focusLost(FocusEvent e) {
        this.updateData();
    }

    public void keyPressed(KeyEvent e) {
        if (e.isControlDown()) {
            e.getKeyCode();
        } else {
            switch (e.getKeyCode()) {
                case 10: {
                    this.updateData();
                    break;
                }
                case 27: {
                    this.setText(new Integer(Options.print_noPages).toString());
                    this.setEditable(false);
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private void updateData() {
        try {
            int noPages = Integer.parseInt(this.getText());
            if (noPages < 1 && noPages > 5000) {
                throw new NumberFormatException("Number of pages must be greater than zero and less than 5000.");
            }
            if (Options.print_noPages != noPages) {
                Options.print_noPages = noPages;
                this.parent.refreshContent();
            }
        }
        catch (NumberFormatException e) {
            this.setText(new Integer(Options.print_noPages).toString());
        }
        this.parent.requestFocus();
    }
}

