/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui.printview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.Pageable;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import lu.uni.adtool.Options;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.printview.InputPages;
import lu.uni.adtool.ui.printview.JPrintPreviewDialog;
import lu.uni.adtool.ui.printview.JPrintPreviewPage;

public class JPrintPreviewPane
extends JPanel
implements MouseWheelListener,
KeyListener,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1446429545528508602L;
    private static final int[] zoomLevels = new int[]{1000, 500, 300, 250, 200, 150, 100, 75, 50, 25, 15, 10, 5};
    private JPanel content;
    private final JToolBar toolbar = new JToolBar();
    private JScrollPane scrollPane = null;
    private int scaleIndex = 6;
    private JComboBox c3;
    private Pageable pageable;
    private JPrintPreviewDialog parent;
    private Point dragStart = null;

    public JPrintPreviewPane(Pageable newPageable, JPrintPreviewDialog newParent) {
        this.parent = newParent;
        this.setLayout(new BorderLayout());
        this.pageable = newPageable;
        String[] zoomTexts = new String[zoomLevels.length];
        for (int i = 0; i < zoomLevels.length; ++i) {
            zoomTexts[i] = zoomLevels[i] + "%";
        }
        this.c3 = new JComboBox<String>(zoomTexts);
        this.c3.setPrototypeDisplayValue("XXXXX");
        this.c3.setMaximumSize(this.c3.getMinimumSize());
        this.c3.setSelectedIndex(this.scaleIndex);
        ImageIcon zoomIn = new ImageIcon(this.getClass().getResource("/icons/toolbar/zoom_in_24x24.png"));
        AbstractAction zoomInAction = new AbstractAction("Zoom in", zoomIn){
            private static final long serialVersionUID = -3304596518856743876L;

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.zoomIn();
            }
        };
        ImageIcon zoomOutIcon = new ImageIcon(this.getClass().getResource("/icons/toolbar/zoom_out_24x24.png"));
        AbstractAction zoomOutAction = new AbstractAction("Zoom out", zoomOutIcon){
            private static final long serialVersionUID = -4090989151938598959L;

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.zoomOut();
            }
        };
        ImageIcon zoom1Icon = new ImageIcon(this.getClass().getResource("/icons/toolbar/zoom100_24x24.png"));
        AbstractAction zoom1Action = new AbstractAction("1:1 view", zoom1Icon){
            private static final long serialVersionUID = 1997054292801905527L;

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.resetZoom();
            }
        };
        ImageIcon printIcon = new ImageIcon(this.getClass().getResource("/icons/toolbar/print_24x24.png"));
        AbstractAction printAction = new AbstractAction("Print", printIcon){
            private static final long serialVersionUID = 7813036159028737943L;

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.print();
            }
        };
        ImageIcon printSetupIcon = new ImageIcon(this.getClass().getResource("/icons/toolbar/printerSetup_24x24.png"));
        JButton print = new JButton(printAction);
        print.setText(null);
        this.toolbar.add(print);
        print.setMargin(new Insets(0, 0, 0, 0));
        AbstractAction printSetupAction = new AbstractAction("Printer Setup", printSetupIcon){
            private static final long serialVersionUID = 6649324943641291125L;

            public void actionPerformed(ActionEvent evt) {
                ((ADTreeCanvas)JPrintPreviewPane.this.pageable).showPrintDialog(false);
                JPrintPreviewPane.this.refreshContent();
                JPrintPreviewPane.this.requestFocus();
            }
        };
        JButton printSetup = new JButton(printSetupAction);
        printSetup.setText(null);
        this.toolbar.add(printSetup);
        printSetup.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.add(Box.createHorizontalStrut(10));
        JButton c1 = new JButton(zoomOutAction);
        c1.setText(null);
        c1.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.add(c1);
        JButton c1a = new JButton(zoom1Action);
        c1a.setText(null);
        c1a.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.add(c1a);
        JButton c2 = new JButton(zoomInAction);
        c2.setText(null);
        c2.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.add(c2);
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.toolbar.add(this.c3);
        this.c3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.scaleIndex = JPrintPreviewPane.this.c3.getSelectedIndex();
                for (Component obj : JPrintPreviewPane.this.content.getComponents()) {
                    if (!(obj instanceof JPrintPreviewPage)) continue;
                    ((JPrintPreviewPage)obj).setScale((double)zoomLevels[JPrintPreviewPane.this.scaleIndex] / 100.0, (double)zoomLevels[JPrintPreviewPane.this.scaleIndex] / 100.0);
                }
                JPrintPreviewPane.this.content.revalidate();
                JPrintPreviewPane.this.requestFocus();
            }
        });
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.toolbar.add(new JLabel("Number of pages:"));
        this.toolbar.add(new InputPages(this));
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.parent.setDefaultCloseOperation(2);
        JButton close = new JButton();
        close.setText("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPrintPreviewPane.this.closeActionPerformed();
            }
        });
        this.toolbar.add(close);
        this.add((Component)this.toolbar, "North");
        this.createContent();
        this.setFocusTraversalKeysEnabled(true);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
    }

    public void refreshContent() {
        this.remove(this.scrollPane);
        this.createContent();
    }

    private void resetZoom() {
        this.scaleIndex = 5;
        this.scaleUpdated();
        this.requestFocus();
    }

    private void zoomIn() {
        --this.scaleIndex;
        this.scaleIndex = Math.max(0, this.scaleIndex);
        this.scaleUpdated();
        this.requestFocus();
    }

    private void zoomOut() {
        ++this.scaleIndex;
        this.scaleIndex = Math.min(zoomLevels.length - 1, this.scaleIndex);
        this.scaleUpdated();
        this.requestFocus();
    }

    private void scaleUpdated() {
        this.c3.setSelectedIndex(this.scaleIndex);
        for (Component obj : this.content.getComponents()) {
            if (!(obj instanceof JPrintPreviewPage)) continue;
            ((JPrintPreviewPage)obj).setScale((double)zoomLevels[this.scaleIndex] / 100.0, (double)zoomLevels[this.scaleIndex] / 100.0);
        }
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    public void scrollBy(int x, int y) {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getValue() - y);
        bar = this.scrollPane.getHorizontalScrollBar();
        bar.setValue(bar.getValue() - x);
    }

    private void createScrollPane() {
        this.scrollPane = new JScrollPane(this.content, 22, 32);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(25);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setWheelScrollingEnabled(false);
        this.scrollPane.addMouseWheelListener(this);
        this.scrollPane.addMouseMotionListener(this);
        this.scrollPane.addMouseListener(this);
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                break;
            }
            case 38: {
                this.scrollUnit(this.scrollPane.getVerticalScrollBar(), -1);
                break;
            }
            case 40: {
                this.scrollUnit(this.scrollPane.getVerticalScrollBar(), 1);
                break;
            }
            case 37: {
                this.scrollUnit(this.scrollPane.getHorizontalScrollBar(), -1);
                break;
            }
            case 39: {
                this.scrollUnit(this.scrollPane.getHorizontalScrollBar(), 1);
                break;
            }
            case 33: {
                if (e.isShiftDown()) {
                    this.scrollBlock(this.scrollPane.getHorizontalScrollBar(), -1);
                    break;
                }
                this.scrollBlock(this.scrollPane.getVerticalScrollBar(), -1);
                break;
            }
            case 34: {
                if (e.isShiftDown()) {
                    this.scrollBlock(this.scrollPane.getHorizontalScrollBar(), 1);
                    break;
                }
                this.scrollBlock(this.scrollPane.getVerticalScrollBar(), 1);
                break;
            }
            case 61: 
            case 107: 
            case 521: {
                this.zoomIn();
                break;
            }
            case 45: 
            case 109: {
                this.zoomOut();
                break;
            }
            case 27: {
                this.closeActionPerformed();
                break;
            }
            case 80: {
                this.print();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private void createContent() {
        this.content = new JPanel();
        Point dim = ((ADTreeCanvas)this.pageable).getColsRows(this.pageable.getNumberOfPages());
        int x = (int)dim.getX();
        int y = (int)dim.getY();
        this.content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.content.setBackground(Options.printview_background);
        c.insets = new Insets(0, 8, 0, 0);
        for (int j = 0; j < y; ++j) {
            for (int i = 0; i < x; ++i) {
                c.gridx = i;
                c.gridy = j;
                JPrintPreviewPage p = new JPrintPreviewPage(this.pageable, j * x + i);
                p.setScale((double)zoomLevels[this.scaleIndex] / 100.0, (double)zoomLevels[this.scaleIndex] / 100.0);
                this.content.add((Component)p, c);
            }
            this.createScrollPane();
        }
        this.revalidate();
    }

    private void closeActionPerformed() {
        this.parent.dispose();
    }

    private void scrollUnit(JScrollBar bar, int direction) {
        int amount = bar.getUnitIncrement(direction);
        bar.setValue(bar.getValue() + direction * amount);
    }

    private void scrollBlock(JScrollBar bar, int direction) {
        int amount = bar.getBlockIncrement(direction);
        bar.setValue(bar.getValue() + direction * amount);
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
    }

    public void mousePressed(MouseEvent e) {
        this.dragStart = new Point(e.getX(), e.getY());
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragStart != null) {
            this.scrollBy(e.getX() - (int)this.dragStart.getX(), e.getY() - (int)this.dragStart.getY());
            this.dragStart = new Point(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragStart = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    private void print() {
        if (((ADTreeCanvas)this.pageable).showPrintDialog(true)) {
            this.refreshContent();
            this.closeActionPerformed();
        }
        this.scrollPane.requestFocus();
    }
}

