/*
 *  hash.h
 *
 *  Created on: 01-11-2010
 *      Author: Piotr Kordy
 */

#ifndef HASH_H
#define HASH_H

#include <inttypes.h>

// Shift-Add-XOR hash
template<class ForwardIterator>
static inline uint32_t sax_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key ^= ( key << 5 ) + ( key >> 2 ) + *beg;
    }
    return key;
}

// Rotating hash
template<class ForwardIterator>
static inline uint32_t rot_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key = ( key << 4 ) ^ ( key >> 28 ) ^ *beg;
    }
    return key;
}

// Bernstein hash
template<class ForwardIterator>
static inline uint32_t djb_hash(ForwardIterator beg, ForwardIterator end, uint32_t key=0) {
    for ( ; beg != end; ++beg) {
	key = 33 * key + *beg;
    }
    return key;
}

#endif /* HASH_H */
