/*
 *  helper.h
 *
 *  Created on: 01-11-2010
 *      Author: Piotr Kordy
 */
#ifndef COMMON_HELPER_H
#define COMMON_HELPER_H

#include <iostream>
#include <stdint.h>
#include <vector>

#define NOT_IMPLEMENTED std::cout << __PRETTY_FUNCTION__ << " not implemented" << std::endl;

template<class FwdIterator>
static inline void deletePtrs(FwdIterator beg, FwdIterator end) {
    for (; beg != end; ++beg) {
	delete *beg;
    }
}

template<class T>
static inline void deleteVector(std::vector<T*>& vec) {
/*     deletePtrs(vec.begin(), vec.end()); */
}

template<class ForwardIterator>
static inline std::ostream& printPtrContainer(ForwardIterator beg, ForwardIterator end, const std::string& sep, std::ostream& o) {
    while (beg != end) {
	o << **beg;
	++beg;
	if (beg != end) {
	    o << sep;
	}
    }
    return o;
}

template<class ForwardIterator>
static inline std::ostream& printContainer(ForwardIterator beg, ForwardIterator end, const std::string& sep, std::ostream& o) {
    while (beg != end) {
	o << *beg;
	++beg;
	if (beg != end) {
	    o << sep;
	}
    }
    return o;
}

template<class T>
static inline std::ostream& printPtrVector(const std::vector<T*>& vec, const std::string& sep, std::ostream& o) {
    return printPtrContainer(vec.begin(), vec.end(), sep, o);
}

#endif /* COMMON_HELPER_H */
