/*
 * ============================================================================
 *
 *       Filename:  reachability_test.cc
 *
 *    Description:  Tests for reachability
 *
 *        Version:  1.0
 *        Created:  25/01/2013 
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *        Company:
 *
 * ============================================================================
 */
#include "models.h"
#include "gtest/gtest.h"
#include "common/global_func.h"
#include "search/search_engine.h"

#include <utap/utap.h>

// class SystemParserTest;
// class SystemParserTest : public testing::Test{
// protected:
// };
void doexplore(search_opt kind,SearchEngine::status_t result,std::string name,std::string qname) {
//   LocalLUNormalizer::floors.clear();
//   LocalLUNormalizer::ceils.clear();
  Options opts(kind,STATISTIC_TRACE, LU_LOCAL, false,false,true);
//   Options opts(kind,STATISTIC_TRACE, MAX, false,false,true);
  Task* task = SystemParser::parse(name, qname, opts.new_syntax);
  SearchEngine* engine = newSearchEngine(opts, task);
  engine->explore();
  EXPECT_EQ(engine->stat,result);
  deleteSearchEngine(opts, engine);
  delete task;
}

TEST(SystemParserTest,checkFile){
  std::string name="_temp.xml";
  std::string qname="_temp.q";
  createFile(name,non_robust1);
  createFile(qname,error_goal);
  doexplore(DFS_SEARCH,SearchEngine::UNSAT,name,qname);    
  doexplore(DFS_STAR_SEARCH,SearchEngine::SAT,name,qname);    
  remove(name.c_str());
  remove(qname.c_str());
  EXPECT_EQ(SystemParser::check_file(name.c_str()),false);
  EXPECT_EQ(SystemParser::check_file(qname.c_str()),false);
}
