/*
 * ============================================================================
 *
 *       Filename:  state_test.cc
 *
 *    Description:  Tests for state, StateBuilder
 *
 *        Version:  1.0
 *        Created:  25/01/2013 
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *        Company:
 *
 * ============================================================================
 */
#include "models.h"
#include "gtest/gtest.h"
#include "common/global_func.h"
#include "search/search_engine.h"
#include "search/closed_list.h"
#include "system/systemparser.h"
#include "system/systembuilder.h"
#include "system/system.h"
#include "system/state.h"

#include <utap/utap.h>

// class SystemParserTest;
// class SystemParserTest : public testing::Test{
// protected:
// };

TEST(ClosedListTest,addingRemoving){
  std::string name="_temp.xml";
  createFile(name,model1);
  UTAP::TimedAutomataSystem tasystem;
  parseXMLFile(name.c_str(), &tasystem, true);
  ASSERT_TRUE(tasystem.getErrors().empty());
  ASSERT_TRUE(tasystem.getWarnings().empty());
  SystemBuilder builder;
  System* system = builder.buildSystem(&tasystem);
  State* state=system->createInitial();
  ClosedList *passed= new ClosedList();
  EXPECT_EQ(passed->size(),0);
  passed->insert(state);
  EXPECT_EQ(passed->size(),1);
  EXPECT_EQ(passed->contains(state),true);
  State* state2=state->clone();
  State* state3=state->clone();
  state2->setLocationNr(0,1);
  EXPECT_EQ(passed->contains(state2),false);
  passed->insert(state2);
  EXPECT_EQ(passed->size(),2);
  if(!(passed->insert(state3))){
    std::cerr<<"Not inserting state3\n";
    State::destroy(state3);
  }
  else{
    std::cerr<<"Inserting state3\n";
  }
  EXPECT_EQ(passed->contains(state2),true);
  passed->destroyExceptDP(state);
  EXPECT_EQ(passed->size(),0);
  EXPECT_EQ(passed->contains(state2),false);
//   remove(name.c_str());
  delete passed;
  State::destroy(state);
  
  std::cerr<<"deleted passed\n";
}
