/*
 *  flyweight.h
 *
 *  Created on: 01-11-2010
 *      Author: Piotr Kordy
 */

#ifndef FLYWEIGHT_H
#define FLYWEIGHT_H

#include <vector>
#include <iostream>
#include <utility>
#include <stdint.h>

template<class T>
class Flyweight {
private:
  typedef typename std::vector<T*> vec_t;
  typedef typename vec_t::iterator iterator;
  typedef typename vec_t::const_iterator const_iterator;
  vec_t data;

public:
  Flyweight() {
    data.clear();
  }
  ~Flyweight() {
    for (uint32_t i = 0; i < data.size(); i++) {
/*       std::cerr<<"-fly--deleting size"<<data.size()<<" addres:"<<data[i]<<"\n"; */
      delete (T*) data[i];
    }
  }

  std::pair<T*, bool> insert(T* elem) {
    for (uint32_t i = 0; i < data.size(); i++) {
      if (data[i]->equals(elem)) {
/*         std::cerr<<"-fly--deleting "<<elem<<"\n"; */
        delete (T*) elem;
/*         std::cerr<<"-fly--deleted "<<data.size()<<"\n"; */
        return std::make_pair(data[i], false);
      }
    }
    data.push_back(elem);
/*     std::cerr<<"-fly--added "<<data.size()<< " elem="<<elem<<" data="<<data.back()<<"\n"; */
    return std::make_pair(data.back(), true);
  }
  uint32_t size() const { return data.size(); }
};
#endif /* FLYWEIGHT_H */
