/*
 * ============================================================================
 *
 *       Filename:  systemparser_test.cc
 *
 *    Description:  Tests for SystemParser class
 *
 *        Version:  1.0
 *        Created:  19/01/2013 
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *        Company:
 *
 * ============================================================================
 */
#include "models.h"
#include "gtest/gtest.h"
#include "system/systemparser.h"
#include "system/systembuilder.h"
#include "system/system.h"

#include <utap/utap.h>

// class SystemParserTest;
// class SystemParserTest : public testing::Test{
// protected:
// };
TEST(ReachabilityTest,checkNormal){
  std::string name="_temp.txt";
  std::string content="some content";
  createFile(name,content);
  EXPECT_EQ(SystemParser::check_file(name.c_str()),true);
  remove(name.c_str());
  EXPECT_EQ(SystemParser::check_file(name.c_str()),false);
  
}
TEST(ReachabilityTest,checkRobust){
  std::string name="_temp.xml";
  createFile(name,model1);
  UTAP::TimedAutomataSystem tasystem;
  parseXMLFile(name.c_str(), &tasystem, true);
  ASSERT_TRUE(tasystem.getErrors().empty());
  ASSERT_TRUE(tasystem.getWarnings().empty());
  SystemBuilder builder;
  System* system = builder.buildSystem(&tasystem);
  EXPECT_EQ(system->getNrProcesses(),2u);
  EXPECT_EQ(system->getNrClocks(),1u);
  EXPECT_EQ(system->getTotalNrClocks(),1u);
  EXPECT_EQ(system->getTotalNrIntegers(),2u);
  EXPECT_EQ(system->getTotalNrLocations(),2u);
  EXPECT_EQ(system->getTotalNrChannels(),0u);
  builder.removeSystem(system);
  remove(name.c_str());

}
