/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import gui.popupMenu.OperatorPopup;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLOperation;

public class SLOperator
extends JPanel {
    private static final int FUSION = 100;
    private static final int DILUTION = 101;
    private static final int AND = 102;
    private static final int OR = 103;
    private int type;
    public static final int LEFT = 1000;
    public static final int RIGHT = 1001;
    public static final int COPY = 1002;
    public static final int DUPLICATE_LEFT = 1003;
    public static final int DUPLICATE_RIGHT = 1004;
    private SLOperation parent;
    private static final double MY_CONSTANT = 0.14644661;

    public static String getOperatorName(int operator) {
        switch (operator) {
            case 100: {
                return "Fusion";
            }
            case 101: {
                return "Dilution";
            }
            case 102: {
                return "AND";
            }
            case 103: {
                return "OR";
            }
        }
        throw new RuntimeException("Operator does not exist.");
    }

    public SLOperator(int type, SLOperation parent) {
        this.parent = parent;
        this.type = type;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int[] ops = new int[]{100, 101, 102, 103};
                    OperatorPopup menu = new OperatorPopup((SLOperator)e.getSource(), ops);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void paint(Graphics g) {
        int maxL = Math.min(this.getWidth() - 1, this.getHeight() - 1);
        int cpos = (int)(0.14644661 * (double)maxL);
        g.setColor(Color.BLACK);
        switch (this.type) {
            case 100: {
                g.drawOval(0, 0, maxL, maxL);
                g.drawLine(0, maxL / 2, maxL, maxL / 2);
                g.drawLine(maxL / 2, 0, maxL / 2, maxL);
                break;
            }
            case 101: {
                g.drawOval(0, 0, maxL, maxL);
                g.drawLine(cpos, cpos, maxL - cpos, maxL - cpos);
                g.drawLine(maxL - cpos, cpos, cpos, maxL - cpos);
                break;
            }
            case 102: {
                g.drawOval(0, 0, maxL, maxL);
                g.drawLine(cpos, maxL - cpos, maxL / 2, 0);
                g.drawLine(maxL - cpos, maxL - cpos, maxL / 2, 0);
                break;
            }
            case 103: {
                g.drawOval(0, 0, maxL, maxL);
                g.drawLine(cpos, cpos, maxL / 2, maxL);
                g.drawLine(maxL - cpos, cpos, maxL / 2, maxL);
                break;
            }
            default: {
                throw new RuntimeException("Operator type does not exist.");
            }
        }
    }

    public Opinion applyOperator(Opinion left, Opinion right) {
        Opinion result;
        switch (this.type) {
            case 100: {
                double[] x = left.getFormat(2);
                double[] y = right.getFormat(2);
                if (Double.isInfinite(x[1]) || Double.isInfinite(y[1])) {
                    if (!Double.isInfinite(x[1])) {
                        return right;
                    }
                    if (!Double.isInfinite(y[1])) {
                        return left;
                    }
                    if (x[0] == y[0]) {
                        return left;
                    }
                    result = new Opinion(false);
                    break;
                }
                if (x[1] + y[1] == 0.0) {
                    return new Opinion(Opinion.arbitrary(0.0, 1.0), 0.0, 2);
                }
                result = new Opinion((x[0] * x[1] + y[0] * y[1]) / (x[1] + y[1]), x[1] + y[1], 2);
                break;
            }
            case 101: {
                double[] x = left.getFormat(0);
                double[] y = right.getFormat(0);
                result = new Opinion(x[0] * y[0], x[0] * y[1], 0);
                break;
            }
            case 102: {
                double[] x = left.getFormat(0);
                double[] y = right.getFormat(0);
                result = new Opinion(x[0] * y[0], x[1] + y[1] - x[1] * y[1], 0);
                break;
            }
            case 103: {
                double[] x = left.getFormat(0);
                double[] y = right.getFormat(0);
                result = new Opinion(x[0] + y[0] - x[0] * y[0], x[1] * y[1], 0);
                break;
            }
            default: {
                throw new RuntimeException("Operator type does not exist.");
            }
        }
        return result;
    }

    public Opinion getLeftNeutralElement(int opType) {
        switch (this.type) {
            case 100: {
                return new Opinion(0.0, 0.0, 0).getByType(opType);
            }
            case 101: {
                return new Opinion(1.0, 0.0, 0).getByType(opType);
            }
            case 102: {
                return new Opinion(1.0, 0.0, 0).getByType(opType);
            }
            case 103: {
                return new Opinion(0.0, 1.0, 0).getByType(opType);
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }

    public Opinion getRightNeutralElement(int opType) {
        switch (this.type) {
            case 100: {
                return new Opinion(0.0, 0.0, 0).getByType(opType);
            }
            case 101: {
                throw new RuntimeException("Dilution has no right-neutral element.");
            }
            case 102: {
                return new Opinion(1.0, 0.0, 0).getByType(opType);
            }
            case 103: {
                return new Opinion(0.0, 1.0, 0).getByType(opType);
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }

    public Opinion getLeftZeroElement(int opType) {
        switch (this.type) {
            case 100: {
                throw new RuntimeException("Fusion has infinitely many zero elements.");
            }
            case 101: {
                throw new RuntimeException("Dilution has infinitely many left-zero elements.");
            }
            case 102: {
                return new Opinion(0.0, 1.0, 0).getByType(opType);
            }
            case 103: {
                return new Opinion(1.0, 0.0, 0).getByType(opType);
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }

    public Opinion getRightZeroElement(int opType) {
        switch (this.type) {
            case 100: {
                throw new RuntimeException("Fusion has infinitely many zero elements.");
            }
            case 101: {
                return new Opinion(0.0, 0.0, 0).getByType(opType);
            }
            case 102: {
                return new Opinion(0.0, 1.0, 0).getByType(opType);
            }
            case 103: {
                return new Opinion(1.0, 0.0, 0).getByType(opType);
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }

    public void switchTo(int i) {
        this.type = i;
        this.parent.updateOperator();
        this.repaint();
    }

    public boolean isAssociative() {
        switch (this.type) {
            case 100: {
                return true;
            }
            case 101: {
                return false;
            }
            case 102: {
                return true;
            }
            case 103: {
                return true;
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 100: {
                return "\u2295";
            }
            case 101: {
                return "\u2297";
            }
            case 102: {
                return "\u2227";
            }
            case 103: {
                return "\u2228";
            }
        }
        throw new RuntimeException("Non-existing operator called.");
    }
}

