/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import subjectiveLogic.SLCalculation;

public class SPGraph
extends JPanel {
    private SubGraph sg;

    public SPGraph(SLCalculation s) {
        this.redraw(s);
    }

    void redraw(SLCalculation s) {
        this.sg = new SubGraph(s);
    }

    @Override
    public void paint(Graphics g) {
        this.sg.drawMe(g, 50, 50);
    }

    private class SubGraph {
        private int height;
        private int width;
        private int ySource;
        private int ySink;
        private int opType;
        private SubGraph[] sgs;
        private String name;
        private static final int EDGE = 0;
        private static final int PARALLEL = 1;
        private static final int SERIAL = 2;
        private final int edgeWidth = 20;
        private final int minHeight = 18;

        public SubGraph(SLCalculation s) {
            LinkedList<SLCalculation> slc = s.getAllSubtermsModuloAssociativity(s.getOperatorInt());
            if (s.getOperatorInt() >= 0) {
                this.sgs = new SubGraph[slc.size()];
                Iterator it = slc.iterator();
                int i = 0;
                while (i < this.sgs.length) {
                    this.sgs[i] = new SubGraph((SLCalculation)it.next());
                    if (s.getOperatorInt() == 100) {
                        this.height += this.sgs[i].height;
                        this.width = Math.max(this.width, this.sgs[i].width);
                        this.opType = 1;
                    } else if (s.getOperatorInt() == 101) {
                        this.height = Math.max(this.height, this.sgs[i].height);
                        this.width += this.sgs[i].width;
                        this.opType = 2;
                    }
                    ++i;
                }
                this.width += 40;
                this.ySource = this.height / 2;
                this.ySink = this.height / 2;
                this.name = "wat";
            } else {
                this.height = 18;
                this.ySource = 9;
                this.ySink = 9;
                this.width += 20;
                this.name = s.toString();
                this.opType = 0;
            }
        }

        public void drawMe(Graphics g, int hOffset, int vOffset) {
            if (this.opType == 0) {
                g.setColor(Color.BLUE);
                g.drawLine(hOffset, vOffset + this.ySource, hOffset + this.width, vOffset + this.ySink);
                g.drawString(this.name, hOffset + 8, vOffset + this.ySource - 3);
            } else if (this.opType == 1) {
                int xtraVOffset = 0;
                int i = 0;
                while (i < this.sgs.length) {
                    g.setColor(Color.RED);
                    g.drawLine(hOffset, vOffset + this.ySource, hOffset + 20, vOffset + xtraVOffset + this.sgs[i].ySource);
                    g.setColor(Color.GREEN);
                    g.drawLine(hOffset + this.width - 20, vOffset + xtraVOffset + this.sgs[i].ySink, hOffset + this.width, vOffset + this.ySink);
                    this.sgs[i].drawMe(g, hOffset + 20, vOffset + xtraVOffset);
                    xtraVOffset += this.sgs[i].height;
                    ++i;
                }
            } else if (this.opType == 2) {
                int xtraHOffset = 0;
                int i = 0;
                while (i < this.sgs.length) {
                    this.sgs[i].drawMe(g, hOffset + xtraHOffset, vOffset);
                    xtraHOffset += this.sgs[i].width;
                    ++i;
                }
            }
            g.setColor(Color.BLACK);
        }
    }
}

