/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.TreeSet;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLOperator;

public class OpinionShape_Sweep
implements Iterable<Opinion> {
    private boolean isComplete;
    private Collection<Opinion> opinions;
    private TreeSet<Vertex> vertices;
    private Collection<Triangle> triangles;
    private Collection<TreeSet<Vertex>> monotones;

    public OpinionShape_Sweep() {
        this.isComplete = false;
        this.opinions = new LinkedList<Opinion>();
        this.vertices = new TreeSet();
    }

    public OpinionShape_Sweep(SLCalculation left, SLOperator op, SLCalculation right) {
        this.opinions = new LinkedList<Opinion>();
        this.isComplete = false;
    }

    public OpinionShape_Sweep(Opinion opinion) {
        this.opinions = new LinkedList<Opinion>();
        this.opinions.add(opinion);
        this.isComplete = true;
    }

    public void add(Opinion op) {
        if (this.isComplete) {
            throw new RuntimeException("Cannot add element to completed figure.");
        }
        this.opinions.add(op);
    }

    public void complete() {
        this.isComplete = true;
        this.vertices = Vertex.create(this.opinions);
        this.monotones = Vertex.monotonize(this.vertices);
    }

    public boolean isCompleted() {
        return this.isComplete;
    }

    @Override
    public Iterator iterator() {
        if (!this.isComplete) {
            return this.opinions.iterator();
        }
        return new Iterator<Iterator<Opinion>>(){
            LinkedList<TreeSet<Vertex>> m;
            int i;
            {
                this.m = (LinkedList)OpinionShape_Sweep.this.monotones;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i != this.m.size();
            }

            @Override
            public Iterator<Opinion> next() {
                TreeSet<Vertex> ts = this.m.get(this.i);
                ++this.i;
                return new Iterator<Opinion>(ts){
                    Vertex cur;
                    Vertex first;
                    boolean f;
                    {
                        this.cur = (Vertex)treeSet.first();
                        this.first = (Vertex)treeSet.first();
                        this.f = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.f) {
                            return !this.cur.opinion.equals(this.first.opinion);
                        }
                        return true;
                    }

                    @Override
                    public Opinion next() {
                        this.cur = this.cur.next;
                        this.f = true;
                        return this.cur.opinion;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Cannot remove vertex.");
                    }
                };
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot remove monotone polygon.");
            }
        };
    }

    public static class Triangle {
        private Vertex v1;
        private Vertex v2;
        private Vertex v3;

        public Triangle(Vertex v1, Vertex v2, Vertex v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public static Collection<Triangle> triangulate(TreeSet<Vertex> vertices) {
            LinkedList<Triangle> result = new LinkedList<Triangle>();
            Collection<TreeSet<Vertex>> monos = Vertex.monotonize(vertices);
            for (Collection collection : monos) {
                Vertex left = null;
                Vertex right = null;
                for (Vertex vertex : collection) {
                    if (left != null && right != null) {
                        result.add(new Triangle(vertex, left, right));
                        if (left.prev.opinion.equals(vertex.opinion) || left.next.opinion.equals(vertex.opinion)) {
                            left = vertex;
                            continue;
                        }
                        if (right.prev.opinion.equals(vertex.opinion) || right.next.opinion.equals(vertex.opinion)) {
                            right = vertex;
                            continue;
                        }
                        throw new RuntimeException("Kak..");
                    }
                    right = left;
                    left = vertex;
                }
            }
            return result;
        }

        public Opinion[] getOpinions() {
            Opinion[] result = new Opinion[]{this.v1.opinion, this.v2.opinion, this.v3.opinion};
            return result;
        }
    }

    public static class Vertex {
        private Opinion opinion;
        private LinkedList<Triangle> triangles;
        private Vertex prev;
        private Vertex next;

        public Vertex(Opinion opinion, Vertex prev, Vertex next) {
            this.opinion = opinion;
            this.prev = prev;
            this.next = next;
        }

        public static TreeSet<Vertex> create(Collection<Opinion> opinions) {
            TreeSet<Vertex> result = new TreeSet<Vertex>(new Comparator<Vertex>(){

                @Override
                public int compare(Vertex o1, Vertex o2) {
                    return o1.opinion.compareUncertainty(o2.opinion);
                }
            });
            Vertex old = null;
            Vertex first = null;
            for (Opinion op : opinions) {
                if (old != null && op.equals(old.opinion)) continue;
                Vertex v = new Vertex(op, old, null);
                if (old == null) {
                    first = v;
                } else {
                    old.next = v;
                }
                old = v;
                result.add(v);
            }
            old.next = first;
            first.prev = old;
            return result;
        }

        public static Collection<TreeSet<Vertex>> monotonize(TreeSet<Vertex> vertices) {
            Collection<TreeSet<Vertex>> intermediate = Vertex.monotonizeDown(vertices);
            LinkedList<TreeSet<Vertex>> result = new LinkedList<TreeSet<Vertex>>();
            for (TreeSet<Vertex> inter : intermediate) {
                result.addAll(Vertex.monotonizeDown(inter.descendingSet()));
            }
            return result;
        }

        public static Collection<TreeSet<Vertex>> monotonizeDown(NavigableSet<Vertex> vertices) {
            boolean clockwise = false;
            Vertex old = null;
            LinkedList<Edge> ins = new LinkedList<Edge>();
            int sign = 0;
            for (Vertex v : vertices) {
                if (old == null) {
                    clockwise = v.next.opinion.compareBeliefRate(v.prev.opinion) > 0;
                    System.out.println("Clockwise: " + clockwise);
                    System.out.println(v.opinion.toString());
                    Vertex c = v;
                    while (sign == 0) {
                        System.out.println("Needed loop");
                        c = c.next;
                        sign = (byte)v.opinion.compareUncertainty(c.opinion);
                    }
                    System.out.println(sign);
                }
                if (v.next.opinion.compareUncertainty(v.opinion) == 0) {
                    System.out.println("Equals uncertainty (debug: " + vertices.size() + "): " + v.next.opinion.toString(0) + ", " + v.opinion.toString(0));
                }
                if (v.prev.opinion.compareUncertainty(v.opinion) == 0) {
                    System.out.println("Equals uncertainty (debug: " + vertices.size() + "): " + v.prev.opinion.toString(0) + ", " + v.opinion.toString(0));
                }
                if (v.next.opinion.compareUncertainty(v.opinion) * sign < 0 && v.prev.opinion.compareUncertainty(v.opinion) * sign < 0) {
                    boolean outside = clockwise == v.next.opinion.compareBeliefRate(v.prev.opinion) > 0;
                    System.out.println("Top (" + outside + "): " + v.opinion.toString(0));
                    if (!outside) {
                        System.out.println("-> " + old.opinion.toString(0));
                        ins.add(new Edge(v, old));
                    }
                }
                old = v;
            }
            LinkedList<TreeSet<Vertex>> result = Vertex.removeEdges(vertices, ins);
            return result;
        }

        public static LinkedList<TreeSet<Vertex>> removeEdges(NavigableSet<Vertex> vs, Collection<Edge> ins) {
            for (Edge edge : ins) {
                Vertex e2;
                Vertex e1 = new Vertex(((Edge)edge).in.opinion, ((Edge)edge).in.prev, edge.out);
                ((Edge)edge).in.prev = e2 = new Vertex(((Edge)edge).out.opinion, ((Edge)edge).out.prev, edge.in);
                ((Edge)edge).out.prev = e1;
                e1.prev.next = e1;
                e2.prev.next = e2;
            }
            LinkedList<TreeSet<Vertex>> result = new LinkedList<TreeSet<Vertex>>();
            while (!vs.isEmpty()) {
                Vertex v = (Vertex)vs.first();
                TreeSet<Vertex> poly = new TreeSet<Vertex>(new Comparator<Vertex>(){

                    @Override
                    public int compare(Vertex o1, Vertex o2) {
                        return o1.opinion.compareUncertainty(o2.opinion);
                    }
                });
                poly.add(v);
                vs.remove(v);
                Vertex cur = v.next;
                while (!cur.equals(v)) {
                    poly.add(cur);
                    vs.remove(cur);
                    cur = cur.next;
                }
                result.add(poly);
            }
            return result;
        }

        public Opinion getOpinion() {
            return this.opinion;
        }

        private static class Edge {
            private Vertex in;
            private Vertex out;

            public Edge(Vertex in, Vertex out) {
                this.in = in;
                this.out = out;
            }
        }
    }
}

