/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Point;
import java.util.LinkedList;
import javax.swing.JLabel;
import subjectiveLogic.Opinion;
import subjectiveLogic.OpinionRegistry;
import subjectiveLogic.OpinionShape_Sweep;
import subjectiveLogic.SLBeta;
import subjectiveLogic.SLCalcContainer;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLData;
import subjectiveLogic.SLFigure;
import subjectiveLogic.SLFormula;
import subjectiveLogic.SLSquare;
import subjectiveLogic.SLTriangle;
import subjectiveLogic.SLWeighted;

public class SLObject
extends SLCalculation {
    private static final int H_SPACING = 6;
    private static final int V_SPACING = 6;
    private SLFigure figure;
    private SLData data;
    private double decay;
    private boolean passive;
    private JLabel name;

    public SLObject(double decay, int type, Opinion initOp, SLCalcContainer p, boolean passive) {
        this(decay, type, initOp, p, passive, new SLFormula(passive ? "result" : SLObject.getLiteral()));
    }

    public SLObject(double decay, int type, Opinion initOp, SLCalcContainer p, boolean passive, SLFormula formula) {
        this.setLayout(null);
        this.formula = formula;
        this.name = new JLabel(formula.toString());
        this.name.setFont(this.name.getFont().deriveFont(16.0f));
        this.name.setSize(this.name.getPreferredSize());
        this.name.setLocation(6, 0);
        this.add(this.name);
        this.isCompound = false;
        this.parent = p;
        this.decay = decay;
        this.opinionType = type;
        this.opinion = initOp;
        this.passive = passive;
        switch (type) {
            case 0: {
                this.figure = new SLTriangle(initOp, this, passive);
                this.data = new SLData(initOp, this, type, passive);
                break;
            }
            case 1: {
                this.figure = new SLSquare(initOp, this, passive);
                this.data = new SLData(initOp, this, type, passive);
                break;
            }
            case 2: {
                this.figure = new SLWeighted(initOp, this, passive);
                this.data = new SLData(initOp, this, type, passive);
                break;
            }
            case 3: {
                this.figure = new SLBeta(initOp, this, passive);
                this.data = new SLData(initOp, this, type, passive);
                break;
            }
            case 100: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 101: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 102: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 103: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            default: {
                throw new RuntimeException("Non-existing constant provided.");
            }
        }
        this.add(this.figure);
        this.add(this.data);
        OpinionRegistry.register(this);
    }

    @Override
    public void update(Opinion op, int sender) {
        if (this.passive) {
            throw new RuntimeException("Input provided to output figure.");
        }
        this.figure.setOpinion(op);
        this.data.setOpinion(op);
        this.opinion = op;
        OpinionRegistry.pushUpdatesOf(this.formula.toString());
        if (this.parent != null) {
            this.parent.update(op, this.ID);
        }
    }

    @Override
    public void update(OpinionShape_Sweep os, int ID) {
        if (this.passive) {
            throw new RuntimeException("Input provided to output figure.");
        }
        this.figure.setOpinionShape(os);
        this.opinions = os;
        if (this.parent != null) {
            this.parent.update(os, ID);
        }
    }

    protected void setOpinion(Opinion op) {
        this.opinion = op;
        this.figure.setOpinion(op);
        this.data.setOpinion(op);
    }

    public void setOpinionShape(OpinionShape_Sweep opinions) {
        this.figure.setOpinionShape(opinions);
    }

    @Override
    public int relocate(Point location, int height, double decay) {
        this.setLocation(location);
        int v_spacing = 6;
        int h_spacing = 6;
        int fHeight = (height - this.name.getHeight() - 3 * v_spacing) / 2;
        int dHeight = (height - this.name.getHeight() - 3 * v_spacing) / 2;
        int width = this.figure.setHeight(fHeight) + 2 * h_spacing;
        this.figure.setLocation(h_spacing, v_spacing + this.name.getHeight());
        this.data.setSize(width - 2 * h_spacing, dHeight);
        this.data.setLocation(h_spacing, 2 * v_spacing + fHeight + this.name.getHeight());
        this.setSize(width, height);
        this.decay = decay;
        this.repaint();
        return width;
    }

    @Override
    public void updateRepresentation(int type) {
        this.remove(this.figure);
        this.remove(this.data);
        this.opinionType = type;
        switch (type) {
            case 0: {
                this.figure = new SLTriangle(this.opinion, this, this.passive);
                this.data = new SLData(this.opinion, this, type, this.passive);
                break;
            }
            case 1: {
                this.figure = new SLSquare(this.opinion, this, this.passive);
                this.data = new SLData(this.opinion, this, type, this.passive);
                break;
            }
            case 2: {
                this.figure = new SLWeighted(this.opinion, this, this.passive);
                this.data = new SLData(this.opinion, this, type, this.passive);
                break;
            }
            case 3: {
                this.figure = new SLBeta(this.opinion, this, this.passive);
                this.data = new SLData(this.opinion, this, type, this.passive);
                break;
            }
            case 100: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 101: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 102: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            case 103: {
                throw new RuntimeException("SLObject may not be a compound object.");
            }
            default: {
                throw new RuntimeException("Non-existing constant provided.");
            }
        }
        this.add(this.figure);
        this.add(this.data);
        this.propagatePaint();
    }

    @Override
    public void replace(int sender, SLCalculation newCalc) {
        throw new RuntimeException("Request from non-existing child");
    }

    @Override
    public SLCalculation clone() {
        SLObject result = new SLObject(this.decay, this.getOpinionType(), this.opinion, this.parent, this.passive);
        return result;
    }

    @Override
    public void makePassive(boolean b) {
        this.figure.makePassive(b);
        this.data.makePassive(b);
        this.passive = b;
    }

    @Override
    public void collapse(int col) {
        throw new RuntimeException("Cannot collapse atomic opinion.");
    }

    @Override
    public void substitute(SLObject slo) {
        boolean b = OpinionRegistry.isCopy(slo);
        if (slo.toString().equals(this.toString())) {
            b = this.passive;
        }
        SLObject temp = new SLObject(this.decay, slo.getOpinionType(), slo.opinion, this.parent, b, slo.formula);
        this.parent.replace(this.ID, temp);
        if (b) {
            OpinionRegistry.registerCopy(temp, slo.formula.toString());
        } else {
            OpinionRegistry.registerMain(temp, slo.formula.toString());
        }
        this.propagatePaint();
    }

    public void pushOpinion(Opinion opinion) {
        this.setOpinion(opinion);
        if (this.parent != null) {
            this.parent.update(opinion, this.ID);
        }
    }

    @Override
    public boolean contains(SLCalculation c) {
        return c.ID == this.ID;
    }

    @Override
    public LinkedList<SLCalculation> getAllSubtermsModuloAssociativity(int operator) {
        LinkedList<SLCalculation> result = new LinkedList<SLCalculation>();
        result.add(this);
        return result;
    }

    @Override
    public int getOperatorInt() {
        return -1;
    }
}

