/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLFigure;

public class SLSquare
extends SLFigure {
    private static final int widthRatio = 1;

    public SLSquare(Opinion initOpi, SLCalculation p, boolean passive) {
        super(passive);
        this.opinion = initOpi;
        this.parent = p;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Color c;
        super.paint(g);
        Dimension d = this.getSize();
        int h = d.height - 1;
        int w = d.width - 1;
        g.clearRect(0, 0, w + 1, h + 1);
        if (this.passive) {
            c = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, w, h);
            g.setColor(c);
        }
        if (!this.opinion.isCorrect()) {
            c = g.getColor();
            g.setColor(Color.PINK);
            g.fillRect(0, 0, w, h);
            g.setColor(c);
        }
        g.drawRect(0, 0, w, h);
        if (this.opinion.isCorrect()) {
            this.drawPoint(g, this.opinionToPoint(this.opinion));
        }
    }

    @Override
    public int setHeight(int height) {
        int width = height * 1;
        this.setSize(width, height);
        return width;
    }

    @Override
    protected Point opinionToPoint(Opinion op) {
        double y = op.getFormat(1)[1];
        double x = op.getFormat(1)[0];
        double py = this.denormalize(this.getSize().height, y);
        double px = this.denormalize(this.getSize().width, x);
        return new Point((int)px, (int)py);
    }

    @Override
    protected Opinion pointToOpinion(Point p) {
        double y = this.normalize(this.getSize().height, p.y);
        double x = this.normalize(this.getSize().width, p.x);
        return new Opinion(x, y, 1);
    }

    private double normalize(int t, int iy) {
        double fy = new Double(iy);
        return ((double)t - fy) / (double)t;
    }

    private int denormalize(int t, double y) {
        return (int)((double)t - y * (double)t);
    }
}

