/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Iterator;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLFigure;

public class SLTriangle
extends SLFigure {
    private static final double widthRatio = 1.1547005383792515;

    public SLTriangle(Opinion initOpi, SLCalculation p, boolean passive) {
        super(passive);
        this.opinion = initOpi;
        this.parent = p;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Color c;
        super.paint(g);
        Dimension d = this.getSize();
        int h = d.height - 1;
        int w = d.width - 1;
        g.clearRect(0, 0, w + 1, h + 1);
        int[] nArray = new int[3];
        nArray[1] = w / 2;
        nArray[2] = w;
        int[] xL = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = h;
        nArray2[2] = h;
        int[] yL = nArray2;
        Polygon p = new Polygon(xL, yL, 3);
        if (this.passive) {
            c = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            g.fillPolygon(p);
            g.setColor(c);
        }
        if (!this.opinion.isCorrect()) {
            c = g.getColor();
            g.setColor(Color.PINK);
            g.fillPolygon(p);
            g.setColor(c);
        }
        g.drawPolygon(p);
        if (this.opinion.isCorrect()) {
            this.drawPoint(g, this.opinionToPoint(this.opinion));
        }
        if (this.os != null) {
            Serializable old;
            if (this.os.isCompleted()) {
                old = g.getColor();
                for (Iterator it2 : this.os) {
                    boolean b;
                    boolean bl = b = Math.random() > 0.4;
                    if (!b) continue;
                    g.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                    Polygon q = new Polygon();
                    while (it2.hasNext()) {
                        Opinion o = (Opinion)it2.next();
                        Point temp = this.opinionToPoint(o);
                        q.addPoint(temp.x, temp.y);
                    }
                    g.fillPolygon(q);
                }
                g.setColor((Color)old);
            } else {
                old = null;
                for (Opinion now : this.os) {
                    Point temp = this.opinionToPoint(now);
                    this.drawPoint(g, temp);
                    if (old != null) {
                        g.drawLine(temp.x, temp.y, ((Point)old).x, ((Point)old).y);
                    }
                    old = temp;
                }
            }
        }
    }

    @Override
    public int setHeight(int height) {
        int width = (int)((double)height * 1.1547005383792515);
        this.setSize(width, height);
        return width;
    }

    @Override
    protected Opinion pointToOpinion(Point p) {
        double y = this.normalize(this.getSize().height, p.y);
        double x = this.normalize(this.getSize().width, p.x);
        double d = x - y / 2.0;
        double b = 1.0 - x - y / 2.0;
        return new Opinion(b, d, 0);
    }

    @Override
    protected Point opinionToPoint(Opinion o) {
        double y = o.getFormat(0)[2];
        double x = o.getFormat(0)[1] + y / 2.0;
        double py = this.denormalize(this.getSize().height, y);
        double px = this.denormalize(this.getSize().width, x);
        return new Point((int)px, (int)py);
    }

    private double normalize(int t, int iy) {
        double fy = new Double(iy);
        return ((double)t - fy) / (double)t;
    }

    private int denormalize(int t, double y) {
        return (int)((double)t - y * (double)t);
    }
}

