/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.popupMenu.MainScreenPopup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import subjectiveLogic.Opinion;
import subjectiveLogic.OpinionShape_Sweep;
import subjectiveLogic.SLCalcContainer;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLObject;
import subjectiveLogic.SLOperation;

public class MainWindow
extends JPanel
implements SLCalcContainer {
    private static final int V_SPACING = 10;
    private static final int H_SPACING = 10;
    private static final double BOTTOM_MENU = 0.1;
    public static final Color DISABLED_COLOR = new Color(238, 238, 238);
    private SLCalculation calc1;
    private SLCalculation calc2;
    private JScrollPane jsp1;
    private JScrollPane jsp2;
    private static final double DECAY = 0.96;
    public static MainWindow mainWindow;

    public static JFrame getMainWindow(Rectangle bounds) {
        JFrame f = new JFrame();
        f.setLayout(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().setBackground(Color.WHITE);
        f.setBackground(Color.WHITE);
        f.setTitle("Subjective Logic Visualiser");
        f.setBounds(bounds);
        mainWindow = new MainWindow(new Dimension(bounds.width, bounds.height));
        f.add(mainWindow);
        f.setVisible(true);
        f.setBounds(bounds);
        mainWindow.resized();
        f.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                mainWindow.setSize(e.getComponent().getSize());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        return f;
    }

    public MainWindow(Dimension size) {
        this.setLayout(null);
        this.setVisible(true);
        this.setSize(size);
        this.setBackground(Color.WHITE);
        int bottomMenu = (int)((double)this.getHeight() * 0.1);
        SLObject sl1 = new SLObject(0.8, 0, new Opinion(0.4, 0.2, 0), this, false);
        SLObject sl2 = new SLObject(0.8, 0, new Opinion(0.4, 0.5, 0), this, false);
        SLCalculation sl3 = ((SLCalculation)sl2).clone();
        SLCalculation sl4 = ((SLCalculation)sl1).clone();
        this.calc1 = new SLOperation(0.96, 100, sl1, sl2, this, true, 0);
        this.calc2 = new SLOperation(0.96, 100, sl3, sl4, this, true, 0);
        this.jsp1 = this.getJSP(this.calc1);
        this.jsp2 = this.getJSP(this.calc2);
        this.add(this.jsp1);
        this.add(this.jsp2);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainWindow.this.resized();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MainScreenPopup menu = new MainScreenPopup();
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private JScrollPane getJSP(SLCalculation c) {
        JScrollPane jsp = new JScrollPane(c);
        jsp.setLocation(10, 10);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(21);
        jsp.setViewportBorder(BorderFactory.createEmptyBorder());
        jsp.setSize(new Dimension(100, 100));
        return jsp;
    }

    protected void resized() {
        int bottomMenu = (int)((double)this.getHeight() * 0.1);
        int MID = (this.getHeight() - bottomMenu) / 2;
        this.jsp1.setBounds(10, 10, this.getWidth() - 20, this.getHeight() - MID - bottomMenu);
        this.jsp2.setBounds(10, 10 + MID, this.getWidth() - 20, this.getHeight() - MID - bottomMenu);
        this.calc1.relocate(this.calc1.getLocation(), this.jsp1.getViewportBorderBounds().height - 2, 0.96);
        this.calc2.relocate(this.calc2.getLocation(), this.jsp2.getViewportBorderBounds().height - 2, 0.96);
        this.jsp1.updateUI();
        this.jsp2.updateUI();
    }

    @Override
    public void replace(int id, SLCalculation newCalc) {
        if (this.calc1.sameID(id)) {
            this.jsp1.remove(this.calc1);
            this.remove(this.jsp1);
            try {
                ((SLOperation)newCalc).showResult(true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.calc1 = newCalc;
            this.jsp1 = this.getJSP(this.calc1);
            this.add(this.jsp1);
        } else if (this.calc2.sameID(id)) {
            this.jsp2.remove(this.calc2);
            this.remove(this.jsp2);
            try {
                ((SLOperation)newCalc).showResult(true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.calc2 = newCalc;
            this.jsp2 = this.getJSP(this.calc2);
            this.add(this.jsp2);
        } else {
            throw new RuntimeException("Wrongly referenced equation.");
        }
    }

    @Override
    public void update(Opinion op, int ID) {
    }

    @Override
    public SLCalcContainer getMyParent() {
        throw new RuntimeException("Root node has no parents");
    }

    @Override
    public void propagatePaint() {
        this.resized();
    }

    @Override
    public void update(OpinionShape_Sweep os, int id) {
    }

    public void updateFormula() {
    }

    @Override
    public boolean contains(SLCalculation c) {
        return this.calc1.contains(c) || this.calc2.contains(c);
    }
}

