/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

public class Opinion {
    public static final int TRIANGLE = 0;
    public static final int SQUARE = 1;
    public static final int WEIGHTED = 2;
    public static final int BETA = 3;
    private double x;
    private double y;
    private int type;
    private boolean isCorrect = true;
    private double secretRate = -1.0;

    public Opinion(boolean isCorrect) {
        if (isCorrect) {
            throw new RuntimeException("Correct opinion needs more parameters.");
        }
        this.isCorrect = false;
    }

    public Opinion(double x, double y, int type) {
        while (type == 0 && (x < 0.0 || y < 0.0 || x + y > 1.0)) {
            double nx;
            if (x < 0.0) {
                nx = 0.0;
                if ((y += x - nx) < 0.0) {
                    y = 0.0;
                }
                x = nx;
            }
            if (y < 0.0) {
                double ny = 0.0;
                if ((x += y - ny) < 0.0) {
                    x = 0.0;
                }
                y = ny;
            }
            if (!(x + y > 1.0)) continue;
            nx = x - (x + y - 1.0) / 2.0;
            double ny = y - (x + y - 1.0) / 2.0;
            x = nx;
            y = ny;
        }
        while (type == 1 && (x < 0.0 || y < 0.0 || x > 1.0 || y > 1.0)) {
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (x > 1.0) {
                x = 1.0;
            }
            if (!(y > 1.0)) continue;
            y = 1.0;
        }
        while (type == 2 && (x < 0.0 || y < 0.0 || x > 1.0)) {
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (!(x > 1.0)) continue;
            x = 1.0;
        }
        while (type == 3 && (x < 0.0 || y < 0.0)) {
            if (x < 0.0) {
                x = 0.0;
            }
            if (!(y < 0.0)) continue;
            y = 0.0;
        }
        if (x > 1.0E9) {
            x = Double.POSITIVE_INFINITY;
        }
        if (y > 1.0E9) {
            y = Double.POSITIVE_INFINITY;
        }
        if (x < 1.0E-10) {
            x = 0.0;
        }
        if (y < 1.0E-10) {
            y = 0.0;
        }
        this.x = x;
        this.y = y;
        this.type = type;
    }

    public boolean isCorrect() {
        return this.isCorrect;
    }

    public String toString() {
        double[] t = this.getFormat(0);
        double[] s = this.getFormat(1);
        double[] w = this.getFormat(2);
        double[] b = this.getFormat(3);
        return "Triangle[" + t[0] + ", " + t[1] + ", " + t[2] + "], Square[" + s[0] + ", " + s[1] + "], Weighted[" + w[0] + ", " + w[1] + "], Beta[" + b[0] + ", " + b[1] + "]";
    }

    public String toString(int type) {
        switch (type) {
            case 0: {
                double[] t = this.getFormat(0);
                return "Triangle[" + t[0] + ", " + t[1] + ", " + t[2] + "]";
            }
            case 1: {
                double[] s = this.getFormat(1);
                return "Square[" + s[0] + ", " + s[1] + "]";
            }
            case 2: {
                double[] w = this.getFormat(2);
                return "Weighted[" + w[0] + ", " + w[1] + "]";
            }
            case 3: {
                double[] b = this.getFormat(3);
                return "Beta[" + b[0] + ", " + b[1] + "]";
            }
        }
        throw new RuntimeException("Opinion type unknown.");
    }

    public double[] getFormat(int type) {
        switch (type) {
            case 0: {
                Opinion t = this.toTriangle();
                double[] result = new double[]{t.x, t.y, 1.0 - t.x - t.y};
                return result;
            }
            case 1: {
                Opinion s = this.toSquare();
                double[] result2 = new double[]{s.x, s.y};
                return result2;
            }
            case 2: {
                Opinion w = this.toWeighted();
                double[] result3 = new double[]{w.x, w.y};
                return result3;
            }
            case 3: {
                Opinion b = this.toBeta();
                double[] result4 = new double[]{b.x, b.y};
                return result4;
            }
        }
        throw new RuntimeException("Opinion type unknown.");
    }

    public int compareUncertainty(Opinion op2) {
        if (this.toSquare().y > op2.toSquare().y) {
            return 1;
        }
        if (this.toSquare().y < op2.toSquare().y) {
            return -1;
        }
        return 0;
    }

    public int compareBeliefRate(Opinion op2) {
        if (this.toSquare().x > op2.toSquare().x) {
            return 1;
        }
        if (this.toSquare().x < op2.toSquare().x) {
            return -1;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public Opinion getByType(int type) {
        switch (type) {
            case 0: {
                return this.toTriangle();
            }
            case 1: {
                return this.toSquare();
            }
            case 2: {
                return this.toWeighted();
            }
            case 3: {
                return this.toBeta();
            }
        }
        throw new RuntimeException("Opinion type unknown.");
    }

    private Opinion toTriangle() {
        switch (this.type) {
            case 0: {
                return this;
            }
            case 1: {
                return new Opinion(this.x * (1.0 - this.y), (1.0 - this.x) * (1.0 - this.y), 0);
            }
            case 2: {
                return this.toSquare().toTriangle();
            }
            case 3: {
                return this.toSquare().toTriangle();
            }
        }
        return null;
    }

    private Opinion toSquare() {
        switch (this.type) {
            case 0: {
                if (this.x + this.y > 0.0) {
                    return new Opinion(this.x / (this.x + this.y), 1.0 - this.x - this.y, 1);
                }
                return new Opinion(Opinion.arbitrary(0.0, 1.0), 1.0, 1);
            }
            case 1: {
                return this;
            }
            case 2: {
                return new Opinion(this.x, 1.0 / (this.y + 1.0), 1);
            }
            case 3: {
                return this.toWeighted().toSquare();
            }
        }
        return null;
    }

    private Opinion toWeighted() {
        switch (this.type) {
            case 0: {
                return this.toSquare().toWeighted();
            }
            case 1: {
                return new Opinion(this.x, 1.0 / this.y - 1.0, 2);
            }
            case 2: {
                return this;
            }
            case 3: {
                if (this.x <= 1.0E-5 && this.y <= 1.0E-5) {
                    return new Opinion(Opinion.arbitrary(0.0, 1.0), 0.0, 2);
                }
                if (this.x == Double.POSITIVE_INFINITY || this.y == Double.POSITIVE_INFINITY) {
                    return new Opinion(this.secretRate, Double.POSITIVE_INFINITY, 2);
                }
                return new Opinion(this.x / (this.x + this.y), this.x + this.y, 2);
            }
        }
        return null;
    }

    private Opinion toBeta() {
        switch (this.type) {
            case 0: {
                return this.toWeighted().toBeta();
            }
            case 1: {
                return this.toWeighted().toBeta();
            }
            case 2: {
                if (this.y == Double.POSITIVE_INFINITY) {
                    Opinion o = new Opinion(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 3);
                    if (this.x <= 1.0E-4) {
                        o.x = 0.0;
                    }
                    if (this.x >= 0.9999) {
                        o.y = 0.0;
                    }
                    o.secretRate = this.x;
                    return o;
                }
                return new Opinion(this.x * this.y, (1.0 - this.x) * this.y, 3);
            }
            case 3: {
                return this;
            }
        }
        return null;
    }

    public static String getOpinionComponent(double d, int length) {
        if (length < 0) {
            return "";
        }
        String s = new Double(d).toString();
        if (s.indexOf("E+") != -1) {
            throw new RuntimeException("Number too large..");
        }
        if (s.indexOf("E-") != -1) {
            return "0.0";
        }
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }

    public static double arbitrary(double d, double e) {
        return Math.random() * (e - d) - d;
    }
}

