/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import gui.MainWindow;
import java.util.Iterator;
import java.util.LinkedList;
import subjectiveLogic.SLObject;

public class OpinionRegistry {
    private static LinkedList<Entry> opinions = new LinkedList();

    public static void register(SLObject reg) {
        if (!OpinionRegistry.existsEntryByName(reg.formula.toString()) && !reg.formula.toString().equalsIgnoreCase("result")) {
            opinions.add(new Entry(reg));
        }
    }

    public static Iterator<SLObject> iterator() {
        return new Iterator<SLObject>(){
            Iterator<Entry> entries = OpinionRegistry.access$0().iterator();

            @Override
            public void remove() {
                this.entries.remove();
            }

            @Override
            public SLObject next() {
                return this.entries.next().getMain();
            }

            @Override
            public boolean hasNext() {
                return this.entries.hasNext();
            }
        };
    }

    public static void pushUpdatesOf(String name) {
        OpinionRegistry.getEntryByName(name).pushUpdateToDependencies();
    }

    public static void registerCopy(SLObject reg, String name) {
        OpinionRegistry.getEntryByName(name).add(reg);
    }

    public static boolean isCopy(SLObject reg) {
        return OpinionRegistry.mainInUse(reg);
    }

    public static void registerMain(SLObject reg, String name) {
        OpinionRegistry.getEntryByName(name).setMain(reg);
    }

    private static Entry getEntryByName(String name) {
        for (Entry e : opinions) {
            if (!e.main.toString().equals(name)) continue;
            return e;
        }
        throw new RuntimeException("No entry found named " + name);
    }

    private static boolean existsEntryByName(String name) {
        for (Entry e : opinions) {
            if (!e.main.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean mainInUse(SLObject reg) {
        SLObject m = OpinionRegistry.getEntryByName(reg.formula.toString()).getMain();
        return MainWindow.mainWindow.contains(m);
    }

    static /* synthetic */ LinkedList access$0() {
        return opinions;
    }

    private static class Entry {
        private SLObject main;
        private LinkedList<SLObject> dependencies = new LinkedList();

        public Entry(SLObject reg) {
            this.main = reg;
        }

        public void setMain(SLObject reg) {
            this.main = reg;
        }

        public void add(SLObject dep) {
            this.dependencies.add(dep);
        }

        public SLObject getMain() {
            return this.main;
        }

        public void pushUpdateToDependencies() {
            Iterator dep = this.dependencies.iterator();
            while (dep.hasNext()) {
                SLObject ob = (SLObject)dep.next();
                if (ob.parent.contains(ob)) {
                    ob.pushOpinion(this.main.opinion);
                    continue;
                }
                dep.remove();
            }
        }
    }
}

