/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLOperator;

public class OpinionShape
implements Iterable<Opinion> {
    private boolean isComplete;
    private List<Opinion> opinions;
    private node n;

    public OpinionShape() {
        this.isComplete = false;
        this.opinions = new LinkedList<Opinion>();
    }

    public OpinionShape(SLCalculation left, SLOperator op, SLCalculation right) {
        this.isComplete = true;
    }

    public OpinionShape(Opinion opinion) {
        this.opinions = new LinkedList<Opinion>();
        this.opinions.add(opinion);
        this.n = new leaf(this.opinions.toArray(new Opinion[0]));
        this.isComplete = true;
    }

    public void add(Opinion op) {
        if (this.isComplete) {
            throw new RuntimeException("Cannot add element to completed figure.");
        }
        this.opinions.add(op);
    }

    public void complete() {
        this.n = new leaf(this.opinions.toArray(new Opinion[0]));
        this.isComplete = true;
    }

    public boolean isCompleted() {
        return this.isComplete;
    }

    @Override
    public Iterator<Opinion> iterator() {
        if (!this.isCompleted()) {
            return this.opinions.iterator();
        }
        return this.n.getOpinions().iterator();
    }

    private static class Angle {
        private double myAngle;

        private Angle() {
        }

        public static Angle getTopAngle() {
            return null;
        }

        public double compare(Angle a) {
            return 0.0;
        }
    }

    private class Intersection {
        private boolean intersects;
        private Line intersector;
        private Line intersectee;
        private PointD coordinates;
        private double ratio;

        public Intersection(boolean intersects, Line intersector, Line intersectee, PointD coordinates, double ratio) {
            this.intersects = intersects;
            if (!intersects) {
                throw new RuntimeException("Do not construct non-existing intersection with arguments.");
            }
            this.intersector = intersector;
            this.intersectee = intersectee;
            this.coordinates = coordinates;
            this.ratio = ratio;
        }

        public Intersection(boolean intersects) {
            this.intersects = intersects;
            if (intersects) {
                throw new RuntimeException("Do not construct existing intersection without arguments.");
            }
            this.intersector = null;
            this.ratio = Double.POSITIVE_INFINITY;
        }

        public boolean isIntersected() {
            return this.intersects;
        }

        public double getRatio() {
            return this.ratio;
        }

        public Line[] getFragments() {
            Line l1p1 = new Line(this.intersector.x1, this.intersector.y2, this.coordinates.x, this.coordinates.y);
            Line l1p2 = new Line(this.coordinates.x, this.coordinates.y, this.intersector.x2, this.intersector.y2);
            Line l2p1 = new Line(this.intersectee.x1, this.intersectee.y2, this.coordinates.x, this.coordinates.y);
            Line l2p2 = new Line(this.coordinates.x, this.coordinates.y, this.intersectee.x2, this.intersectee.y2);
            Line[] result = new Line[]{l1p1, l1p2, l2p1, l2p2};
            l1p1.prev = this.intersector.prev;
            l1p1.addNext(l1p2);
            l1p1.addNext(l2p2);
            l1p2.addPrev(l1p1);
            l1p2.addPrev(l2p1);
            l1p2.next = this.intersector.next;
            l2p1.prev = this.intersectee.prev;
            l2p1.addNext(l1p2);
            l2p1.addNext(l2p2);
            l2p2.addPrev(l1p1);
            l2p2.addPrev(l2p1);
            l2p2.next = this.intersectee.next;
            return result;
        }
    }

    private class Line {
        private double x1;
        private double y1;
        private double x2;
        private double y2;
        private LinkedList<Line> prev = new LinkedList();
        private LinkedList<Line> next = new LinkedList();

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public void addPrev(Line l) {
            this.prev.add(l);
        }

        public void addNext(Line l) {
            this.next.add(l);
        }

        public Line[] getPrev(Line l) {
            return this.prev.toArray(new Line[0]);
        }

        public Line[] getNext(Line l) {
            return this.next.toArray(new Line[0]);
        }

        public Intersection intersection(Line t) {
            if (Line2D.linesIntersect(this.x1, this.y1, this.x2, this.y2, t.x1, t.y1, t.x2, t.y2)) {
                double e = (t.x2 * (this.y2 - this.y1) + t.y2 * (this.x1 - this.x2) + this.y1 * this.x2 - this.x1 * this.y2) / (this.y1 * (t.x1 - t.x2) + this.y2 * (t.x2 - t.x1) + this.x1 * (t.y2 - t.y1) + this.x2 * (t.y1 - t.y2));
                double d = (e * t.x1 - e * t.x2 + t.x2 - this.x2) / (this.x1 - this.x2);
                double dtest = (e * t.y1 - e * t.y2 + t.y2 - this.y2) / (this.y1 - this.y2);
                PointD coordinates = new PointD(d * this.x1 + (1.0 - d) * this.x2, d * this.y1 + (1.0 - d) * this.y2);
                double ratio = 1.0 - d;
                return new Intersection(true, t, this, coordinates, ratio);
            }
            return new Intersection(false);
        }
    }

    private class LineSet
    extends LinkedList<Line> {
        private LineSet() {
        }

        public Intersection firstIntersection(Line l) {
            Intersection fi = new Intersection(false, null, null, null, Double.POSITIVE_INFINITY);
            for (Line t : this) {
                Intersection i = l.intersection(t);
                if (!i.isIntersected() || !(i.getRatio() < fi.getRatio())) continue;
                fi = i;
            }
            return fi;
        }

        public Line nextOutside(Line prev, Angle angle) {
            return null;
        }
    }

    private class PointD {
        double x;
        double y;

        public PointD(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    protected class leaf
    extends node {
        protected leaf(Opinion[] shape) {
            this.shape = new Polygon();
            int i = 0;
            while (i < shape.length) {
                int x = (int)(shape[i].getFormat(0)[0] * 1.0E7);
                int y = (int)(shape[i].getFormat(0)[1] * 1.0E7);
                this.shape.addPoint(x, y);
                ++i;
            }
        }
    }

    protected abstract class node {
        protected static final int GRANULARITY = 10000000;
        protected Polygon shape;

        protected node() {
        }

        protected LinkedList<Opinion> getOpinions() {
            LinkedList<Opinion> result = new LinkedList<Opinion>();
            int i = 0;
            while (i < this.shape.npoints) {
                double x = (double)this.shape.xpoints[i] / 1.0E7;
                double y = (double)this.shape.ypoints[i] / 1.0E7;
                result.add(new Opinion(x, y, 0));
                ++i;
            }
            return result;
        }

        public String toString() {
            String result = "";
            int i = 0;
            while (i < this.shape.npoints) {
                double x = (double)this.shape.xpoints[i] / 1.0E7;
                double y = (double)this.shape.ypoints[i] / 1.0E7;
                result = String.valueOf(result) + "x: " + x + ", y: " + y + "\r\n";
                ++i;
            }
            return result;
        }
    }

    protected class tree
    extends node {
        protected tree(node left, SLOperator op, node right) {
            this.shape = new Polygon();
            if (right.shape.npoints == 1 || left.shape.npoints == 1) {
                if (right.shape.npoints != 1) {
                    node temp = left;
                    left = right;
                    right = temp;
                }
                Point p = new Point(right.shape.xpoints[0], right.shape.ypoints[0]);
                Opinion rop = new Opinion((double)p.x / 1.0E7, (double)p.y / 1.0E7, 0);
                int i = 0;
                while (i < left.shape.npoints) {
                    Point q = new Point(left.shape.xpoints[i], left.shape.ypoints[i]);
                    Opinion lop = new Opinion((double)q.x / 1.0E7, (double)q.y / 1.0E7, 0);
                    double[] resop = op.applyOperator(lop, rop).getFormat(0);
                    this.shape.addPoint((int)(resop[0] * 1.0E7), (int)(resop[1] * 1.0E7));
                    ++i;
                }
            }
        }
    }
}

