/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import gui.MainWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLFigure;

public class SLBeta
extends SLFigure {
    private static final int widthRatio = 1;
    private static final int SAMPLING_SIZE = 200;
    private static double secretRate = -1.0;

    public SLBeta(Opinion initOpi, SLCalculation p, boolean passive) {
        super(passive);
        this.opinion = initOpi;
        this.parent = p;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Color c;
        super.paint(g);
        Dimension d = this.getSize();
        int h = d.height - 1;
        int w = d.width - 1;
        g.clearRect(0, 0, w + 1, h + 1);
        if (this.passive) {
            c = g.getColor();
            g.setColor(MainWindow.DISABLED_COLOR);
            g.fillRect(0, 0, w, h);
            g.setColor(c);
        }
        if (!this.opinion.isCorrect()) {
            c = g.getColor();
            g.setColor(Color.PINK);
            g.fillRect(0, 0, w, h);
            g.setColor(c);
        }
        g.drawRect(0, 0, w, h);
        if (this.opinion.isCorrect()) {
            if (!this.passive) {
                this.drawPoint(g, this.opinionToPoint(this.opinion));
            }
            this.drawBeta(g, this.opinion.getFormat(3)[0], this.opinion.getFormat(3)[1], this.opinion.getFormat(2)[0]);
        }
    }

    @Override
    public int setHeight(int height) {
        int width = height * 1;
        this.setSize(width, height);
        return width;
    }

    @Override
    protected Point opinionToPoint(Opinion op) {
        double y = op.getFormat(1)[1];
        double x = op.getFormat(1)[0];
        double py = this.denormalize(this.getSize().height, 1.0 - y);
        double px = this.denormalize(this.getSize().width, x);
        return new Point((int)px, (int)py);
    }

    @Override
    protected Opinion pointToOpinion(Point p) {
        double y = 1.0 - this.normalize(this.getSize().height, p.y);
        double x = this.normalize(this.getSize().width, p.x);
        return new Opinion(x, y, 1).getByType(3);
    }

    private double normalize(int t, int iy) {
        double fy = new Double(iy);
        return ((double)t - fy) / (double)t;
    }

    private int denormalize(int t, double y) {
        return (int)((double)t - y * (double)t);
    }

    private void drawBeta(Graphics g, double s, double f, double r) {
        g.setColor(new Color(159, 159, 159));
        g.drawLine(this.denormalize(this.getSize().width, 0.0), this.denormalize(this.getSize().height, 0.2), this.denormalize(this.getSize().width, 1.0), this.denormalize(this.getSize().height, 0.2));
        g.setColor(new Color(209, 209, 209));
        g.drawLine(this.denormalize(this.getSize().width, 0.0), this.denormalize(this.getSize().height, 0.4), this.denormalize(this.getSize().width, 1.0), this.denormalize(this.getSize().height, 0.4));
        g.drawLine(this.denormalize(this.getSize().width, 0.0), this.denormalize(this.getSize().height, 0.6), this.denormalize(this.getSize().width, 1.0), this.denormalize(this.getSize().height, 0.6));
        g.drawLine(this.denormalize(this.getSize().width, 0.0), this.denormalize(this.getSize().height, 0.8), this.denormalize(this.getSize().width, 1.0), this.denormalize(this.getSize().height, 0.8));
        g.setColor(new Color(0, 140, 0));
        if (s == Double.POSITIVE_INFINITY || f == Double.POSITIVE_INFINITY) {
            g.drawLine(this.denormalize(this.getSize().width, r) - 1, this.denormalize(this.getSize().height, 0.0), this.denormalize(this.getSize().width, r) - 1, this.denormalize(this.getSize().height, 1.0));
            g.drawLine(this.denormalize(this.getSize().width, r), this.denormalize(this.getSize().height, 0.0), this.denormalize(this.getSize().width, r), this.denormalize(this.getSize().height, 1.0));
        } else {
            double loc;
            double norm = 0.0;
            double step = 0.005;
            double[] yu = new double[200];
            int n = 0;
            while (n < 200) {
                loc = step * (double)n;
                yu[n] = Math.pow(loc, s) * Math.pow(1.0 - loc, f);
                norm += yu[n];
                ++n;
            }
            norm *= step * 5.0;
            n = 0;
            while (n < 199) {
                loc = step * (double)n;
                g.drawLine(this.denormalize(this.getSize().width, loc), this.denormalize(this.getSize().width, yu[n] / norm), this.denormalize(this.getSize().width, loc + step), this.denormalize(this.getSize().width, yu[n + 1] / norm));
                ++n;
            }
        }
    }
}

