/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import gui.popupMenu.SLMenu;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JPanel;
import subjectiveLogic.Opinion;
import subjectiveLogic.OpinionShape_Sweep;
import subjectiveLogic.SLCalcContainer;
import subjectiveLogic.SLFormula;
import subjectiveLogic.SLObject;
import subjectiveLogic.SLOperation;

public abstract class SLCalculation
extends JPanel
implements SLCalcContainer {
    public static final int TRIANGLE = 0;
    public static final int SQUARE = 1;
    public static final int WEIGHTED = 2;
    public static final int BETA = 3;
    public static final int FUSION = 100;
    public static final int DILUTION = 101;
    public static final int AND = 102;
    public static final int OR = 103;
    private static int IDCounter = 0;
    private static int literal = 0;
    protected SLCalcContainer parent = null;
    protected int ID = SLCalculation.getID();
    protected Opinion opinion;
    protected OpinionShape_Sweep opinions;
    protected double decay;
    protected int opinionType;
    protected boolean isCompound;
    protected SLFormula formula;

    public SLCalculation() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SLMenu menu = new SLMenu((SLCalculation)e.getSource());
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public abstract void update(OpinionShape_Sweep var1, int var2);

    public abstract int relocate(Point var1, int var2, double var3);

    @Override
    public SLCalcContainer getMyParent() {
        return this.parent;
    }

    protected static int getID() {
        return ++IDCounter;
    }

    protected static String getLiteral() {
        String s = "xyzuvwabcdefghijklmnopqrst";
        if (literal < s.length()) {
            char[] c = new char[]{s.charAt(literal++)};
            return new String(c);
        }
        char[] c = new char[]{s.charAt(literal++ % s.length())};
        return String.valueOf(new String(c)) + (literal - 1) / s.length();
    }

    public boolean isCompound() {
        return this.isCompound;
    }

    public abstract void updateRepresentation(int var1);

    public int getOpinionType() {
        return this.opinionType;
    }

    public void expand(int operator, int proc, Opinion op) {
        SLCalculation left = null;
        SLCalculation right = null;
        int dep = 0;
        switch (proc) {
            case 1001: {
                left = this;
                right = new SLObject(this.decay, op.getType(), op, this, false);
                break;
            }
            case 1000: {
                left = new SLObject(this.decay, op.getType(), op, this, false);
                right = this;
                break;
            }
            case 1002: {
                left = this;
                right = this.clone();
                break;
            }
            case 1003: {
                left = new SLObject(this.decay, this.getOpinionType(), this.opinion, this, true, this.formula);
                right = this;
                dep = 1;
                break;
            }
            case 1004: {
                left = this;
                right = new SLObject(this.decay, this.getOpinionType(), this.opinion, this, true, this.formula);
                dep = 2;
                break;
            }
        }
        SLCalcContainer tempParent = this.parent;
        SLOperation calc = new SLOperation(this.decay, operator, left, right, this.parent, false, dep);
        tempParent.replace(this.ID, calc);
        this.propagatePaint();
    }

    public abstract void collapse(int var1);

    @Override
    public abstract void replace(int var1, SLCalculation var2);

    @Override
    public void propagatePaint() {
        this.parent.propagatePaint();
    }

    @Override
    public String toString() {
        return this.formula.toString();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.GRAY);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public abstract SLCalculation clone();

    public abstract void makePassive(boolean var1);

    public OpinionShape_Sweep getOpinionShape() {
        if (this.opinions != null && this.opinions.isCompleted()) {
            return this.opinions;
        }
        return new OpinionShape_Sweep(this.opinion);
    }

    public abstract void substitute(SLObject var1);

    public boolean sameID(int id) {
        return id == this.ID;
    }

    public abstract LinkedList<SLCalculation> getAllSubtermsModuloAssociativity(int var1);

    public abstract int getOperatorInt();
}

