/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import subjectiveLogic.Opinion;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLUI;

public class SLData
extends SLUI {
    private Opinion opinion;
    private SLCalculation parent;
    private JTextField fx;
    private JTextField fy;
    private JTextField fz = null;
    private int type;
    private boolean safeX;
    private boolean safeY;
    private JLabel lx;
    private JLabel ly;
    private JLabel lz;
    private boolean passive;

    public SLData(Opinion initOp, SLCalculation p, int type, boolean passive) {
        this.setLayout(null);
        this.opinion = initOp;
        this.type = type;
        this.passive = passive;
        this.parent = p;
        this.addTextFields(this.opinion.getFormat(type).length);
        this.addLabels(this.opinion.getFormat(type), type);
        this.setOpinion(initOp);
    }

    private void addTextFields(int nr) {
        this.fx = new JTextField();
        if (this.passive) {
            this.fx.setEditable(false);
        } else {
            this.fx.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    String s = ((JTextField)e.getSource()).getText();
                    Double d = null;
                    try {
                        d = new Double(s);
                    }
                    catch (NumberFormatException ex) {
                        d = 0.0;
                    }
                    SLData.this.updatedFX(d);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        this.add(this.fx);
        this.fy = new JTextField();
        if (this.passive) {
            this.fy.setEditable(false);
        } else {
            this.fy.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    String s = ((JTextField)e.getSource()).getText();
                    Double d = null;
                    try {
                        d = new Double(s);
                    }
                    catch (NumberFormatException ex) {
                        d = 0.0;
                    }
                    SLData.this.updatedFY(d);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        this.add(this.fy);
        if (nr >= 3) {
            this.fz = new JTextField();
            this.fz.setEditable(false);
            this.add(this.fz);
        }
    }

    private void sizeTextFields(int x, int height, int nr) {
        int tfheight = height / nr;
        this.fx.setBounds(x, 0, x, tfheight);
        this.fx.setText(Opinion.getOpinionComponent(this.opinion.getFormat(this.type)[0], SLData.getColumns(x)));
        this.fy.setBounds(x, tfheight, x, tfheight);
        this.fy.setText(Opinion.getOpinionComponent(this.opinion.getFormat(this.type)[1], SLData.getColumns(x)));
        if (nr >= 3) {
            this.fz.setBounds(x, 2 * tfheight, x, tfheight);
            this.fz.setText(Opinion.getOpinionComponent(this.opinion.getFormat(this.type)[2], SLData.getColumns(x)));
        }
    }

    private void updatedFX(double value) {
        this.safeX = true;
        this.parent.update(new Opinion(value, this.opinion.getFormat(this.type)[1], this.type), -1);
        this.safeX = false;
    }

    private void updatedFY(double value) {
        this.safeY = true;
        this.parent.update(new Opinion(this.opinion.getFormat(this.type)[0], value, this.type), -1);
        this.safeY = false;
    }

    private void addLabels(double[] values, int type) {
        this.lx = new JLabel();
        this.add(this.lx);
        this.ly = new JLabel();
        this.add(this.ly);
        if (values.length >= 3) {
            this.lz = new JLabel();
            this.add(this.lz);
        }
        switch (type) {
            case 0: {
                this.lx.setText("Belief:");
                this.ly.setText("Disbelief:");
                this.lz.setText("Uncertainty:");
                break;
            }
            case 1: {
                this.lx.setText("Rating:");
                this.ly.setText("Doubt:");
                break;
            }
            case 2: {
                this.lx.setText("Rating:");
                this.ly.setText("Weight:");
                break;
            }
            case 3: {
                this.lx.setText("Successes:");
                this.ly.setText("Failures:");
                break;
            }
        }
    }

    private void sizeLabels(int w, int height, int nr) {
        int tfheight = height / nr;
        this.lx.setBounds(0, 0, w, tfheight);
        this.ly.setBounds(0, tfheight, w, tfheight);
        if (nr >= 3) {
            this.lz.setBounds(0, 2 * tfheight, w, tfheight);
        }
    }

    @Override
    public void setOpinion(Opinion op) {
        this.opinion = op;
        if (op.isCorrect()) {
            double[] values = op.getFormat(this.type);
            this.fx.setForeground(Color.BLACK);
            if (!this.safeX) {
                this.fx.setText(Opinion.getOpinionComponent(values[0], SLData.getColumns(this.fx.getWidth())));
            }
            this.fy.setForeground(Color.BLACK);
            if (!this.safeY) {
                this.fy.setText(Opinion.getOpinionComponent(values[1], SLData.getColumns(this.fy.getWidth())));
            }
            if (this.fz != null && values.length >= 3) {
                this.fz.setForeground(Color.BLACK);
                this.fz.setText(Opinion.getOpinionComponent(values[2], SLData.getColumns(this.fz.getWidth())));
            }
        } else {
            this.fx.setForeground(Color.RED);
            if (!this.safeX) {
                this.fx.setText("Error");
            }
            this.fy.setForeground(Color.RED);
            if (!this.safeY) {
                this.fy.setText("Error");
            }
            if (this.fz != null) {
                this.fz.setForeground(Color.RED);
                this.fz.setText("Error");
            }
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        int nr = 2;
        if (this.fz != null) {
            nr = 3;
        }
        this.sizeLabels(w / 2, h, nr);
        this.sizeTextFields(w / 2, h, nr);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    private static int getColumns(int width) {
        class JTextfield
        extends JTextField {
            JTextfield() {
            }

            @Override
            public int getColumns() {
                return (int)((double)this.getWidth() / ((double)this.getColumnWidth() / 1.3)) + 1;
            }
        }
        JTextfield jtf = new JTextfield();
        jtf.setSize(width, 10);
        return jtf.getColumns();
    }

    public void makePassive(boolean b) {
        if (this.passive && !b) {
            this.fx.setEditable(true);
            this.fy.setEditable(true);
        } else if (!this.passive && b) {
            this.fx.setEditable(false);
            this.fy.setEditable(false);
        }
        this.passive = b;
    }
}

