/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import gui.popupMenu.SLMenu;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import subjectiveLogic.Opinion;
import subjectiveLogic.OpinionShape_Sweep;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLUI;

public abstract class SLFigure
extends SLUI {
    protected Opinion opinion;
    protected SLCalculation parent;
    protected boolean passive;
    private boolean isLeft;
    protected OpinionShape_Sweep os;
    private MML mml;
    private MMML mmml;
    private MKL mkl;

    public SLFigure(boolean passive) {
        this.passive = passive;
        this.setLayout(null);
        this.mml = new MML();
        this.mmml = new MMML();
        this.mkl = new MKL();
        if (!passive) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.mkl);
            this.addMouseListener(this.mml);
            this.addMouseMotionListener(this.mmml);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.opinion.isCorrect()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.RED);
        }
    }

    @Override
    public void setOpinion(Opinion op) {
        this.opinion = op;
        this.repaint();
    }

    public void setOpinionShape(OpinionShape_Sweep opinions) {
        this.os = opinions;
        this.repaint();
    }

    public void makePassive(boolean b) {
        if (this.passive && !b) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.mkl);
            this.addMouseListener(this.mml);
            this.addMouseMotionListener(this.mmml);
        } else if (!this.passive && b) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.mkl);
            this.removeMouseListener(this.mml);
            this.removeMouseMotionListener(this.mmml);
        }
        this.passive = b;
    }

    public abstract int setHeight(int var1);

    protected abstract Point opinionToPoint(Opinion var1);

    protected abstract Opinion pointToOpinion(Point var1);

    private void setLeftButton(boolean left) {
        this.isLeft = left;
    }

    private boolean isLeftButton() {
        return this.isLeft;
    }

    public void doClick(MouseEvent e) {
        this.parent.update(this.pointToOpinion(e.getPoint()), -1);
    }

    protected void drawPoint(Graphics g, Point p) {
        int w = 4;
        int h = 4;
        g.fillRect(p.x - w / 2, p.y - h / 2, w, h);
    }

    private class MKL
    implements KeyEventDispatcher {
        private MKL() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            return false;
        }
    }

    private class MML
    implements MouseListener {
        private MML() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.showPopup(e)) {
                SLFigure.this.doClick(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private boolean showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SLMenu menu = new SLMenu(SLFigure.this.parent);
                menu.show(e.getComponent(), e.getX(), e.getY());
                SLFigure.this.setLeftButton(false);
                return true;
            }
            if (e.getButton() == 1) {
                SLFigure.this.setLeftButton(true);
            } else {
                SLFigure.this.setLeftButton(false);
            }
            return false;
        }
    }

    private class MMML
    implements MouseMotionListener {
        private MMML() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SLFigure.this.isLeftButton()) {
                SLFigure.this.doClick(e);
            }
        }
    }
}

