/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import subjectiveLogic.SLOperator;

public class SLFormula {
    private String formula;
    private SLOperator operator;
    private boolean compound;

    public SLFormula(SLFormula left, SLOperator op, SLFormula right) {
        String l = left.toString();
        if (!(!left.isCompound() || left.sameOperator(op) && op.isAssociative())) {
            l = "(" + l + ")";
        }
        String r = right.toString();
        if (!(!right.isCompound() || right.sameOperator(op) && op.isAssociative())) {
            r = "(" + r + ")";
        }
        this.formula = String.valueOf(l) + op.toString() + r;
        this.operator = op;
        this.compound = true;
    }

    public SLFormula(String f) {
        this.formula = f;
        this.compound = false;
        this.operator = null;
    }

    private boolean isCompound() {
        return this.compound;
    }

    private boolean sameOperator(SLOperator op) {
        return op.getType() == this.operator.getType();
    }

    public String toString() {
        return this.formula;
    }
}

