/*
 * Decompiled with CFR 0.152.
 */
package subjectiveLogic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import subjectiveLogic.Opinion;
import subjectiveLogic.OpinionShape_Sweep;
import subjectiveLogic.SLCalcContainer;
import subjectiveLogic.SLCalculation;
import subjectiveLogic.SLFormula;
import subjectiveLogic.SLObject;
import subjectiveLogic.SLOperator;

public class SLOperation
extends SLCalculation {
    public static final int NONE = 0;
    public static final int LEFT_ON_RIGHT = 1;
    public static final int RIGHT_ON_LEFT = 2;
    public static final int RESULT = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private SLCalculation left;
    private SLCalculation right;
    private SLOperator operator;
    private boolean showResult;
    private SLObject result;
    private IsSign iss;
    private static int SPACING = 10;
    private int dependancies = 0;
    private JLabel name;

    public SLOperation(double decay, int type, SLCalculation left, SLCalculation right, SLCalcContainer p, boolean showResult, int dependancies) {
        this.isCompound = true;
        this.setLayout(null);
        left.parent = this;
        right.parent = this;
        this.opinionType = left.getOpinionType();
        this.left = left;
        this.right = right;
        this.dependancies = dependancies;
        this.showResult = showResult;
        this.parent = p;
        switch (type) {
            case 0: {
                throw new RuntimeException("SLOperation must be a compound object.");
            }
            case 1: {
                throw new RuntimeException("SLOperation must be a compound object.");
            }
            case 2: {
                throw new RuntimeException("SLOperation must be a compound object.");
            }
            case 100: {
                this.operator = new SLOperator(100, this);
                break;
            }
            case 101: {
                this.operator = new SLOperator(101, this);
                break;
            }
            case 102: {
                this.operator = new SLOperator(102, this);
                break;
            }
            case 103: {
                this.operator = new SLOperator(103, this);
                break;
            }
            default: {
                throw new RuntimeException("Non-existing constant provided.");
            }
        }
        this.add(this.left);
        this.add(this.right);
        this.add(this.operator);
        this.opinion = this.operator.applyOperator(left.opinion, right.opinion);
        if (showResult) {
            this.iss = new IsSign();
            this.iss.setSize(this.operator.getSize());
            this.add(this.iss);
            this.result = new SLObject(decay, this.getOpinionType(), this.opinion, this, true);
            this.add(this.result);
        }
        this.name = new JLabel();
        this.name.setFont(this.name.getFont().deriveFont(16.0f));
        this.updateFormula();
        this.add(this.name);
    }

    @Override
    public void update(Opinion op, int sender) {
        if (this.dependancies == 1) {
            try {
                ((SLObject)this.left).setOpinion(this.right.opinion);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
        } else if (this.dependancies == 2) {
            try {
                ((SLObject)this.right).setOpinion(this.left.opinion);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
        }
        Opinion result = null;
        if (sender == this.left.ID) {
            result = this.operator.applyOperator(op, this.right.opinion);
        } else if (sender == this.right.ID) {
            result = this.operator.applyOperator(this.left.opinion, op);
        } else {
            throw new RuntimeException("Source of opinion update unknown.");
        }
        this.opinion = result;
        this.updateFormula();
        if (this.showResult) {
            this.result.setOpinion(this.opinion);
        }
        if (this.parent != null) {
            this.parent.update(result, this.ID);
        }
    }

    @Override
    public void update(OpinionShape_Sweep os, int sender) {
        OpinionShape_Sweep result;
        if (this.dependancies == 1) {
            try {
                ((SLObject)this.left).setOpinionShape(this.right.opinions);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
        } else if (this.dependancies == 2) {
            try {
                ((SLObject)this.right).setOpinionShape(this.left.opinions);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
        }
        this.opinions = result = new OpinionShape_Sweep(this.left, this.operator, this.right);
        if (this.showResult) {
            this.result.setOpinionShape(this.opinions);
        }
        if (this.parent != null) {
            this.parent.update(result, this.ID);
        }
    }

    @Override
    public int relocate(Point location, int height, double decay) {
        this.setLocation(location);
        this.name.setLocation(SPACING, 0);
        int internHeight = (int)(decay * (double)height) - this.name.getHeight();
        int lWidth = this.left.relocate(new Point(SPACING, (height - internHeight + this.name.getHeight()) / 2), internHeight, decay);
        int oWidth = internHeight / 4;
        this.operator.setSize(oWidth, oWidth);
        this.operator.setLocation(2 * SPACING + lWidth, (height - oWidth + this.name.getHeight()) / 2);
        int rWidth = this.right.relocate(new Point(3 * SPACING + lWidth + oWidth, (height - internHeight + this.name.getHeight()) / 2), internHeight, decay);
        int width = 4 * SPACING + lWidth + rWidth + oWidth;
        if (this.showResult) {
            this.iss.setSize(this.operator.getWidth() * 2 / 3, this.operator.getHeight() * 3 / 5);
            this.iss.setLocation(width, (height - this.iss.getHeight() + this.name.getHeight()) / 2);
            int isWidth = this.iss.getWidth();
            int reWidth = this.result.relocate(new Point(width + SPACING + isWidth, (height - internHeight + this.name.getHeight()) / 2), internHeight, decay);
            width = width + SPACING + reWidth + SPACING + isWidth;
        }
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        return width;
    }

    public void updateOperator() {
        Opinion result;
        this.opinion = result = this.operator.applyOperator(this.left.opinion, this.right.opinion);
        if (this.showResult) {
            this.result.setOpinion(this.opinion);
        }
        this.updateFormula();
        if (this.parent != null) {
            this.parent.update(result, this.ID);
        }
    }

    @Override
    public void updateRepresentation(int type) {
        this.opinionType = type;
        this.left.updateRepresentation(type);
        this.right.updateRepresentation(type);
        this.updateFormula();
        if (this.showResult) {
            this.result.updateRepresentation(type);
        }
    }

    @Override
    public void replace(int sender, SLCalculation newCalc) {
        if (sender == this.left.ID) {
            this.remove(this.left);
            this.left = newCalc;
            this.add(this.left);
        } else if (sender == this.right.ID) {
            this.remove(this.right);
            this.right = newCalc;
            this.add(this.right);
        } else {
            throw new RuntimeException("Source of opinion update unknown.");
        }
        this.opinion = this.operator.applyOperator(this.left.opinion, this.right.opinion);
        if (this.showResult) {
            this.result.setOpinion(this.opinion);
        }
        this.updateFormula();
        if (this.parent != null) {
            this.parent.update(this.opinion, this.ID);
        }
    }

    public void updateFormula() {
        this.formula = new SLFormula(this.left.formula, this.operator, this.right.formula);
        this.name.setText(this.formula.toString());
        this.name.setSize(this.name.getPreferredSize());
    }

    public void showResult(boolean b) {
        if (b && !this.showResult) {
            this.iss = new IsSign();
            this.iss.setSize(this.operator.getSize());
            this.add(this.iss);
            this.result = new SLObject(SPACING, this.getOpinionType(), this.operator.applyOperator(this.left.opinion, this.right.opinion), this, true);
            this.add(this.result);
        } else if (!b && this.showResult) {
            this.remove(this.result);
            this.remove(this.iss);
            this.result = null;
        }
        this.showResult = b;
        this.propagatePaint();
    }

    @Override
    public SLCalculation clone() {
        SLOperation result = new SLOperation(this.decay, this.operator.getType(), this.left.clone(), this.right.clone(), this.getMyParent(), this.showResult, this.dependancies);
        return result;
    }

    @Override
    public void makePassive(boolean b) {
        this.left.makePassive(b);
        this.right.makePassive(b);
    }

    @Override
    public void collapse(int col) {
        switch (col) {
            case 0: {
                this.parent.replace(this.ID, new SLObject(this.decay, this.getOpinionType(), this.opinion, this.parent, false));
                break;
            }
            case 2: {
                this.left.parent = this.parent;
                this.parent.replace(this.ID, this.left);
                break;
            }
            case 1: {
                this.right.parent = this.parent;
                this.parent.replace(this.ID, this.right);
                break;
            }
        }
        this.propagatePaint();
    }

    public boolean isShowResult() {
        return this.showResult;
    }

    @Override
    public void substitute(SLObject slo) {
        throw new RuntimeException("Cannot substitute non-atomic opinions.");
    }

    @Override
    public boolean contains(SLCalculation c) {
        if (c.ID == this.ID) {
            return true;
        }
        return this.left.contains(c) || this.right.contains(c);
    }

    @Override
    public LinkedList<SLCalculation> getAllSubtermsModuloAssociativity(int op) {
        if (op == this.operator.getType()) {
            LinkedList<SLCalculation> lefts = this.left.getAllSubtermsModuloAssociativity(op);
            LinkedList<SLCalculation> rights = this.right.getAllSubtermsModuloAssociativity(op);
            lefts.addAll(rights);
            return lefts;
        }
        LinkedList<SLCalculation> result = new LinkedList<SLCalculation>();
        result.add(this);
        return result;
    }

    @Override
    public int getOperatorInt() {
        return this.operator.getType();
    }

    private class IsSign
    extends JPanel {
        private IsSign() {
        }

        @Override
        public void paint(Graphics g) {
            g.drawLine(0, 0, this.getWidth(), 0);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
    }
}

