/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BitSetPBN;
import PBN.Engine;
import PBN.PBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.RandomProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import simulator.AliasMethod;
import simulator.ObjectAliasMethod;

public class BitSetEngine
extends Engine {
    protected boolean aliasGenerated;
    private boolean globalCij;
    private final int maxCijLength = 10000000;
    private int multiFun;
    private int ySize;
    private int[] ycij;
    private boolean ySizeCalculated;
    private ObjectAliasMethod globalAliasmethod;
    private boolean disableGlobalcij;
    private boolean lock;

    public BitSetEngine(PBN pbn) {
        this.pbn = (BitSetPBN)pbn;
        this.aliasGenerated = false;
        this.aliasMethodList = new ArrayList();
        this.random = RandomProvider.getInstance().getRandom();
        this.globalCij = false;
        this.disableGlobalcij = true;
    }

    public void setdisableGlobalcij(boolean dis) {
        this.disableGlobalcij = dis;
    }

    private boolean determinGlobalCij() {
        if (this.disableGlobalcij) {
            this.globalCij = false;
            return this.globalCij;
        }
        int[] nf = this.pbn.getNf();
        this.multiFun = 1;
        int i = 0;
        while (i < nf.length) {
            this.multiFun *= nf[i];
            if (this.multiFun > 10000000) {
                this.globalCij = false;
                System.out.println("Local alias mode is used.");
                return this.globalCij;
            }
            ++i;
        }
        this.globalCij = true;
        return this.globalCij;
    }

    @Override
    public void pbnNextState(StateBit st) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        StateBit copySt = (StateBit)st.clone();
        boolean perturbation = false;
        List<Integer> npNode = this.pbn.npNode();
        int start = 0;
        for (int element : npNode) {
            int i = start;
            while (i < element) {
                if (this.pbn.getPerturbation() > ThreadLocalRandom.current().nextDouble()) {
                    st.flip(i);
                    perturbation = true;
                }
                ++i;
            }
            start = element + 1;
        }
        if (perturbation) {
            return;
        }
        this.generateAlias();
        if (this.globalCij) {
            this.pbnNextStateGlobal(st, copySt);
        } else {
            int[] cumNf = this.pbn.buildCumNf();
            int indexCij = 0;
            int i = 0;
            while (i < n) {
                AliasMethod alias = (AliasMethod)this.aliasMethodList.get(i);
                indexCij = alias.next();
                st.set(i, this.pbn.getNextNodeValue(cumNf[i] + indexCij, copySt));
                ++i;
            }
        }
    }

    public void pbnNextState(StateBit st, boolean enablePerturbation) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        StateBit copySt = (StateBit)st.clone();
        if (enablePerturbation) {
            this.pbnNextState(st);
        } else {
            this.generateAlias();
            if (this.globalCij) {
                this.pbnNextStateGlobal(st, copySt);
            } else {
                int[] cumNf = this.pbn.buildCumNf();
                int indexCij = 0;
                int i = 0;
                while (i < n) {
                    indexCij = ((AliasMethod)this.aliasMethodList.get(i)).next();
                    st.set(i, this.pbn.getNextNodeValue(cumNf[i] + indexCij, copySt));
                    ++i;
                }
            }
        }
    }

    public void pbnNextStepState(StateBit st, double random) throws Exception {
        int n = this.pbn.getN();
        if (n > 63) {
            throw new Exception("Nodes number exceed the maximum value 63!");
        }
        long index = st.getLongFromTo(0, n);
    }

    public List<Integer> pbnNextEventState(StateBit st, double[] event) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        StateBit copySt = (StateBit)st.clone();
        boolean perturbation = false;
        int i = 0;
        while (i < n) {
            if (this.pbn.getPerturbation() > event[i]) {
                st.flip(i);
                perturbation = true;
                result.add(i);
            }
            ++i;
        }
        if (perturbation) {
            result.add(1);
            return result;
        }
        this.generateAlias();
        if (this.globalCij) {
            throw new Exception("Only local alias table is allowed! Please restart using local alias table.");
        }
        int[] cumNf = this.pbn.buildCumNf();
        int indexCij = 0;
        i = 0;
        while (i < n) {
            indexCij = ((AliasMethod)this.aliasMethodList.get(i)).next(event[n + 2 * i], event[n + 2 * i + 1]);
            int tmp = cumNf[i] + indexCij;
            result.add(tmp);
            st.set(i, this.pbn.getNextNodeValue(tmp, copySt));
            ++i;
        }
        result.add(0);
        return result;
    }

    public void pbnNextEventState(StateBit st, List<Integer> index) throws Exception {
        int n = this.pbn.getN();
        if (st.getN() != n) {
            throw new Exception("State size does not coinside with the PBN!");
        }
        if (index.get(index.size() - 1) == 1) {
            int i = 0;
            while (i < index.size() - 1) {
                st.flip(index.get(i));
                ++i;
            }
        } else {
            StateBit copySt = (StateBit)st.clone();
            int i = 0;
            while (i < n) {
                st.set(i, this.pbn.getNextNodeValue(index.get(i), copySt));
                ++i;
            }
        }
    }

    private void pbnNextStateGlobal(StateBit st, StateBit copySt) throws Exception {
        List<Integer> select = this.globalAliasmethod.next();
        int n = this.pbn.getN();
        int[] cumNf = this.pbn.buildCumNf();
        int i = 0;
        while (i < n) {
            st.set(i, this.pbn.getNextNodeValue(cumNf[i] + select.get(i), copySt));
            ++i;
        }
    }

    public void generateAlias() {
        if (this.aliasGenerated) {
            return;
        }
        if (this.determinGlobalCij()) {
            this.generateGlobalAlias();
            return;
        }
        int i = 0;
        while (i < this.pbn.getN()) {
            int non_zero = ((BitSetPBN)this.pbn).getCij().get(i).length;
            int[] y = new int[non_zero];
            double[] probabilities = new double[non_zero];
            int j = 0;
            while (j < non_zero) {
                y[j] = j;
                probabilities[j] = ((BitSetPBN)this.pbn).getCij().get(i)[j];
                ++j;
            }
            AliasMethod aliasmethod = new AliasMethod(probabilities, this.random, y);
            this.aliasMethodList.add(aliasmethod);
            ++i;
        }
        this.aliasGenerated = true;
    }

    private void generateGlobalAlias() {
        double[] probabilities = new double[this.multiFun];
        ArrayList[] y = new ArrayList[this.multiFun];
        BitVector b = new BitVector(this.calculateYSize());
        System.out.println("globalAlaisTableLength" + this.multiFun);
        int j = 0;
        while (j < this.multiFun) {
            b.putLongFromTo(j, 0, this.calculateYSize() - 1);
            y[j] = new ArrayList();
            int i = 0;
            while (i < this.pbn.getN()) {
                int indexCij = (int)b.getLongFromTo(this.ycij[i], this.ycij[i + 1] - 1);
                y[j].add(indexCij);
                ++i;
            }
            ++j;
        }
        this.setProbabilities(0, 0, 1.0, probabilities, b);
        this.globalAliasmethod = new ObjectAliasMethod(probabilities, this.random, y);
        this.aliasGenerated = true;
    }

    private int setProbabilities(int i, int index, double multi, double[] probabilities, BitVector b) {
        double[] cijElement = ((BitSetPBN)this.pbn).getCij().get(i);
        if (i < this.pbn.getN() - 1) {
            int k = 0;
            while (k < this.pbn.getNf()[i]) {
                b.putLongFromTo(k, this.ycij[i], this.ycij[i + 1] - 1);
                index = this.setProbabilities(i + 1, index, multi * cijElement[k], probabilities, b);
                ++k;
            }
        } else {
            int k = 0;
            while (k < this.pbn.getNf()[i]) {
                b.putLongFromTo(k, this.ycij[i], this.ycij[i + 1] - 1);
                probabilities[index] = multi * cijElement[k];
                ++index;
                ++k;
            }
        }
        return index;
    }

    private int calculateYSize() {
        if (this.ySizeCalculated) {
            return this.ySize;
        }
        int[] nf = this.pbn.getNf();
        int length = 0;
        this.ycij = new int[this.pbn.getN() + 1];
        this.ycij[0] = 0;
        int i = 0;
        while (i < nf.length) {
            this.ycij[i + 1] = (int)Math.ceil(Math.log(nf[i]) / Math.log(2.0));
            if (Math.pow(2.0, this.ycij[i + 1] - 1) > (double)nf[i]) {
                this.ycij[i + 1] = this.ycij[i + 1] - 1;
            }
            this.ycij[i + 1] = length += this.ycij[i + 1];
            ++i;
        }
        this.ySize = length;
        this.ySizeCalculated = true;
        return length;
    }
}

