/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.PBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import simulator.RandomNumberGenerator;

public class BitSetPBN
extends PBN {
    private List<double[]> cij;

    public BitSetPBN(int n) {
        this.n = n;
        this.nf = new int[n];
        this.nv = new ArrayList();
        this.F = new ArrayList();
        this.varF = new ArrayList();
        this.cij = new ArrayList<double[]>();
        this.perturbation = 0.0;
        this.npNode = new ArrayList();
        this.npNode.add(n);
    }

    public void generateRandomPBN(int[] nf, List<Integer> nv) throws Exception {
        int j;
        this.setNf(nf);
        this.setNv(nv);
        int cumulativeNf = nv.size();
        RandomNumberGenerator rng = new RandomNumberGenerator();
        double ran = rng.randomUnifDouble();
        int i = 0;
        while (i < cumulativeNf) {
            BitSet elementVarF = new BitSet();
            Integer[] varIndex = rng.randomInt(nv.get(i), 0, this.n - 1);
            j = 0;
            while (j < varIndex.length) {
                elementVarF.set(varIndex[j]);
                ++j;
            }
            this.varF.add(elementVarF);
            int nv_tmp = (int)Math.pow(2.0, nv.get(i).intValue());
            boolean[] elementF = new boolean[nv_tmp];
            j = 0;
            while (j < nv_tmp) {
                elementF[j] = rng.randomUnifDouble() > ran;
                ++j;
            }
            this.F.add(elementF);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            double[] elementCij = new double[nf[i]];
            double tmp = 0.0;
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = rng.randomUnifDouble();
                tmp += elementCij[j];
                ++j;
            }
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = elementCij[j] / tmp;
                ++j;
            }
            this.cij.add(elementCij);
            ++i;
        }
        System.out.println("One " + this.n + " nodes PBN is generated. Its density is " + this.density() + ".");
    }

    public void generateRandomPBNWithExpression(int[] nf, List<Integer> nv) throws Exception {
        int j;
        this.setNf(nf);
        this.setNv(nv);
        int cumulativeNf = nv.size();
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int i = 0;
        while (i < cumulativeNf) {
            BitSet elementVarF = new BitSet();
            Integer[] varIndex = rng.randomInt(nv.get(i), 0, this.n - 1);
            j = 0;
            while (j < varIndex.length) {
                elementVarF.set(varIndex[j]);
                ++j;
            }
            this.varF.add(elementVarF);
            double ran = rng.randomUnifDouble();
            BitVector expression = new BitVector(nv.get(i));
            BitVector expression2 = new BitVector(nv.get(i));
            BitVector expressionValidate = new BitVector(nv.get(i));
            j = 0;
            while (j < nv.get(i)) {
                double ran1 = rng.randomUnifDouble();
                if (ran1 > ran) {
                    expression.set(j);
                }
                ++j;
            }
            int nv_tmp = (int)Math.pow(2.0, nv.get(i).intValue());
            boolean[] elementF = new boolean[nv_tmp];
            if (expression.cardinality() == 0) {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expression2.not();
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    elementF[j] = expression2.cardinality() == 0;
                    ++j;
                }
            } else if (expression.cardinality() == nv.get(i).intValue()) {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    elementF[j] = expression2.cardinality() > 0;
                    ++j;
                }
            } else {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expression2.not();
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    if (expression2.cardinality() == 0) {
                        expression2.clear();
                        expression2.xor(expression);
                        expression2.and(expressionValidate);
                        elementF[j] = expression2.cardinality() > 0;
                    } else {
                        elementF[j] = false;
                    }
                    ++j;
                }
            }
            this.F.add(elementF);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            double[] elementCij = new double[nf[i]];
            double tmp = 0.0;
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = rng.randomUnifDouble();
                tmp += elementCij[j];
                ++j;
            }
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = elementCij[j] / tmp;
                ++j;
            }
            this.cij.add(elementCij);
            ++i;
        }
        System.out.println("One " + this.n + " nodes PBN is generated. Its density is " + this.density() + ".");
    }

    public void generateRandomPBNWithExpression(int[] nf, List<Integer> nv, double[] distribution) throws Exception {
        int j;
        this.setNf(nf);
        this.setNv(nv);
        int cumulativeNf = nv.size();
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int i = 0;
        while (i < cumulativeNf) {
            BitSet elementVarF = new BitSet();
            Integer[] varIndex = rng.randomInt(nv.get(i), 0, this.n - 1);
            j = 0;
            while (j < varIndex.length) {
                elementVarF.set(varIndex[j]);
                ++j;
            }
            this.varF.add(elementVarF);
            double ran = rng.randomUnifDouble();
            BitVector expression = new BitVector(nv.get(i));
            BitVector expression2 = new BitVector(nv.get(i));
            BitVector expressionValidate = new BitVector(nv.get(i));
            j = 0;
            while (j < nv.get(i)) {
                double ran1 = rng.randomUnifDouble();
                if (ran1 > ran) {
                    expression.set(j);
                }
                ++j;
            }
            int nv_tmp = (int)Math.pow(2.0, nv.get(i).intValue());
            boolean[] elementF = new boolean[nv_tmp];
            if (expression.cardinality() == 0) {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expression2.not();
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    elementF[j] = expression2.cardinality() == 0;
                    ++j;
                }
            } else if (expression.cardinality() == nv.get(i).intValue()) {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    elementF[j] = expression2.cardinality() > 0;
                    ++j;
                }
            } else {
                j = 0;
                while (j < nv_tmp) {
                    expression2.clear();
                    expression2.xor(expression);
                    expression2.not();
                    expressionValidate.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression2.and(expressionValidate);
                    if (expression2.cardinality() == 0) {
                        expression2.clear();
                        expression2.xor(expression);
                        expression2.and(expressionValidate);
                        elementF[j] = expression2.cardinality() > 0;
                    } else {
                        elementF[j] = false;
                    }
                    ++j;
                }
            }
            this.F.add(elementF);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            double[] elementCij = new double[nf[i]];
            double tmp = 0.0;
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = rng.randomUnifDouble();
                tmp += elementCij[j];
                ++j;
            }
            j = 0;
            while (j < nf[i]) {
                elementCij[j] = elementCij[j] / tmp;
                ++j;
            }
            this.cij.add(elementCij);
            ++i;
        }
        System.out.println("One " + this.n + " nodes PBN is generated. Its density is " + this.density() + ".");
    }

    public double density() throws Exception {
        this.buildCumNf();
        double total = 0.0;
        int i = 0;
        while (i < this.cumNf[this.n]) {
            total += (double)((Integer)this.nv.get(i)).intValue();
            ++i;
        }
        return total / (double)this.n;
    }

    @Override
    public int[] buildCumNf() throws Exception {
        if (this.nf == null) {
            throw new Exception("Cannot build cumNf before nf is initilised.");
        }
        if (this.cumNf != null) {
            return this.cumNf;
        }
        this.cumNf = new int[this.n + 1];
        this.cumNf[0] = 0;
        int i = 0;
        while (i < this.nf.length) {
            this.cumNf[i + 1] = this.cumNf[i] + this.nf[i];
            ++i;
        }
        return this.cumNf;
    }

    @Override
    public void setNf(int[] nf) {
        this.nf = nf;
    }

    @Override
    public void setNv(List<Integer> nv) {
        this.nv = nv;
    }

    @Override
    public void setF(List<boolean[]> F) {
        this.F = F;
    }

    @Override
    public void setvarF(List<BitSet> varF) {
        this.varF = varF;
    }

    public void setCij(List<double[]> cij) {
        this.cij = cij;
    }

    @Override
    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public int[] getNf() {
        return this.nf;
    }

    @Override
    public List<Integer> getNv() {
        return this.nv;
    }

    @Override
    public List<boolean[]> getF() {
        return this.F;
    }

    @Override
    public List<BitSet> getVarF() {
        return this.varF;
    }

    public List<double[]> getCij() {
        return this.cij;
    }

    @Override
    public double getPerturbation() {
        return this.perturbation;
    }

    @Override
    public boolean getNextNodeValue(int indexVarF, StateBit currentState) {
        BitSet elementVarF = (BitSet)this.varF.get(indexVarF);
        boolean[] elementF = (boolean[])this.F.get(indexVarF);
        StateBit copyCurrentState = (StateBit)currentState.clone();
        copyCurrentState.and(elementVarF);
        BitVector bitVector = new BitVector(elementVarF.cardinality());
        int index = -1;
        int count = 0;
        while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
            bitVector.put(count, copyCurrentState.get(index));
            ++count;
        }
        return elementF[(int)bitVector.getLongFromTo(0, bitVector.size() - 1)];
    }

    @Override
    public int getStateLength() {
        return this.getN();
    }
}

