/*
 * Decompiled with CFR 0.152.
 */
package PBN;

import PBN.BitSetPBN;
import PBN.ContextPBN;
import PBN.Node;
import PBN.PBN;
import PBN.Path;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.IntegerReverse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;

public class BitSetPBNIO {
    private PBN pbn;
    private int n;
    private final double ZERO = 1.0E-11;
    private int PBNtype;
    private List<Node> nodesName;

    public BitSetPBNIO() {
    }

    public BitSetPBNIO(PBN pbn) {
        this.pbn = pbn;
        this.n = pbn.getN();
        this.determinePBNtype();
    }

    public void determinePBNtype() {
        this.PBNtype = this.pbn instanceof ContextPBN ? 1 : 0;
    }

    public BitSetPBN loadPBN(String fileName) throws Exception {
        ArrayList<Integer> nv;
        ArrayList<Integer> npNode;
        double perturbation;
        ArrayList<double[]> cij;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        int[] nf;
        int n;
        long cpu;
        ThreadMXBean thread;
        block54: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            cij = new ArrayList<double[]>();
            boolean[] functionElement = null;
            BitSet varFElement = null;
            double[] cijElement = null;
            ArrayList<Integer> tmpVarFElement = null;
            int[] orderVar = null;
            boolean needReorder = false;
            perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            boolean comment = false;
            int sumNf = 0;
            int count = 0;
            nv = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block30: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    nf[column - 1] = Integer.parseInt(str);
                                    sumNf += nf[column - 1];
                                    break;
                                }
                                case 3: {
                                    nv.add(Integer.parseInt(str));
                                    break;
                                }
                                case 4: {
                                    if (column == 1) {
                                        functionElement = new boolean[(int)Math.pow(2.0, ((Integer)nv.get(F.size())).intValue())];
                                    }
                                    if (Integer.parseInt(str) == 1) {
                                        functionElement[column - 1] = true;
                                        break;
                                    }
                                    functionElement[column - 1] = false;
                                    break;
                                }
                                case 5: {
                                    if (column == 1) {
                                        varFElement = new BitSet(n);
                                        tmpVarFElement = new ArrayList<Integer>();
                                        tmpVarFElement.add(Integer.parseInt(str));
                                    } else {
                                        tmpVarFElement.add(Integer.parseInt(str));
                                        if ((Integer)tmpVarFElement.get(tmpVarFElement.size() - 1) < (Integer)tmpVarFElement.get(tmpVarFElement.size() - 2)) {
                                            needReorder = true;
                                        }
                                    }
                                    varFElement.set((Integer)tmpVarFElement.get(tmpVarFElement.size() - 1));
                                    break;
                                }
                                case 6: {
                                    if (column == 1) {
                                        cijElement = new double[nf[count]];
                                    }
                                    cijElement[column - 1] = Double.parseDouble(str);
                                    break;
                                }
                                case 7: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                case 8: {
                                    npNode.add(Integer.parseInt(str));
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block30;
                                }
                                case 2: {
                                    line = 3;
                                    continue block30;
                                }
                                case 3: {
                                    line = 4;
                                    continue block30;
                                }
                                case 4: {
                                    F.add(functionElement);
                                    if (count == sumNf - 1) {
                                        line = 5;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 5: {
                                    if (needReorder) {
                                        int fromIndex = 0;
                                        orderVar = new int[tmpVarFElement.size()];
                                        int orderIndex = 0;
                                        while ((fromIndex = varFElement.nextSetBit(fromIndex)) != -1) {
                                            int index = 0;
                                            while (index < tmpVarFElement.size()) {
                                                if ((Integer)tmpVarFElement.get(index) == fromIndex) {
                                                    orderVar[orderIndex] = index;
                                                    ++orderIndex;
                                                    break;
                                                }
                                                ++index;
                                            }
                                            ++fromIndex;
                                        }
                                        functionElement = (boolean[])F.get(varF.size());
                                        boolean[] tmpFunctionElement = (boolean[])functionElement.clone();
                                        BitVector oldOrder = new BitVector(orderVar.length);
                                        BitVector newOrder = new BitVector(orderVar.length);
                                        int i = 0;
                                        while (i < functionElement.length) {
                                            oldOrder.putLongFromTo(i, 0, orderVar.length - 1);
                                            int j = 0;
                                            while (j < orderVar.length) {
                                                newOrder.put(j, oldOrder.get(orderVar[j]));
                                                ++j;
                                            }
                                            functionElement[(int)newOrder.getLongFromTo((int)0, (int)(orderVar.length - 1))] = tmpFunctionElement[i];
                                            ++i;
                                        }
                                        needReorder = false;
                                    }
                                    varF.add(varFElement);
                                    if (count == sumNf - 1) {
                                        line = 6;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 6: {
                                    cij.add(cijElement);
                                    if (count == n - 1) {
                                        line = 7;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 7: {
                                    line = 8;
                                    continue block30;
                                }
                                case 8: {
                                    line = 9;
                                    continue block30;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block54;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        BitSetPBN pbn = new BitSetPBN(n);
        pbn.setNf(nf);
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(cij);
        pbn.setPerturbation(perturbation);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public BitSetPBN loadPBNBackUp(String fileName) throws Exception {
        ArrayList<Integer> nv;
        ArrayList<Integer> npNode;
        double perturbation;
        ArrayList<double[]> cij;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        int[] nf;
        int n;
        long cpu;
        ThreadMXBean thread;
        block46: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            cij = new ArrayList<double[]>();
            boolean[] functionElement = null;
            BitSet varFElement = null;
            double[] cijElement = null;
            perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            boolean comment = false;
            int sumNf = 0;
            int count = 0;
            nv = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block30: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    nf[column - 1] = Integer.parseInt(str);
                                    sumNf += nf[column - 1];
                                    break;
                                }
                                case 3: {
                                    nv.add(Integer.parseInt(str));
                                    break;
                                }
                                case 4: {
                                    if (column == 1) {
                                        functionElement = new boolean[(int)Math.pow(2.0, ((Integer)nv.get(F.size())).intValue())];
                                    }
                                    if (Integer.parseInt(str) == 1) {
                                        functionElement[column - 1] = true;
                                        break;
                                    }
                                    functionElement[column - 1] = false;
                                    break;
                                }
                                case 5: {
                                    if (column == 1) {
                                        varFElement = new BitSet(n);
                                    }
                                    varFElement.set(Integer.parseInt(str));
                                    break;
                                }
                                case 6: {
                                    if (column == 1) {
                                        cijElement = new double[nf[count]];
                                    }
                                    cijElement[column - 1] = Double.parseDouble(str);
                                    break;
                                }
                                case 7: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                case 8: {
                                    npNode.add(Integer.parseInt(str));
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block30;
                                }
                                case 2: {
                                    line = 3;
                                    continue block30;
                                }
                                case 3: {
                                    line = 4;
                                    continue block30;
                                }
                                case 4: {
                                    F.add(functionElement);
                                    if (count == sumNf - 1) {
                                        line = 5;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 5: {
                                    varF.add(varFElement);
                                    if (count == sumNf - 1) {
                                        line = 6;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 6: {
                                    cij.add(cijElement);
                                    if (count == n - 1) {
                                        line = 7;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 7: {
                                    line = 8;
                                    continue block30;
                                }
                                case 8: {
                                    line = 9;
                                    continue block30;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block46;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        BitSetPBN pbn = new BitSetPBN(n);
        pbn.setNf(nf);
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(cij);
        pbn.setPerturbation(perturbation);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public BitSetPBN loadPBNFromGenYsis(String fileName) throws Exception {
        Node node;
        ArrayList<Integer> nv;
        ArrayList<Integer> npNode;
        ArrayList<double[]> cij;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        int[] nf;
        int n;
        long cpu;
        ThreadMXBean thread;
        block35: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model from " + fileName + "...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            cij = new ArrayList<double[]>();
            Object functionElement = null;
            Object varFElement = null;
            Object cijElement = null;
            double perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            boolean comment = false;
            boolean inhibite = false;
            boolean sumNf = false;
            boolean count = false;
            nv = new ArrayList<Integer>();
            this.nodesName = new ArrayList<Node>();
            ArrayList activators = new ArrayList();
            ArrayList inhibitors = new ArrayList();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    boolean line = true;
                    while ((tempString = reader.readLine()) != null) {
                        int childIndex;
                        StringTokenizer st;
                        if (tempString.contains("^")) {
                            throw new Exception("can not handle ^ expressions!");
                        }
                        if (tempString.contains("-|")) {
                            inhibite = true;
                            st = new StringTokenizer(tempString, "-| ");
                        } else {
                            inhibite = false;
                            st = new StringTokenizer(tempString, "-> ");
                        }
                        String str = st.nextToken();
                        node = new Node(str, this.nodesName.size());
                        int parentIndex = this.nodesName.indexOf(node);
                        if (parentIndex == -1) {
                            this.nodesName.add(node);
                            parentIndex = this.nodesName.size() - 1;
                        }
                        if ((childIndex = this.nodesName.indexOf(node = new Node(str = st.nextToken(), this.nodesName.size()))) == -1) {
                            this.nodesName.add(node);
                            childIndex = this.nodesName.size() - 1;
                        }
                        if (inhibite) {
                            this.nodesName.get((int)childIndex).inhibitors.add(parentIndex);
                            continue;
                        }
                        this.nodesName.get((int)childIndex).activators.add(parentIndex);
                    }
                    reader.close();
                    int i = 0;
                    while (i < this.nodesName.size()) {
                        System.out.print(String.valueOf(this.nodesName.get((int)i).nodeName) + "\tactivators: ");
                        for (Integer e : this.nodesName.get((int)i).activators) {
                            System.out.print(e + " ");
                        }
                        System.out.print("\tinhibitors: ");
                        for (Integer e : this.nodesName.get((int)i).inhibitors) {
                            System.out.print(e + " ");
                        }
                        System.out.println();
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        n = this.nodesName.size();
        BitSetPBN pbn = new BitSetPBN(n);
        nf = new int[n];
        int i = 0;
        while (i < n) {
            nf[i] = 1;
            ++i;
        }
        i = 0;
        while (i < n) {
            System.out.println(String.valueOf(i) + " " + this.nodesName.get((int)i).nodeName);
            ++i;
        }
        pbn.setNf(nf);
        nv = new ArrayList();
        varF = new ArrayList();
        F = new ArrayList();
        cij = new ArrayList();
        int i2 = 0;
        while (i2 < n) {
            node = this.nodesName.get(i2);
            nv.add(node.getActivators().size() + node.getInhibitors().size());
            BitVector expression = new BitVector((Integer)nv.get(i2));
            BitVector expressionValidate = new BitVector((Integer)nv.get(i2));
            BitSet elementVarF = new BitSet(n);
            for (Integer e : node.getActivators()) {
                elementVarF.set(e);
            }
            for (Integer e : node.getInhibitors()) {
                elementVarF.set(e);
            }
            int index = elementVarF.nextSetBit(0);
            int countIndex = 0;
            while (index != -1) {
                if (node.getActivators().contains(new Integer(index))) {
                    expression.set(countIndex);
                }
                ++countIndex;
                index = elementVarF.nextSetBit(index + 1);
            }
            varF.add(elementVarF);
            int nv_tmp = (int)Math.pow(2.0, ((Integer)nv.get(i2)).intValue());
            boolean[] elementF = new boolean[nv_tmp];
            BitVector expression2 = new BitVector((Integer)nv.get(i2));
            int j = 0;
            while (j < nv_tmp) {
                expression2.clear();
                expression2.xor(expression);
                expression2.not();
                expressionValidate.putLongFromTo(j, 0, (Integer)nv.get(i2) - 1);
                expression2.and(expressionValidate);
                if (expression2.cardinality() == 0) {
                    expression2.clear();
                    expression2.xor(expression);
                    expression2.and(expressionValidate);
                    elementF[j] = expression2.cardinality() > 0;
                } else {
                    elementF[j] = false;
                }
                ++j;
            }
            F.add(elementF);
            double[] elementCij = new double[]{1.0};
            cij.add(elementCij);
            ++i2;
        }
        pbn.setNv(nv);
        pbn.setvarF(varF);
        pbn.setF(F);
        pbn.setCij(cij);
        pbn.setPerturbation(0.001);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public ContextPBN loadContextPBN(String fileName) throws Exception {
        ArrayList[] tmpF;
        ArrayList[] tmpVarF;
        ArrayList<Integer> nv;
        int count;
        ArrayList<Integer> npNode;
        double perturbation;
        ArrayList<int[]> BN;
        ArrayList<BitVector> BNindex;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        double p_swi;
        double[] swi;
        int[] nf;
        int bn;
        int n;
        long cpu;
        ThreadMXBean thread;
        block64: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            bn = 0;
            BitVector elementBNindex = null;
            int[] nn = null;
            nf = null;
            swi = null;
            p_swi = 0.0;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            BNindex = new ArrayList<BitVector>();
            BN = new ArrayList<int[]>();
            perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            boolean comment = false;
            count = 0;
            int countBNindex = 0;
            nv = new ArrayList<Integer>();
            tmpVarF = null;
            tmpF = null;
            BitSet tmpElementvarF = null;
            boolean[] tmpElementF = null;
            int nodeindex = 0;
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block34: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    tmpVarF = new ArrayList[n];
                                    tmpF = new ArrayList[n];
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    bn = Integer.parseInt(str);
                                    nn = new int[bn];
                                    break;
                                }
                                case 3: {
                                    nn[column - 1] = Integer.parseInt(str);
                                    int[] elementBN = new int[nn[column - 1]];
                                    BN.add(elementBN);
                                    break;
                                }
                                case 4: {
                                    if (count == 0) {
                                        elementBNindex = new BitVector(n);
                                        ++countBNindex;
                                    }
                                    ++count;
                                    nodeindex = Integer.parseInt(str);
                                    elementBNindex.set(nodeindex);
                                    break;
                                }
                                case 5: {
                                    if (column == 1) {
                                        tmpElementvarF = new BitSet();
                                    }
                                    tmpElementvarF.set(Integer.parseInt(str));
                                    break;
                                }
                                case 6: {
                                    if (column == 1) {
                                        tmpElementF = new boolean[(int)Math.pow(2.0, tmpElementvarF.cardinality())];
                                    }
                                    if (Integer.parseInt(str) == 1) {
                                        tmpElementF[column - 1] = true;
                                        break;
                                    }
                                    tmpElementF[column - 1] = false;
                                    break;
                                }
                                case 7: {
                                    swi[column - 1] = Double.parseDouble(str);
                                    break;
                                }
                                case 8: {
                                    p_swi = Double.parseDouble(str);
                                    break;
                                }
                                case 9: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                case 10: {
                                    npNode.add(Integer.parseInt(str));
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block34;
                                }
                                case 2: {
                                    line = 3;
                                    continue block34;
                                }
                                case 3: {
                                    line = 4;
                                    continue block34;
                                }
                                case 4: {
                                    line = 5;
                                    continue block34;
                                }
                                case 5: {
                                    if (tmpVarF[nodeindex] == null) {
                                        tmpVarF[nodeindex] = new ArrayList();
                                    }
                                    tmpVarF[nodeindex].add(tmpElementvarF);
                                    line = 6;
                                    continue block34;
                                }
                                case 6: {
                                    if (tmpF[nodeindex] == null) {
                                        tmpF[nodeindex] = new ArrayList();
                                    }
                                    tmpF[nodeindex].add(tmpElementF);
                                    if (countBNindex < bn) {
                                        line = 4;
                                        if (count != nn[countBNindex - 1]) continue block34;
                                        count = 0;
                                        BNindex.add(elementBNindex);
                                        continue block34;
                                    }
                                    if (countBNindex == bn && count < nn[countBNindex - 1]) {
                                        line = 4;
                                        continue block34;
                                    }
                                    BNindex.add(elementBNindex);
                                    swi = new double[bn];
                                    line = 7;
                                    continue block34;
                                }
                                case 7: {
                                    line = 8;
                                    continue block34;
                                }
                                case 8: {
                                    line = 9;
                                    continue block34;
                                }
                                case 9: {
                                    line = 10;
                                    continue block34;
                                }
                                case 10: {
                                    line = 11;
                                    continue block34;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block64;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        ContextPBN pbn = new ContextPBN(n);
        ArrayList[] storeDuplicated = null;
        storeDuplicated = new ArrayList[n];
        int tmp = 0;
        int i = 0;
        while (i < n) {
            nf[i] = tmpF[i].size();
            int j = 0;
            while (j < tmpF[i].size()) {
                int elementNv = ((BitSet)tmpVarF[i].get(j)).cardinality();
                BitSet elementVarF = (BitSet)tmpVarF[i].get(j);
                boolean[] elementF = (boolean[])tmpF[i].get(j);
                boolean same = false;
                tmp = 0;
                while (tmp < j) {
                    if (elementNv == (Integer)nv.get(nv.size() - 1 - tmp) && elementVarF.equals(varF.get(varF.size() - 1 - tmp)) && Arrays.equals(elementF, (boolean[])F.get(F.size() - 1 - tmp))) {
                        same = true;
                        break;
                    }
                    ++tmp;
                }
                if (same) {
                    int n2 = i;
                    nf[n2] = nf[n2] - 1;
                    if (storeDuplicated[i] == null) {
                        storeDuplicated[i] = new ArrayList();
                    }
                    int[] elementDup = new int[]{j, j - tmp - 1};
                    storeDuplicated[i].add(elementDup);
                } else {
                    nv.add(((BitSet)tmpVarF[i].get(j)).cardinality());
                    varF.add((BitSet)tmpVarF[i].get(j));
                    F.add((boolean[])tmpF[i].get(j));
                }
                ++j;
            }
            ++i;
        }
        int start = 0;
        int[] assignvalue = new int[n];
        int i2 = 0;
        while (i2 < bn) {
            start = 0;
            start = ((BitVector)BNindex.get(i2)).indexOfFromTo(start, BNindex.size() - 1, true);
            count = 0;
            while (start >= 0) {
                boolean same = false;
                if (storeDuplicated[start] != null) {
                    int j = 0;
                    while (j < storeDuplicated[start].size()) {
                        if (((int[])storeDuplicated[start].get(j))[0] == assignvalue[start]) {
                            ((int[])BN.get((int)i2))[count] = ((int[])storeDuplicated[start].get(j))[1];
                            same = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!same) {
                    ((int[])BN.get((int)i2))[count] = assignvalue[start];
                    int n3 = start;
                    assignvalue[n3] = assignvalue[n3] + 1;
                }
                ++count;
                if (++start >= BNindex.size()) break;
                start = ((BitVector)BNindex.get(i2)).indexOfFromTo(start, BNindex.size() - 1, true);
            }
            ++i2;
        }
        pbn.setNf(nf);
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setBN(BN);
        pbn.setBNindex(BNindex);
        pbn.setP_swi(p_swi);
        pbn.setSwi(swi);
        pbn.setPerturbation(perturbation);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public BitSetPBN generatePBNFromFile(String fileName) throws Exception {
        ArrayList<Integer> nv;
        double perturbation;
        int[] nf;
        int n;
        block30: {
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            perturbation = 0.0;
            boolean comment = false;
            nv = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block22: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    nf[column - 1] = Integer.parseInt(str);
                                    break;
                                }
                                case 3: {
                                    nv.add(Integer.parseInt(str));
                                    break;
                                }
                                case 4: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block22;
                                }
                                case 2: {
                                    line = 3;
                                    continue block22;
                                }
                                case 3: {
                                    line = 4;
                                    continue block22;
                                }
                                case 4: {
                                    line = 5;
                                    continue block22;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        BitSetPBN pbn = new BitSetPBN(n);
        pbn.generateRandomPBN(nf, nv);
        pbn.setPerturbation(perturbation);
        this.pbn = pbn;
        this.n = n;
        return pbn;
    }

    public BitSetPBN loadPBN(String fileName, Boolean reverse) throws Exception {
        ArrayList<Integer> nv;
        ArrayList<Integer> npNode;
        double perturbation;
        ArrayList<double[]> cij;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        int[] nf;
        int n;
        long cpu;
        ThreadMXBean thread;
        block55: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            cij = new ArrayList<double[]>();
            boolean[] functionElement = null;
            BitSet varFElement = null;
            double[] cijElement = null;
            perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            ArrayList<Integer> tmpVarFElement = null;
            int[] orderVar = null;
            boolean needReorder = false;
            boolean comment = false;
            int sumNf = 0;
            int count = 0;
            nv = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block30: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    nf[column - 1] = Integer.parseInt(str);
                                    sumNf += nf[column - 1];
                                    break;
                                }
                                case 3: {
                                    int tmp = Integer.parseInt(str);
                                    if (tmp == 0) {
                                        tmp = 1;
                                    }
                                    nv.add(tmp);
                                    break;
                                }
                                case 4: {
                                    if (column == 1) {
                                        functionElement = new boolean[(int)Math.pow(2.0, ((Integer)nv.get(F.size())).intValue())];
                                    }
                                    int fElementIndex = reverse != false ? IntegerReverse.reverse(column - 1, (Integer)nv.get(F.size())) : column - 1;
                                    if (Integer.parseInt(str) == 1) {
                                        functionElement[fElementIndex] = true;
                                        break;
                                    }
                                    functionElement[fElementIndex] = false;
                                    break;
                                }
                                case 5: {
                                    if (column == 1) {
                                        varFElement = new BitSet(n);
                                        tmpVarFElement = new ArrayList<Integer>();
                                        tmpVarFElement.add(Integer.parseInt(str));
                                    } else {
                                        tmpVarFElement.add(Integer.parseInt(str));
                                        if ((Integer)tmpVarFElement.get(tmpVarFElement.size() - 1) < (Integer)tmpVarFElement.get(tmpVarFElement.size() - 2)) {
                                            needReorder = true;
                                        }
                                    }
                                    varFElement.set(Integer.parseInt(str));
                                    break;
                                }
                                case 6: {
                                    if (column == 1) {
                                        cijElement = new double[nf[count]];
                                    }
                                    cijElement[column - 1] = Double.parseDouble(str);
                                    break;
                                }
                                case 7: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                case 8: {
                                    npNode.add(Integer.parseInt(str));
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block30;
                                }
                                case 2: {
                                    line = 3;
                                    continue block30;
                                }
                                case 3: {
                                    line = 4;
                                    continue block30;
                                }
                                case 4: {
                                    F.add(functionElement);
                                    if (count == sumNf - 1) {
                                        line = 5;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 5: {
                                    if (needReorder) {
                                        int fromIndex = 0;
                                        orderVar = new int[tmpVarFElement.size()];
                                        int orderIndex = 0;
                                        while ((fromIndex = varFElement.nextSetBit(fromIndex)) != -1) {
                                            int index = 0;
                                            while (index < tmpVarFElement.size()) {
                                                if ((Integer)tmpVarFElement.get(index) == fromIndex) {
                                                    orderVar[orderIndex] = index;
                                                    ++orderIndex;
                                                    break;
                                                }
                                                ++index;
                                            }
                                            ++fromIndex;
                                        }
                                        functionElement = (boolean[])F.get(varF.size());
                                        boolean[] tmpFunctionElement = (boolean[])functionElement.clone();
                                        BitVector oldOrder = new BitVector(orderVar.length);
                                        BitVector newOrder = new BitVector(orderVar.length);
                                        int i = 0;
                                        while (i < functionElement.length) {
                                            oldOrder.putLongFromTo(i, 0, orderVar.length - 1);
                                            int j = 0;
                                            while (j < orderVar.length) {
                                                newOrder.put(j, oldOrder.get(orderVar[j]));
                                                ++j;
                                            }
                                            functionElement[(int)newOrder.getLongFromTo((int)0, (int)(orderVar.length - 1))] = tmpFunctionElement[i];
                                            ++i;
                                        }
                                        needReorder = false;
                                    }
                                    varF.add(varFElement);
                                    if (count == sumNf - 1) {
                                        line = 6;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 6: {
                                    cij.add(cijElement);
                                    if (count == n - 1) {
                                        line = 7;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 7: {
                                    line = 8;
                                    continue block30;
                                }
                                case 8: {
                                    line = 9;
                                    continue block30;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block55;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        BitSetPBN pbn = new BitSetPBN(n);
        pbn.setNf(nf);
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(cij);
        pbn.setPerturbation(perturbation);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public BitSetPBN loadPBNBackUp(String fileName, Boolean reverse) throws Exception {
        ArrayList<Integer> nv;
        ArrayList<Integer> npNode;
        double perturbation;
        ArrayList<double[]> cij;
        ArrayList<BitSet> varF;
        ArrayList<boolean[]> F;
        int[] nf;
        int n;
        long cpu;
        ThreadMXBean thread;
        block47: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            System.out.println("Start loading model...");
            File file = new File(fileName);
            BufferedReader reader = null;
            n = 0;
            nf = null;
            F = new ArrayList<boolean[]>();
            varF = new ArrayList<BitSet>();
            cij = new ArrayList<double[]>();
            boolean[] functionElement = null;
            BitSet varFElement = null;
            double[] cijElement = null;
            perturbation = 0.0;
            npNode = new ArrayList<Integer>();
            boolean comment = false;
            int sumNf = 0;
            int count = 0;
            nv = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String tempString = null;
                    int line = 1;
                    block30: while ((tempString = reader.readLine()) != null) {
                        int column = 0;
                        StringTokenizer st = new StringTokenizer(tempString);
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            if (++column == 1 && str.startsWith("//")) {
                                comment = true;
                                break;
                            }
                            switch (line) {
                                case 1: {
                                    n = Integer.parseInt(str);
                                    nf = new int[n];
                                    break;
                                }
                                case 2: {
                                    nf[column - 1] = Integer.parseInt(str);
                                    sumNf += nf[column - 1];
                                    break;
                                }
                                case 3: {
                                    int tmp = Integer.parseInt(str);
                                    if (tmp == 0) {
                                        tmp = 1;
                                    }
                                    nv.add(tmp);
                                    break;
                                }
                                case 4: {
                                    if (column == 1) {
                                        functionElement = new boolean[(int)Math.pow(2.0, ((Integer)nv.get(F.size())).intValue())];
                                    }
                                    int fElementIndex = reverse != false ? IntegerReverse.reverse(column - 1, (Integer)nv.get(F.size())) : column - 1;
                                    if (Integer.parseInt(str) == 1) {
                                        functionElement[fElementIndex] = true;
                                        break;
                                    }
                                    functionElement[fElementIndex] = false;
                                    break;
                                }
                                case 5: {
                                    if (column == 1) {
                                        varFElement = new BitSet(n);
                                    }
                                    varFElement.set(Integer.parseInt(str));
                                    break;
                                }
                                case 6: {
                                    if (column == 1) {
                                        cijElement = new double[nf[count]];
                                    }
                                    cijElement[column - 1] = Double.parseDouble(str);
                                    break;
                                }
                                case 7: {
                                    perturbation = Double.parseDouble(str);
                                    break;
                                }
                                case 8: {
                                    npNode.add(Integer.parseInt(str));
                                    break;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        if (!comment) {
                            switch (line) {
                                case 1: {
                                    line = 2;
                                    continue block30;
                                }
                                case 2: {
                                    line = 3;
                                    continue block30;
                                }
                                case 3: {
                                    line = 4;
                                    continue block30;
                                }
                                case 4: {
                                    F.add(functionElement);
                                    if (count == sumNf - 1) {
                                        line = 5;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 5: {
                                    varF.add(varFElement);
                                    if (count == sumNf - 1) {
                                        line = 6;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 6: {
                                    cij.add(cijElement);
                                    if (count == n - 1) {
                                        line = 7;
                                        count = 0;
                                        continue block30;
                                    }
                                    ++count;
                                    continue block30;
                                }
                                case 7: {
                                    line = 8;
                                    continue block30;
                                }
                                case 8: {
                                    line = 9;
                                    continue block30;
                                }
                                default: {
                                    throw new Exception("Invalid file!");
                                }
                            }
                        }
                        comment = false;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block47;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        BitSetPBN pbn = new BitSetPBN(n);
        pbn.setNf(nf);
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(cij);
        pbn.setPerturbation(perturbation);
        if (npNode.size() != 0) {
            pbn.setNpNode(npNode);
        }
        this.pbn = pbn;
        this.n = n;
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        System.out.println("Finish loading model. Time cost: " + cpucost + "s.");
        this.determinePBNtype();
        return pbn;
    }

    public void exportPBNtoMatlab(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int j;
        int n = pbn.getN();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(fileName)), true);
        String outputLine = "global F;global varF;global nf;global nv;global cij;global p;global n;";
        pw.println(outputLine);
        outputLine = "n=" + n + ";";
        pw.println(outputLine);
        outputLine = "nf=ones(1,n);";
        pw.println(outputLine);
        int[] nf = pbn.getNf();
        int i = 0;
        while (i < nf.length) {
            outputLine = "nf(" + (i + 1) + ")=" + nf[i] + ";";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "nv=ones(1,sum(nf));";
        pw.println(outputLine);
        List<Integer> nv = pbn.getNv();
        i = 0;
        while (i < nv.size()) {
            outputLine = "nv(" + (i + 1) + ")=" + nv.get(i) + ";";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "F = -ones(2^max(nv),sum(nf));";
        pw.println(outputLine);
        outputLine = "varF = -ones(max(nv),sum(nf));";
        pw.println(outputLine);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int i2 = 0;
        while (i2 < F.size()) {
            boolean[] elementF = F.get(i2);
            BitSet elementVarF = varF.get(i2);
            int lengthF = elementVarF.cardinality();
            j = 0;
            while (j < elementF.length) {
                outputLine = "F(" + (j + 1) + "," + (i2 + 1) + ")=" + elementF[IntegerReverse.reverse(j, lengthF)] + ";";
                pw.println(outputLine);
                ++j;
            }
            outputLine = elementVarF.toString();
            outputLine = outputLine.substring(1, outputLine.length() - 1);
            String[] split = outputLine.split("[,]");
            outputLine = "[";
            int k = 0;
            while (k < split.length) {
                outputLine = String.valueOf(outputLine) + split[k] + "+1,";
                ++k;
            }
            outputLine = String.valueOf(outputLine.substring(0, outputLine.length() - 1)) + "]";
            outputLine = "varF(1:nv(" + (i2 + 1) + ")," + (i2 + 1) + ")=" + outputLine + ";";
            pw.println(outputLine);
            ++i2;
        }
        outputLine = "cij = -ones(max(nf),n);";
        pw.println(outputLine);
        List<double[]> cij = pbn.getCij();
        i2 = 0;
        while (i2 < cij.size()) {
            double[] elementCij = cij.get(i2);
            j = 0;
            while (j < elementCij.length) {
                outputLine = "cij(" + (j + 1) + "," + (i2 + 1) + ")=" + elementCij[j] + ";";
                pw.println(outputLine);
                ++j;
            }
            ++i2;
        }
        outputLine = "p=" + pbn.getPerturbation() + ";";
        pw.println(outputLine);
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in Matlab format.");
    }

    public void exportPBNtoMCMAS(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        int i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + i + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean inputNode = false;
        int i2 = 0;
        while (i2 < F.size()) {
            boolean[] elementF = F.get(i2);
            BitSet elementVarF = varF.get(i2);
            int fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int countTrueElement = 0;
            inputNode = false;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++countTrueElement;
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            if (countTrueElement == elementF.length || countTrueElement == 0) {
                inputNode = true;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (!inputNode) {
                String outputLine2;
                if (activators.size() == 0) {
                    outputLine = "\t\tn_" + i2 + "=false if ";
                    outputLine2 = "\t\tn_" + i2 + "=true if ";
                    outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                    j = 1;
                    while (j < inhibitors.size()) {
                        outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                        outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                        ++j;
                    }
                    outputLine = String.valueOf(outputLine) + ";";
                    outputLine2 = String.valueOf(outputLine2) + ";";
                    pw.println(outputLine);
                    pw.println(outputLine2);
                } else if (inhibitors.size() == 0) {
                    outputLine = "\t\tn_" + i2 + "=true if ";
                    outputLine2 = "\t\tn_" + i2 + "=false if ";
                    outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                    j = 1;
                    while (j < activators.size()) {
                        outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                        outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                        ++j;
                    }
                    outputLine = String.valueOf(outputLine) + ";";
                    outputLine2 = String.valueOf(outputLine2) + ";";
                    pw.println(outputLine);
                    pw.println(outputLine2);
                } else {
                    outputLine = "\t\tn_" + i2 + "=true if ";
                    outputLine2 = "\t\tn_" + i2 + "=false if ";
                    outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                    j = 1;
                    while (j < activators.size()) {
                        outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                        outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                        ++j;
                    }
                    outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                    j = 1;
                    while (j < inhibitors.size()) {
                        outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                        outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                        ++j;
                    }
                    outputLine = String.valueOf(outputLine) + ");";
                    outputLine2 = String.valueOf(outputLine2) + ";";
                    pw.println(outputLine);
                    pw.println(outputLine2);
                }
            }
            if (!inputNode && i2 < F.size() - 1) {
                pw.println();
            }
            ++i2;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoDot(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        String outputLine = "digraph {";
        pw.println(outputLine);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i = 0;
        while (i < F.size()) {
            boolean[] elementF = F.get(i);
            BitSet elementVarF = varF.get(i);
            int fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int countTrueElement = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++countTrueElement;
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            if (countTrueElement != elementF.length && countTrueElement != 0) {
                j = 0;
                while (j < numParents) {
                    if (validator.get(j)) {
                        activators.add((Integer)parentIndices.get(j));
                    } else {
                        inhibitors.add((Integer)parentIndices.get(j));
                    }
                    ++j;
                }
            }
            j = 0;
            while (j < inhibitors.size()) {
                outputLine = inhibitors.get(j) + "->" + i + "[arrowhead=dot,color=red];";
                pw.println(outputLine);
                ++j;
            }
            j = 0;
            while (j < activators.size()) {
                outputLine = activators.get(j) + "->" + i + ";";
                pw.println(outputLine);
                ++j;
            }
            ++i;
        }
        pw.println("}");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASForceHeuristic(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int maxLo;
        int minLo;
        List inhibitors;
        List activators;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        int[] countParent = new int[n];
        List[] hyperedge = new List[2 * F.size()];
        int[] location = new int[n];
        double[] cog = new double[2 * F.size()];
        double[] tenLocation = new double[n];
        int i = 0;
        while (i < n) {
            location[i] = i;
            ++i;
        }
        i = 0;
        while (i < F.size()) {
            activators = new ArrayList<Integer>();
            inhibitors = new ArrayList<Integer>();
            boolean[] elementF = F.get(i);
            BitSet elementVarF = varF.get(i);
            int fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            hyperedge[2 * i] = activators;
            hyperedge[2 * i + 1] = inhibitors;
            ++i;
        }
        int previousSpan = 0;
        int span = 0;
        int i2 = 0;
        while (i2 < hyperedge.length) {
            minLo = n + 1;
            maxLo = 0;
            int j = 0;
            while (j < hyperedge[i2].size()) {
                if (minLo > (Integer)hyperedge[i2].get(j)) {
                    minLo = (Integer)hyperedge[i2].get(j);
                }
                if (maxLo < (Integer)hyperedge[i2].get(j)) {
                    maxLo = (Integer)hyperedge[i2].get(j);
                }
                ++j;
            }
            if (hyperedge[i2].size() != 0) {
                span += maxLo - minLo;
            }
            ++i2;
        }
        previousSpan = span + 1;
        while (previousSpan > span) {
            int i3;
            i2 = 0;
            while (i2 < hyperedge.length) {
                cog[i2] = 0.0;
                if (hyperedge[i2].size() != 0) {
                    int j = 0;
                    while (j < hyperedge[i2].size()) {
                        int n3 = i2;
                        cog[n3] = cog[n3] + (double)location[(Integer)hyperedge[i2].get(j)];
                        ++j;
                    }
                    cog[i2] = cog[i2] / (double)hyperedge[i2].size() + 1.0;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < tenLocation.length) {
                tenLocation[i2] = 0.0;
                ++i2;
            }
            i2 = 0;
            while (i2 < hyperedge.length) {
                int j = 0;
                while (j < hyperedge[i2].size()) {
                    int n4 = (Integer)hyperedge[i2].get(j);
                    tenLocation[n4] = tenLocation[n4] + cog[i2];
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < tenLocation.length) {
                if (countParent[i2] != 0) {
                    tenLocation[i2] = tenLocation[i2] / (double)countParent[i2];
                }
                ++i2;
            }
            int maxIndex = 0;
            double max = -1.0;
            int count = 0;
            while (count < location.length) {
                i3 = 0;
                while (i3 < tenLocation.length) {
                    if (tenLocation[i3] > max) {
                        max = tenLocation[i3];
                        maxIndex = i3;
                    }
                    ++i3;
                }
                location[maxIndex] = count++;
                tenLocation[maxIndex] = -1.0;
                max = -1.0;
            }
            previousSpan = span;
            span = 0;
            i3 = 0;
            while (i3 < hyperedge.length) {
                minLo = n + 1;
                maxLo = 0;
                int j = 0;
                while (j < hyperedge[i3].size()) {
                    if (minLo > (Integer)hyperedge[i3].get(j)) {
                        minLo = (Integer)hyperedge[i3].get(j);
                    }
                    if (maxLo < (Integer)hyperedge[i3].get(j)) {
                        maxLo = (Integer)hyperedge[i3].get(j);
                    }
                    ++j;
                }
                if (hyperedge[i3].size() != 0) {
                    span += maxLo - minLo;
                }
                ++i3;
            }
        }
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < location.length) {
                if (location[j] == i2) {
                    outputLine = "\t\tn_" + j + ": boolean;";
                    pw.println(outputLine);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        i2 = 0;
        while (i2 < hyperedge.length) {
            int j;
            String outputLine2;
            activators = hyperedge[i2];
            inhibitors = hyperedge[i2 + 1];
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + i2 / 2 + "=false if ";
                outputLine2 = "\t\tn_" + i2 / 2 + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + i2 / 2 + "=true if ";
                outputLine2 = "\t\tn_" + i2 / 2 + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + i2 / 2 + "=true if ";
                outputLine2 = "\t\tn_" + i2 / 2 + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            pw.println();
            i2 += 2;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASMyOrder2(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int fromIndex;
        BitSet elementVarF;
        List<Integer> inhibitors;
        List<Integer> activators;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int[] countParent = new int[n];
        List[] hyperedge = new List[2 * F.size()];
        int numParents = 0;
        int[] location = new int[n];
        double[] cog = new double[varF.size()];
        double[] tenLocation = new double[n];
        int span = Integer.MAX_VALUE;
        int count = 0;
        int previousSpan = span + 1;
        int i = 0;
        while (i < n) {
            location[i] = i;
            ++i;
        }
        previousSpan = span;
        span = 0;
        i = 0;
        while (i < varF.size()) {
            activators = new ArrayList();
            inhibitors = new ArrayList();
            boolean[] elementF = F.get(i);
            elementVarF = varF.get(i);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            elementVarF = varF.get(i);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            cog[i] = location[i];
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                int n3 = fromIndex;
                countParent[n3] = countParent[n3] + 1;
                int n4 = i;
                cog[n4] = cog[n4] + (double)location[fromIndex];
                span += Math.abs(location[i] - location[fromIndex]);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            hyperedge[2 * i] = activators;
            hyperedge[2 * i + 1] = inhibitors;
            ++i;
        }
        while (previousSpan > span) {
            int i2;
            i = 0;
            while (i < n) {
                tenLocation[i] = cog[i];
                elementVarF = varF.get(i);
                fromIndex = 0;
                fromIndex = elementVarF.nextSetBit(fromIndex);
                count = 1;
                while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                    int n5 = i;
                    tenLocation[n5] = tenLocation[n5] + cog[fromIndex];
                    ++count;
                    ++fromIndex;
                    fromIndex = elementVarF.nextSetBit(fromIndex);
                }
                int n6 = i++;
                tenLocation[n6] = tenLocation[n6] / (double)count;
            }
            int maxIndex = 0;
            double max = -1.0;
            count = 0;
            while (count < location.length) {
                i2 = 0;
                while (i2 < tenLocation.length) {
                    if (tenLocation[i2] > max) {
                        max = tenLocation[i2];
                        maxIndex = i2;
                    }
                    ++i2;
                }
                location[maxIndex] = count++;
                tenLocation[maxIndex] = -1.0;
                max = -1.0;
            }
            previousSpan = span;
            span = 0;
            i2 = 0;
            while (i2 < varF.size()) {
                elementVarF = varF.get(i2);
                fromIndex = 0;
                fromIndex = elementVarF.nextSetBit(fromIndex);
                parentIndices.clear();
                cog[i2] = location[i2];
                while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                    parentIndices.add(fromIndex);
                    int n7 = fromIndex;
                    countParent[n7] = countParent[n7] + 1;
                    int n8 = i2;
                    cog[n8] = cog[n8] + (double)location[fromIndex];
                    span += Math.abs(location[i2] - location[fromIndex]);
                    ++fromIndex;
                    fromIndex = elementVarF.nextSetBit(fromIndex);
                }
                ++i2;
            }
        }
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            int j = 0;
            while (j < location.length) {
                if (location[j] == i) {
                    outputLine = "\t\tn_" + j + ": boolean;";
                    pw.println(outputLine);
                    break;
                }
                ++j;
            }
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        i = 0;
        while (i < hyperedge.length) {
            int j;
            String outputLine2;
            activators = hyperedge[i];
            inhibitors = hyperedge[i + 1];
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + i / 2 + "=false if ";
                outputLine2 = "\t\tn_" + i / 2 + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + i / 2 + "=true if ";
                outputLine2 = "\t\tn_" + i / 2 + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + i / 2 + "=true if ";
                outputLine2 = "\t\tn_" + i / 2 + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            pw.println();
            i += 2;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASWithOrder(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int i;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int[] countParent = new int[n];
        int i2 = 0;
        while (i2 < F.size()) {
            elementVarF = varF.get(i2);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i2;
        }
        int min = Integer.MAX_VALUE;
        int minIndex = 0;
        int i3 = 0;
        while (i3 < F.size()) {
            if (min > countParent[i3]) {
                min = countParent[i3];
                minIndex = i3;
            }
            ++i3;
        }
        countParent[minIndex] = Integer.MAX_VALUE;
        orderedNode[0] = minIndex;
        int count = 1;
        int indexVarF = 0;
        boolean found = false;
        while (indexVarF < orderedNode.length) {
            if (indexVarF >= count) {
                min = Integer.MAX_VALUE;
                i = 0;
                while (i < F.size()) {
                    if (min > countParent[i]) {
                        min = countParent[i];
                        minIndex = i;
                    }
                    ++i;
                }
                countParent[minIndex] = Integer.MAX_VALUE;
                orderedNode[count] = minIndex;
                ++count;
            }
            elementVarF = varF.get(orderedNode[indexVarF]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                found = false;
                i = 0;
                while (i < count) {
                    if (orderedNode[i] == fromIndex) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    orderedNode[count] = fromIndex;
                    countParent[fromIndex] = Integer.MAX_VALUE;
                    ++count;
                }
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++indexVarF;
        }
        i = 0;
        while (i < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i]) + "\t");
            ++i;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + orderedNode[i] + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i4 = 0;
        while (i4 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i4]);
            elementVarF = varF.get(orderedNode[i4]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++numActivation;
                }
                ++j;
            }
            j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i4 < F.size() - 1) {
                pw.println();
            }
            ++i4;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASWithOrder3(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int i;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int[] countParent = new int[n];
        int i2 = 0;
        while (i2 < F.size()) {
            elementVarF = varF.get(i2);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i2;
        }
        int min = Integer.MAX_VALUE;
        int minIndex = 0;
        int i3 = 0;
        while (i3 < F.size()) {
            if (min > countParent[i3]) {
                min = countParent[i3];
                minIndex = i3;
            }
            ++i3;
        }
        countParent[minIndex] = Integer.MAX_VALUE;
        orderedNode[0] = minIndex;
        int count = 1;
        int indexVarF = 0;
        boolean found = false;
        ArrayList<Integer> tempIndex = new ArrayList<Integer>();
        ArrayList tempIndex2 = new ArrayList();
        while (indexVarF < orderedNode.length) {
            if (indexVarF >= count) {
                min = Integer.MAX_VALUE;
                i = 0;
                while (i < F.size()) {
                    if (min > countParent[i]) {
                        min = countParent[i];
                        minIndex = i;
                    }
                    ++i;
                }
                countParent[minIndex] = Integer.MAX_VALUE;
                orderedNode[count] = minIndex;
                ++count;
            }
            elementVarF = varF.get(orderedNode[indexVarF]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                found = false;
                i = 0;
                while (i < count) {
                    if (orderedNode[i] == fromIndex) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    tempIndex.add(fromIndex);
                }
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            while (!tempIndex.isEmpty()) {
                int mininum = Integer.MAX_VALUE;
                int minimumIndex = 0;
                int i4 = 0;
                while (i4 < tempIndex.size()) {
                    if (mininum > countParent[(Integer)tempIndex.get(i4)]) {
                        minimumIndex = i4;
                    }
                    ++i4;
                }
                orderedNode[count] = (Integer)tempIndex.get(minimumIndex);
                countParent[((Integer)tempIndex.get((int)minimumIndex)).intValue()] = Integer.MAX_VALUE;
                ++count;
                tempIndex.remove(minimumIndex);
            }
            ++indexVarF;
        }
        i = 0;
        while (i < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i]) + "\t");
            ++i;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + orderedNode[i] + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i5 = 0;
        while (i5 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i5]);
            elementVarF = varF.get(orderedNode[i5]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++numActivation;
                }
                ++j;
            }
            j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i5 < F.size() - 1) {
                pw.println();
            }
            ++i5;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASWithOrder2(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int i;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int[] countParent = new int[n];
        int i2 = 0;
        while (i2 < F.size()) {
            elementVarF = varF.get(i2);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i2;
        }
        int max = -1;
        int maxIndex = 0;
        int i3 = 0;
        while (i3 < F.size()) {
            if (max < countParent[i3]) {
                max = countParent[i3];
                maxIndex = i3;
            }
            ++i3;
        }
        countParent[maxIndex] = -1;
        orderedNode[0] = maxIndex;
        int count = 1;
        int indexVarF = 0;
        boolean found = false;
        while (indexVarF < orderedNode.length) {
            if (indexVarF >= count) {
                max = -1;
                i = 0;
                while (i < F.size()) {
                    if (max < countParent[i]) {
                        max = countParent[i];
                        maxIndex = i;
                    }
                    ++i;
                }
                countParent[maxIndex] = -1;
                orderedNode[count] = maxIndex;
                ++count;
            }
            elementVarF = varF.get(orderedNode[indexVarF]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                found = false;
                i = 0;
                while (i < count) {
                    if (orderedNode[i] == fromIndex) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    orderedNode[count] = fromIndex;
                    countParent[fromIndex] = -1;
                    ++count;
                }
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++indexVarF;
        }
        i = 0;
        while (i < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i]) + "\t");
            ++i;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + orderedNode[i] + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i4 = 0;
        while (i4 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i4]);
            elementVarF = varF.get(orderedNode[i4]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++numActivation;
                }
                ++j;
            }
            j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i4 < F.size() - 1) {
                pw.println();
            }
            ++i4;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASHeuristic1(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int i;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int[] countParent = new int[n];
        int i2 = 0;
        while (i2 < F.size()) {
            elementVarF = varF.get(i2);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i2;
        }
        int max = -1;
        int maxIndex = 0;
        int i3 = 0;
        while (i3 < F.size()) {
            if (max < countParent[i3]) {
                max = countParent[i3];
                maxIndex = i3;
            }
            ++i3;
        }
        countParent[maxIndex] = -1;
        orderedNode[0] = maxIndex;
        int count = 1;
        int indexVarF = 0;
        boolean found = false;
        while (indexVarF < orderedNode.length) {
            if (indexVarF >= count) {
                max = -1;
                i = 0;
                while (i < F.size()) {
                    if (max < countParent[i]) {
                        max = countParent[i];
                        maxIndex = i;
                    }
                    ++i;
                }
                countParent[maxIndex] = -1;
                orderedNode[count] = maxIndex;
                ++count;
            }
            int j = 0;
            while (j < varF.size()) {
                elementVarF = varF.get(j);
                if (elementVarF.get(orderedNode[indexVarF])) {
                    found = false;
                    int i4 = 0;
                    while (i4 < count) {
                        if (orderedNode[i4] == j) {
                            found = true;
                            break;
                        }
                        ++i4;
                    }
                    if (!found) {
                        orderedNode[count] = j;
                        countParent[j] = -1;
                        ++count;
                    }
                }
                ++j;
            }
            ++indexVarF;
        }
        i = 0;
        while (i < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i]) + "\t");
            ++i;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + orderedNode[i] + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i5 = 0;
        while (i5 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i5]);
            elementVarF = varF.get(orderedNode[i5]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++numActivation;
                }
                ++j;
            }
            j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i5 < F.size() - 1) {
                pw.println();
            }
            ++i5;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASHeuristic2(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int i;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int[] countParent = new int[n];
        int i2 = 0;
        while (i2 < F.size()) {
            elementVarF = varF.get(i2);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i2;
        }
        int max = -1;
        int maxIndex = 0;
        int i3 = 0;
        while (i3 < F.size()) {
            if (max < countParent[i3]) {
                max = countParent[i3];
                maxIndex = i3;
            }
            ++i3;
        }
        countParent[maxIndex] = -1;
        orderedNode[0] = maxIndex;
        int count = 1;
        boolean indexVarF = false;
        boolean found = false;
        while (count < orderedNode.length) {
            max = -1;
            i = 0;
            while (i < F.size()) {
                if (max < countParent[i]) {
                    max = countParent[i];
                    maxIndex = i;
                }
                ++i;
            }
            countParent[maxIndex] = -1;
            orderedNode[count] = maxIndex;
            ++count;
        }
        i = 0;
        while (i < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i]) + "\t");
            ++i;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i = 0;
        while (i < n) {
            outputLine = "\t\tn_" + orderedNode[i] + ": boolean;";
            pw.println(outputLine);
            ++i;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i4 = 0;
        while (i4 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i4]);
            elementVarF = varF.get(orderedNode[i4]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    ++numActivation;
                }
                ++j;
            }
            j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    parent.clear();
                    parent.putLongFromTo(j, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j;
            }
            activators.clear();
            inhibitors.clear();
            j = 0;
            while (j < numParents) {
                if (validator.get(j)) {
                    activators.add((Integer)parentIndices.get(j));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j));
                }
                ++j;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i4] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i4] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j = 1;
                while (j < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j) + "=false";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j = 1;
                while (j < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j) + "=true";
                    ++j;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i4 < F.size() - 1) {
                pw.println();
            }
            ++i4;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASHeuristic3(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int j;
        int fromIndex;
        BitSet elementVarF;
        int n = pbn.getN();
        boolean hasNewUpdate = true;
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        int[][] A = new int[pbn.getN()][pbn.getN()];
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int i = 0;
        while (i < A.length) {
            int j2 = 0;
            while (j2 < A.length) {
                A[i][j2] = 0x3FFFFFFF;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < F.size()) {
            elementVarF = varF.get(i);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                A[fromIndex][i] = 1;
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i;
        }
        i = 0;
        while (i < A.length) {
            A[i][i] = 0;
            ++i;
        }
        while (hasNewUpdate) {
            hasNewUpdate = false;
            int i2 = 0;
            while (i2 < A.length) {
                int j3 = 0;
                while (j3 < A.length) {
                    if (i2 != j3 && A[i2][j3] != 1) {
                        int k = 0;
                        while (k < A.length) {
                            int sum = A[i2][k] + A[k][j3];
                            if (A[i2][j3] > sum) {
                                A[i2][j3] = sum;
                                hasNewUpdate = true;
                            }
                            ++k;
                        }
                    }
                    ++j3;
                }
                ++i2;
            }
        }
        int max = -1;
        int max_i = 0;
        int max_j = 0;
        int i3 = 0;
        while (i3 < A.length) {
            int j4 = 0;
            while (j4 < A.length) {
                if (A[i3][j4] != 0x3FFFFFFF && max < A[i3][j4]) {
                    max = A[i3][j4];
                    max_i = i3;
                    max_j = j4;
                }
                ++j4;
            }
            ++i3;
        }
        ArrayList<int[]> paths = new ArrayList<int[]>();
        int[] path = new int[A[max_i][max_j] + 1];
        int i4 = 0;
        while (i4 < path.length) {
            path[i4] = -1;
            ++i4;
        }
        path[0] = max_i;
        paths.add(path);
        i4 = 1;
        while (i4 < A[max_i][max_j] + 1) {
            j = 0;
            while (j < A.length) {
                if (A[max_i][j] == i4) {
                    int k = 0;
                    while (k < paths.size()) {
                        if (((int[])paths.get(k))[i4] == -1) {
                            if (((int[])paths.get(k))[i4 - 1] != -1 && varF.get(j).get(((int[])paths.get(k))[i4 - 1])) {
                                ((int[])paths.get((int)k))[i4] = j;
                            }
                        } else if (((int[])paths.get(k))[i4] != j) {
                            path = new int[A[max_i][max_j] + 1];
                            int m = 0;
                            while (m < path.length) {
                                path[m] = ((int[])paths.get(k))[m];
                                ++m;
                            }
                            path[i4] = j;
                            paths.add(path);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < paths.size()) {
            path = (int[])paths.get(i4);
            j = 0;
            while (j < path.length) {
                System.out.print(String.valueOf(path[j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i4;
        }
        i4 = 0;
        while (i4 < paths.size()) {
            path = (int[])paths.get(i4);
            j = 0;
            while (j < path.length) {
                if (path[j] == -1) {
                    paths.remove(i4);
                    --i4;
                    break;
                }
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < paths.size()) {
            path = (int[])paths.get(i4);
            j = 0;
            while (j < path.length) {
                System.out.print(String.valueOf(path[j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i4;
        }
        i4 = 0;
        while (i4 < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i4]) + "\t");
            ++i4;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i4 = 0;
        while (i4 < n) {
            outputLine = "\t\tn_" + orderedNode[i4] + ": boolean;";
            pw.println(outputLine);
            ++i4;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i5 = 0;
        while (i5 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i5]);
            elementVarF = varF.get(orderedNode[i5]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j5 = 0;
            while (j5 < elementF.length) {
                if (elementF[j5]) {
                    ++numActivation;
                }
                ++j5;
            }
            j5 = 0;
            while (j5 < elementF.length) {
                if (elementF[j5]) {
                    parent.clear();
                    parent.putLongFromTo(j5, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j5;
            }
            activators.clear();
            inhibitors.clear();
            j5 = 0;
            while (j5 < numParents) {
                if (validator.get(j5)) {
                    activators.add((Integer)parentIndices.get(j5));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j5));
                }
                ++j5;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j5 = 1;
                while (j5 < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j5 = 1;
                while (j5 < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i5] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i5] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j5 = 1;
                while (j5 < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j5 = 1;
                while (j5 < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j5) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j5) + "=true";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i5 < F.size() - 1) {
                pw.println();
            }
            ++i5;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoMCMASHeuristic4(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int fromIndex;
        BitSet elementVarF;
        int j;
        int n = pbn.getN();
        boolean hasNewUpdate = true;
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        int[][] A = new int[pbn.getN()][pbn.getN()];
        Path[][] P = new Path[pbn.getN()][pbn.getN()];
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        int[] orderedNode = new int[n];
        int i = 0;
        while (i < A.length) {
            j = 0;
            while (j < A.length) {
                A[i][j] = 0x3FFFFFFF;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < A.length) {
            A[i][i] = 0;
            ++i;
        }
        i = 0;
        while (i < A.length) {
            j = 0;
            while (j < A.length) {
                if (i != j) {
                    Path pa = new Path(j, i);
                    ArrayList<Path> paths = new ArrayList<Path>();
                    ArrayList<Path> newAddedPaths = new ArrayList<Path>();
                    paths.add(pa);
                    boolean done = false;
                    while (!done) {
                        done = true;
                        for (Path p : paths) {
                            if (p.finish) continue;
                            int currentnode = p.path.get(p.path.size() - 1);
                            elementVarF = varF.get(currentnode);
                            fromIndex = 0;
                            fromIndex = elementVarF.nextSetBit(fromIndex);
                            boolean first = true;
                            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                                int result;
                                if (first) {
                                    result = p.add(fromIndex);
                                    if (result == 1) {
                                        first = false;
                                    }
                                } else {
                                    Path newPath = p.copy();
                                    newPath.remove(newPath.path.size() - 1);
                                    result = newPath.add(fromIndex);
                                    if (result == 1) {
                                        newAddedPaths.add(newPath);
                                    }
                                }
                                if (result == 1) {
                                    done = false;
                                }
                                ++fromIndex;
                                fromIndex = elementVarF.nextSetBit(fromIndex);
                            }
                        }
                        for (Path p : newAddedPaths) {
                            paths.add(p);
                        }
                        newAddedPaths.clear();
                    }
                    int max = -1;
                    int index = 0;
                    int k = 0;
                    while (k < paths.size()) {
                        Path p = (Path)paths.get(k);
                        if (p.finish && max < p.path.size()) {
                            max = p.path.size();
                            index = k;
                        }
                        ++k;
                    }
                    A[i][j] = max;
                    P[i][j] = (Path)paths.get(index);
                }
                ++j;
            }
            ++i;
        }
        int max = 0;
        int index_i = 0;
        int index_j = 0;
        int i2 = 0;
        while (i2 < A.length) {
            int j2 = 0;
            while (j2 < A.length) {
                if (max < A[i2][j2]) {
                    max = A[i2][j2];
                    index_i = i2;
                    index_j = j2;
                }
                ++j2;
            }
            ++i2;
        }
        System.out.println("The lengty of the longest path is " + max + ", the path is : ");
        boolean[] sorted = new boolean[pbn.getN()];
        int k = P[index_i][index_j].path.size() - 1;
        while (k >= 0) {
            System.out.print(P[index_i][index_j].path.get(k) + "\t");
            sorted[P[index_i][index_j].path.get((int)k).intValue()] = true;
            --k;
        }
        System.out.println();
        int pathIndex = P[index_i][index_j].path.size() - 1;
        orderedNode[0] = P[index_i][index_j].path.get(pathIndex);
        --pathIndex;
        int indexVarF = 0;
        boolean found = true;
        while (indexVarF < orderedNode.length && pathIndex >= 0) {
            int j3 = 0;
            while (j3 < varF.size()) {
                if (!sorted[j3] && (elementVarF = varF.get(j3)).get(P[index_i][index_j].path.get(pathIndex + 1))) {
                    orderedNode[++indexVarF] = j3;
                    sorted[j3] = true;
                }
                ++j3;
            }
            if (indexVarF >= orderedNode.length - 1) continue;
            elementVarF = varF.get(P[index_i][index_j].path.get(pathIndex));
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                if (!sorted[fromIndex]) {
                    orderedNode[++indexVarF] = fromIndex;
                    sorted[fromIndex] = true;
                }
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            orderedNode[++indexVarF] = P[index_i][index_j].path.get(pathIndex);
            --pathIndex;
        }
        int[] countParent = new int[n];
        int i3 = 0;
        while (i3 < F.size()) {
            elementVarF = varF.get(i3);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                int n2 = fromIndex++;
                countParent[n2] = countParent[n2] + 1;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            ++i3;
        }
        int min = Integer.MAX_VALUE;
        int minIndex = 0;
        while (indexVarF < orderedNode.length - 1) {
            min = Integer.MAX_VALUE;
            int i4 = 0;
            while (i4 < sorted.length) {
                if (!sorted[i4] && min > countParent[i4]) {
                    min = countParent[i4];
                    minIndex = i4;
                }
                ++i4;
            }
            orderedNode[++indexVarF] = minIndex;
            sorted[minIndex] = true;
            int j4 = 0;
            while (j4 < varF.size()) {
                if (!sorted[j4] && (elementVarF = varF.get(j4)).get(minIndex)) {
                    orderedNode[++indexVarF] = j4;
                    sorted[j4] = true;
                }
                ++j4;
            }
        }
        int i5 = 0;
        while (i5 < orderedNode.length) {
            System.out.print(String.valueOf(orderedNode[i5]) + "\t");
            ++i5;
        }
        System.out.println();
        String outputLine = "Semantics = SingleAssignment;";
        pw.println(outputLine);
        outputLine = "Agent M";
        pw.println(outputLine);
        outputLine = "\tVars:";
        pw.println(outputLine);
        i5 = 0;
        while (i5 < n) {
            outputLine = "\t\tn_" + orderedNode[i5] + ": boolean;";
            pw.println(outputLine);
            ++i5;
        }
        outputLine = "\tend Vars";
        pw.println(outputLine);
        outputLine = "\tActions = {none};";
        pw.println(outputLine);
        outputLine = "\tProtocol:";
        pw.println(outputLine);
        outputLine = "\t\tOther: {none};";
        pw.println(outputLine);
        outputLine = "\tend Protocol";
        pw.println(outputLine);
        outputLine = "\tEvolution:";
        pw.println(outputLine);
        ArrayList<Integer> parentIndices = new ArrayList<Integer>();
        int numParents = 0;
        ArrayList<Integer> activators = new ArrayList<Integer>();
        ArrayList<Integer> inhibitors = new ArrayList<Integer>();
        boolean firstAppear = false;
        int i6 = 0;
        while (i6 < F.size()) {
            String outputLine2;
            boolean[] elementF = F.get(orderedNode[i6]);
            elementVarF = varF.get(orderedNode[i6]);
            fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            parentIndices.clear();
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndices.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            numParents = parentIndices.size();
            BitVector parent = new BitVector(numParents);
            BitVector validator = new BitVector(numParents);
            int numActivation = 0;
            int j5 = 0;
            while (j5 < elementF.length) {
                if (elementF[j5]) {
                    ++numActivation;
                }
                ++j5;
            }
            j5 = 0;
            while (j5 < elementF.length) {
                if (elementF[j5]) {
                    parent.clear();
                    parent.putLongFromTo(j5, 0, numParents - 1);
                    validator.or(parent);
                }
                ++j5;
            }
            activators.clear();
            inhibitors.clear();
            j5 = 0;
            while (j5 < numParents) {
                if (validator.get(j5)) {
                    activators.add((Integer)parentIndices.get(j5));
                } else {
                    inhibitors.add((Integer)parentIndices.get(j5));
                }
                ++j5;
            }
            if (activators.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i6] + "=false if ";
                outputLine2 = "\t\tn_" + orderedNode[i6] + "=true if ";
                outputLine = String.valueOf(outputLine) + "n_" + inhibitors.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + inhibitors.get(0) + "=false";
                j5 = 1;
                while (j5 < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + inhibitors.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + inhibitors.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else if (inhibitors.size() == 0) {
                outputLine = "\t\tn_" + orderedNode[i6] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i6] + "=false if ";
                outputLine = String.valueOf(outputLine) + "n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "n_" + activators.get(0) + "=false";
                j5 = 1;
                while (j5 < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ";";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            } else {
                outputLine = "\t\tn_" + orderedNode[i6] + "=true if ";
                outputLine2 = "\t\tn_" + orderedNode[i6] + "=false if ";
                outputLine = String.valueOf(outputLine) + "(n_" + activators.get(0) + "=true";
                outputLine2 = String.valueOf(outputLine2) + "(n_" + activators.get(0) + "=false";
                j5 = 1;
                while (j5 < activators.size()) {
                    outputLine = String.valueOf(outputLine) + " or n_" + activators.get(j5) + "=true";
                    outputLine2 = String.valueOf(outputLine2) + " and n_" + activators.get(j5) + "=false";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ") and (n_" + inhibitors.get(0) + "=false";
                outputLine2 = String.valueOf(outputLine2) + ") or n_" + inhibitors.get(0) + "=true";
                j5 = 1;
                while (j5 < inhibitors.size()) {
                    outputLine = String.valueOf(outputLine) + " and n_" + inhibitors.get(j5) + "=false";
                    outputLine2 = String.valueOf(outputLine2) + " or n_" + inhibitors.get(j5) + "=true";
                    ++j5;
                }
                outputLine = String.valueOf(outputLine) + ");";
                outputLine2 = String.valueOf(outputLine2) + ";";
                pw.println(outputLine);
                pw.println(outputLine2);
            }
            if (i6 < F.size() - 1) {
                pw.println();
            }
            ++i6;
        }
        outputLine = "\tend Evolution";
        pw.println(outputLine);
        outputLine = "end Agent";
        pw.println(outputLine);
        pw.println();
        outputLine = "Evaluation";
        pw.println(outputLine);
        outputLine = "\t\tn_0_true if M.n_0=true;";
        pw.println(outputLine);
        outputLine = "end Evaluation";
        pw.println(outputLine);
        pw.println("InitStates");
        outputLine = "\t\tM.n_0=true or M.n_0=false;";
        pw.println(outputLine);
        pw.println("end InitStates\n");
        pw.println("Formulae");
        pw.println("\t\tAF n_0_true;");
        pw.println("end Formulae");
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in MCMAS format.");
    }

    public void exportPBNtoGenYsis(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        List<Integer> nv = pbn.getNv();
        List<boolean[]> F = pbn.getF();
        List<BitSet> varF = pbn.getVarF();
        ArrayList<Integer> parentIndicies = new ArrayList<Integer>();
        int i = 0;
        while (i < F.size()) {
            BitVector expression = new BitVector(nv.get(i));
            BitVector expression2 = new BitVector(nv.get(i));
            boolean[] elementF = F.get(i);
            BitSet elementVarF = varF.get(i);
            int j = 0;
            while (j < elementF.length) {
                if (elementF[j]) {
                    expression2.putLongFromTo(j, 0, nv.get(i) - 1);
                    expression.or(expression2);
                }
                ++j;
            }
            parentIndicies.clear();
            int fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                parentIndicies.add(fromIndex);
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            j = 0;
            while (j < nv.get(i)) {
                String outputLine = expression.get(j) ? "n_" + parentIndicies.get(j) + " -> n_" + i : "n_" + parentIndicies.get(j) + " -| n_" + i;
                pw.println(outputLine);
                ++j;
            }
            ++i;
        }
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in GenYsis format.");
    }

    public void exportPBN(BitSetPBN pbn, String fileName) throws FileNotFoundException {
        int j;
        int n = pbn.getN();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
        String outputLine = "//n";
        pw.println(outputLine);
        outputLine = String.valueOf(n);
        pw.println(outputLine);
        outputLine = "//nf";
        pw.println(outputLine);
        int[] nf = pbn.getNf();
        int i = 0;
        while (i < nf.length) {
            pw.print(String.valueOf(nf[i]) + " ");
            ++i;
        }
        pw.println();
        outputLine = "//nv";
        pw.println(outputLine);
        List<Integer> nv = pbn.getNv();
        i = 0;
        while (i < nv.size()) {
            pw.print(nv.get(i) + " ");
            ++i;
        }
        pw.println();
        outputLine = "//F";
        pw.println(outputLine);
        List<boolean[]> F = pbn.getF();
        i = 0;
        while (i < F.size()) {
            boolean[] elementF = F.get(i);
            j = 0;
            while (j < elementF.length) {
                outputLine = elementF[j] ? "1 " : "0 ";
                pw.print(outputLine);
                ++j;
            }
            pw.println();
            ++i;
        }
        outputLine = "//varF";
        pw.println(outputLine);
        List<BitSet> varF = pbn.getVarF();
        i = 0;
        while (i < varF.size()) {
            BitSet elementVarF = varF.get(i);
            int fromIndex = 0;
            fromIndex = elementVarF.nextSetBit(fromIndex);
            while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                pw.print(String.valueOf(fromIndex) + " ");
                ++fromIndex;
                fromIndex = elementVarF.nextSetBit(fromIndex);
            }
            pw.println();
            ++i;
        }
        outputLine = "//cij";
        pw.println(outputLine);
        List<double[]> cij = pbn.getCij();
        i = 0;
        while (i < cij.size()) {
            double[] elementCij = cij.get(i);
            j = 0;
            while (j < elementCij.length) {
                outputLine = String.valueOf(elementCij[j]) + " ";
                pw.print(outputLine);
                ++j;
            }
            pw.println();
            ++i;
        }
        outputLine = "//perturbation\n" + pbn.getPerturbation();
        pw.println(outputLine);
        List<Integer> npNode = pbn.npNode();
        if (npNode.size() == 1) {
            outputLine = "//No npNode";
        } else {
            outputLine = "//npNode\n";
            i = 0;
            while (i < npNode.size() - 1) {
                outputLine = String.valueOf(outputLine) + npNode.get(i) + " ";
                ++i;
            }
        }
        pw.println(outputLine);
        if (this.nodesName != null) {
            i = 0;
            while (i < this.nodesName.size()) {
                pw.println("// " + i + " " + this.nodesName.get(i).getNodeName());
                ++i;
            }
        }
        pw.close();
        System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in ASSA-PBN format.");
    }

    private void addIndex(List<int[]> indexFunction, int[] nf, int level, int number) {
        if (level == nf.length - 1) {
            int i = 0;
            while (i < nf[level]) {
                if (i == 0) {
                    indexFunction.get((int)number)[level] = i;
                } else {
                    int[] newIndex = new int[nf.length];
                    newIndex = (int[])indexFunction.get(number).clone();
                    newIndex[level] = i;
                    indexFunction.add(newIndex);
                    if (++number >= 999) break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nf[level]) {
                if (i == 0) {
                    indexFunction.get((int)number)[level] = i;
                    this.addIndex(indexFunction, nf, level + 1, number);
                } else {
                    int[] newIndex = new int[nf.length];
                    newIndex = (int[])indexFunction.get(number).clone();
                    newIndex[level] = i;
                    indexFunction.add(newIndex);
                    this.addIndex(indexFunction, nf, level + 1, indexFunction.size() - 1);
                    if (++number >= 999) break;
                }
                ++i;
            }
        }
    }

    public void exportPBNtoBN(BitSetPBN pbn, String fileName) throws Exception {
        int n = pbn.getN();
        long numBNs = 1L;
        int[] nf = pbn.getNf();
        ArrayList<int[]> indexFunction = new ArrayList<int[]>();
        int[] newIndex = new int[nf.length];
        indexFunction.add(newIndex);
        int i = 0;
        while (i < nf.length) {
            numBNs *= (long)nf[i];
            ++i;
        }
        this.addIndex(indexFunction, nf, 0, 0);
        if (numBNs > 1000L) {
            System.out.println(String.valueOf(numBNs) + " possible BNs. I am only going to export the first 1000.");
            numBNs = 1000L;
        }
        int[] cumNf = pbn.buildCumNf();
        int index = 0;
        while (index < indexFunction.size()) {
            File file = new File(String.valueOf(fileName) + "_" + index + ".bn");
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)), true);
            String outputLine = "//n";
            pw.println(outputLine);
            outputLine = String.valueOf(n);
            pw.println(outputLine);
            outputLine = "//nf";
            pw.println(outputLine);
            int i2 = 0;
            while (i2 < n) {
                pw.print("1 ");
                ++i2;
            }
            pw.println();
            outputLine = "//nv";
            pw.println(outputLine);
            List<Integer> nv = pbn.getNv();
            i2 = 0;
            while (i2 < n) {
                pw.print(nv.get(cumNf[i2] + ((int[])indexFunction.get(index))[i2]) + " ");
                ++i2;
            }
            pw.println();
            outputLine = "//F";
            pw.println(outputLine);
            List<boolean[]> F = pbn.getF();
            i2 = 0;
            while (i2 < n) {
                boolean[] elementF = F.get(cumNf[i2] + ((int[])indexFunction.get(index))[i2]);
                int j = 0;
                while (j < elementF.length) {
                    outputLine = elementF[j] ? "1 " : "0 ";
                    pw.print(outputLine);
                    ++j;
                }
                pw.println();
                ++i2;
            }
            outputLine = "//varF";
            pw.println(outputLine);
            List<BitSet> varF = pbn.getVarF();
            i2 = 0;
            while (i2 < n) {
                BitSet elementVarF = varF.get(cumNf[i2] + ((int[])indexFunction.get(index))[i2]);
                int fromIndex = 0;
                fromIndex = elementVarF.nextSetBit(fromIndex);
                while (fromIndex != -1 && fromIndex < elementVarF.size()) {
                    pw.print(String.valueOf(fromIndex) + " ");
                    ++fromIndex;
                    fromIndex = elementVarF.nextSetBit(fromIndex);
                }
                pw.println();
                ++i2;
            }
            outputLine = "//cij";
            pw.println(outputLine);
            i2 = 0;
            while (i2 < n) {
                outputLine = "1 ";
                pw.print(outputLine);
                pw.println();
                ++i2;
            }
            outputLine = "//perturbation\n" + pbn.getPerturbation();
            pw.println(outputLine);
            List<Integer> npNode = pbn.npNode();
            if (npNode.size() == 1) {
                outputLine = "//No npNode";
            } else {
                outputLine = "//npNode\n";
                i2 = 0;
                while (i2 < npNode.size() - 1) {
                    outputLine = String.valueOf(outputLine) + npNode.get(i2);
                    ++i2;
                }
            }
            pw.println(outputLine);
            if (this.nodesName != null) {
                i2 = 0;
                while (i2 < this.nodesName.size()) {
                    pw.println("// " + i2 + " " + this.nodesName.get(i2).getNodeName());
                    ++i2;
                }
            }
            pw.close();
            System.out.println("The " + pbn.getN() + " nodes PBN is exported to file " + fileName + " in ASSA-PBN format.");
            ++index;
        }
    }

    public void exportTransitionMatrix() throws Exception {
        StateBit st1 = new StateBit(this.n);
        StateBit st2 = new StateBit(this.n);
        int i = 0;
        while ((double)i < Math.pow(2.0, this.n)) {
            System.out.print("State " + i + " : ");
            int j = 0;
            while ((double)j < Math.pow(2.0, this.n)) {
                st1.putLongFromTo(i, 0, this.n - 1);
                st2.putLongFromTo(j, 0, this.n - 1);
                System.out.print(String.valueOf(this.getAij(st1, st2)) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void exportTransitionMatrixContexPBN() throws Exception {
        int length = this.pbn.getStateLength();
        StateBit st1 = new StateBit(length);
        StateBit st2 = new StateBit(length);
        int nb = ((ContextPBN)this.pbn).getNb();
        int total = (int)Math.pow(2.0, this.n);
        int i1 = 0;
        while (i1 < nb) {
            int i = 0;
            while (i < total) {
                int state1 = i1 * total + i;
                System.out.print("State " + state1 + " : ");
                int j1 = 0;
                while (j1 < nb) {
                    int j = 0;
                    while (j < total) {
                        int state2 = j1 * total + j;
                        st1.putLongFromTo(state1, 0, length - 1);
                        st2.putLongFromTo(state2, 0, length - 1);
                        System.out.print(String.valueOf(this.getAijContextPBN(st1, st2, true)) + " ");
                        ++j;
                    }
                    ++j1;
                }
                System.out.println();
                ++i;
            }
            ++i1;
        }
    }

    public double[] getTransitionProbability(StateBit st) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        int[] nf = this.pbn.getNf();
        int[] cumNf = this.pbn.buildCumNf();
        double[][] cijTotal = new double[this.n][2];
        int index = 0;
        while (index < this.n) {
            cijTotal[index][0] = 0.0;
            cijTotal[index][1] = 0.0;
            int jdex = 0;
            while (jdex < nf[index]) {
                Boolean nextStateNode = this.pbn.getNextNodeValue(cumNf[index] + jdex, st);
                if (nextStateNode.booleanValue()) {
                    double[] dArray = cijTotal[index];
                    dArray[1] = dArray[1] + ((BitSetPBN)this.pbn).getCij().get(index)[jdex];
                } else {
                    double[] dArray = cijTotal[index];
                    dArray[0] = dArray[0] + ((BitSetPBN)this.pbn).getCij().get(index)[jdex];
                }
                ++jdex;
            }
            ++index;
        }
        double[] re = new double[(int)Math.pow(2.0, this.n)];
        BitVector b = new BitVector(this.n);
        this.setProbability(re, cijTotal, 1.0, 0, b);
        StateBit j = new StateBit(this.n);
        int i = 0;
        while (i < re.length) {
            if (this.pbn.getPerturbation() > 0.0) {
                j.putLongFromTo(i, 0, this.n - 1);
                st.xor(j);
                int hammDis = st.cardinality();
                st.xor(j);
                re[i] = re[i] * Math.pow(1.0 - this.pbn.getPerturbation(), this.n);
                if (hammDis != 0) {
                    int n = i;
                    re[n] = re[n] + Math.pow(this.pbn.getPerturbation(), hammDis) * Math.pow(1.0 - this.pbn.getPerturbation(), this.n - hammDis);
                }
            }
            ++i;
        }
        return re;
    }

    public List<Double> getTransitionProbability(StateBit st, boolean enablePerturbation) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        StateBit st1 = new StateBit(this.n);
        ArrayList<Double> re = new ArrayList<Double>();
        int i = 0;
        while ((double)i < Math.pow(2.0, this.n)) {
            st1.putLongFromTo(i, 0, this.n);
            double pro = this.getAij(st, st1, enablePerturbation);
            if (pro > 1.0E-11) {
                re.add(Double.valueOf(i));
                re.add(pro);
            }
            ++i;
        }
        return re;
    }

    public double[] getColumTransitionProbability(StateBit st) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        int tmp = 1;
        int stateLength = this.n;
        StateBit st1 = new StateBit(st.size());
        if (this.pbn instanceof ContextPBN) {
            tmp = ((ContextPBN)this.pbn).getNb();
            stateLength = this.pbn.getStateLength();
        }
        double[] re = new double[tmp * (int)Math.pow(2.0, this.n)];
        int i = 0;
        while (i < re.length) {
            st1.putLongFromTo(i, 0, stateLength - 1);
            re[i] = this.getAij(st1, st);
            ++i;
        }
        return re;
    }

    public double getAij(StateBit i, StateBit j) throws Exception {
        return this.getAij(i, j, true);
    }

    public double getAij(StateBit i, StateBit j, boolean enablePerturbation) throws Exception {
        if (this.PBNtype == 1) {
            return this.getAijContextPBN(i, j, enablePerturbation);
        }
        return this.getAijBitSetPBN(i, j, enablePerturbation);
    }

    public double getAijBitSetPBN(StateBit i, StateBit j, boolean enablePerturbation) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        int[] nf = this.pbn.getNf();
        int[] cumNf = this.pbn.buildCumNf();
        double aij = 1.0;
        int index = 0;
        while (index < this.n) {
            double cijTotal = 0.0;
            int jdex = 0;
            while (jdex < nf[index]) {
                Boolean nextStateNode = this.pbn.getNextNodeValue(cumNf[index] + jdex, i);
                if (j.get(index) == nextStateNode.booleanValue()) {
                    cijTotal += ((BitSetPBN)this.pbn).getCij().get(index)[jdex];
                }
                ++jdex;
            }
            aij *= cijTotal;
            ++index;
        }
        if (enablePerturbation && this.pbn.getPerturbation() > 0.0) {
            i.xor(j);
            int hammDis = i.cardinality();
            i.xor(j);
            aij *= Math.pow(1.0 - this.pbn.getPerturbation(), this.n);
            if (hammDis != 0) {
                aij += Math.pow(this.pbn.getPerturbation(), hammDis) * Math.pow(1.0 - this.pbn.getPerturbation(), this.n - hammDis);
            }
        }
        return aij;
    }

    public double getAijContextPBN(StateBit i, StateBit j, boolean enablePerturbation) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        int[] nf = this.pbn.getNf();
        int[] cumNf = this.pbn.buildCumNf();
        StateBit tmpi = new StateBit(this.pbn.getStateLength());
        StateBit tmpj = new StateBit(this.pbn.getStateLength());
        tmpi.set(0, this.pbn.getStateLength(), true);
        tmpi.clear(this.n, this.pbn.getStateLength());
        tmpj.xor(tmpi);
        tmpi.and(i);
        tmpj.and(j);
        double aij = 1.0;
        int context = (int)i.getLongFromTo(this.n, this.pbn.getStateLength());
        BitVector elementBNindex = ((ContextPBN)this.pbn).getBNindex().get(context);
        int[] elementBN = ((ContextPBN)this.pbn).getBN().get(context);
        int start = 0;
        int count = 0;
        start = elementBNindex.indexOfFromTo(start, elementBNindex.size() - 1, true);
        while (start != -1) {
            Boolean nextStateNode = this.pbn.getNextNodeValue(cumNf[start] + elementBN[count], i);
            if (j.get(start) != nextStateNode.booleanValue()) {
                aij = 0.0;
                break;
            }
            ++count;
            if (++start >= elementBNindex.size()) break;
            start = elementBNindex.indexOfFromTo(start, elementBNindex.size() - 1, true);
        }
        if (enablePerturbation && this.pbn.getPerturbation() > 0.0) {
            tmpi.xor(tmpj);
            int hammDis = tmpi.cardinality();
            tmpi.xor(tmpj);
            aij *= Math.pow(1.0 - this.pbn.getPerturbation(), this.n);
            if (hammDis != 0) {
                aij += Math.pow(this.pbn.getPerturbation(), hammDis) * Math.pow(1.0 - this.pbn.getPerturbation(), this.n - hammDis);
            }
        }
        int jContext = (int)j.getLongFromTo(this.n, this.pbn.getStateLength());
        double[] swi = ((ContextPBN)this.pbn).getSwi();
        aij = context == jContext ? (aij *= swi[0] + swi[jContext + 1]) : (aij *= swi[jContext + 1]);
        return aij;
    }

    public List<Double> getTransitionProbabilityNoPerturbe(StateBit i) throws Exception {
        if (this.pbn == null) {
            throw new Exception("PBN not defined!");
        }
        int[] nf = this.pbn.getNf();
        int[] cumNf = this.pbn.buildCumNf();
        ArrayList<Double> re = new ArrayList<Double>();
        double[][] cijTotal = new double[this.n][2];
        int index = 0;
        while (index < this.n) {
            cijTotal[index][0] = 0.0;
            cijTotal[index][1] = 0.0;
            int jdex = 0;
            while (jdex < nf[index]) {
                Boolean nextStateNode = this.pbn.getNextNodeValue(cumNf[index] + jdex, i);
                if (nextStateNode.booleanValue()) {
                    double[] dArray = cijTotal[index];
                    dArray[1] = dArray[1] + ((BitSetPBN)this.pbn).getCij().get(index)[jdex];
                } else {
                    double[] dArray = cijTotal[index];
                    dArray[0] = dArray[0] + ((BitSetPBN)this.pbn).getCij().get(index)[jdex];
                }
                ++jdex;
            }
            ++index;
        }
        BitVector b = new BitVector(this.n);
        this.setProbability(re, cijTotal, 1.0, 0, b);
        return re;
    }

    private void setProbability(List<Double> re, double[][] cijTotal, double multiply, int currentLevel, BitVector b) {
        if (currentLevel == this.n - 1) {
            if (cijTotal[currentLevel][0] < 1.0E-11) {
                b.set(currentLevel);
                re.add(Double.valueOf(b.getLongFromTo(0, this.n - 1)));
                re.add(multiply * cijTotal[currentLevel][1]);
            } else if (cijTotal[currentLevel][1] < 1.0E-11) {
                b.clear(currentLevel);
                re.add(Double.valueOf(b.getLongFromTo(0, this.n - 1)));
                re.add(multiply * cijTotal[currentLevel][0]);
            } else {
                b.clear(currentLevel);
                re.add(Double.valueOf(b.getLongFromTo(0, this.n - 1)));
                re.add(multiply * cijTotal[currentLevel][0]);
                b.set(currentLevel);
                re.add(Double.valueOf(b.getLongFromTo(0, this.n - 1)));
                re.add(multiply * cijTotal[currentLevel][1]);
            }
        } else if (cijTotal[currentLevel][0] < 1.0E-11) {
            b.set(currentLevel);
            this.setProbability(re, cijTotal, multiply *= cijTotal[currentLevel][1], currentLevel + 1, b);
        } else if (cijTotal[currentLevel][1] < 1.0E-11) {
            b.put(currentLevel, false);
            this.setProbability(re, cijTotal, multiply *= cijTotal[currentLevel][0], currentLevel + 1, b);
        } else {
            b.put(currentLevel, false);
            this.setProbability(re, cijTotal, multiply * cijTotal[currentLevel][0], currentLevel + 1, b);
            b.set(currentLevel);
            this.setProbability(re, cijTotal, multiply * cijTotal[currentLevel][1], currentLevel + 1, b);
        }
    }

    private void setProbability(double[] re, double[][] cijTotal, double multiply, int currentLevel, BitVector b) {
        if (currentLevel == this.n - 1) {
            if (cijTotal[currentLevel][0] < 1.0E-11) {
                b.set(currentLevel);
                re[(int)b.getLongFromTo((int)0, (int)(this.n - 1))] = multiply * cijTotal[currentLevel][1];
            } else if (cijTotal[currentLevel][1] < 1.0E-11) {
                b.clear(currentLevel);
                re[(int)b.getLongFromTo((int)0, (int)(this.n - 1))] = multiply * cijTotal[currentLevel][0];
            } else {
                b.clear(currentLevel);
                re[(int)b.getLongFromTo((int)0, (int)(this.n - 1))] = multiply * cijTotal[currentLevel][0];
                b.set(currentLevel);
                re[(int)b.getLongFromTo((int)0, (int)(this.n - 1))] = multiply * cijTotal[currentLevel][1];
            }
        } else if (cijTotal[currentLevel][0] < 1.0E-11) {
            b.set(currentLevel);
            this.setProbability(re, cijTotal, multiply *= cijTotal[currentLevel][1], currentLevel + 1, b);
        } else if (cijTotal[currentLevel][1] < 1.0E-11) {
            b.put(currentLevel, false);
            this.setProbability(re, cijTotal, multiply *= cijTotal[currentLevel][0], currentLevel + 1, b);
        } else {
            b.put(currentLevel, false);
            this.setProbability(re, cijTotal, multiply * cijTotal[currentLevel][0], currentLevel + 1, b);
            b.set(currentLevel);
            this.setProbability(re, cijTotal, multiply * cijTotal[currentLevel][1], currentLevel + 1, b);
        }
    }

    public static void main(String[] args) {
        try {
            BitSetPBNIO exp = new BitSetPBNIO();
            int num = 2;
            int nodeNum = 50;
            BitSetPBN pbn = exp.loadPBN("model/PBN_96_12_1.txt", true);
            exp.exportPBN(pbn, "model/PBN_96_12_1_export.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

