/*
 * Decompiled with CFR 0.152.
 */
package functionLib;

import cern.colt.bitvector.BitVector;

public class HammingDistance {
    public static int getDistance(String s1, String s2) {
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            throw new IllegalArgumentException();
        }
        int distance = 0;
        int i = 0;
        while (i < s1.length()) {
            if (s1.charAt(i) != s2.charAt(i)) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public static int getDistance(BitVector s1, BitVector s2) {
        if (s1 == null || s2 == null || s1.size() != s2.size()) {
            throw new IllegalArgumentException();
        }
        BitVector re = s1.copy();
        re.xor(s2);
        return re.cardinality();
    }

    public static int getDistance(int s1, int s2) {
        BitVector b = new BitVector(32);
        b.putLongFromTo(s1 ^= s2, 0, 31);
        return b.cardinality();
    }
}

