/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetEngine;
import PBN.BitSetPBN;
import PBN.ContextEngine;
import PBN.ContextPBN;
import PBN.Engine;
import PBN.PBN;
import PBN.StateBit;
import simulationMethod.SimulationEngine;
import simulationMethod.SimulationMethod;

public class BitSetPBNSimulationEngine
extends SimulationEngine {
    PBN pbn;
    Engine engine;

    public BitSetPBNSimulationEngine() {
    }

    public BitSetPBNSimulationEngine(PBN pbn, SimulationMethod sm) {
        this.pbn = pbn;
        if (pbn instanceof BitSetPBN) {
            this.engine = new BitSetEngine(pbn);
            ((BitSetEngine)this.engine).generateAlias();
        } else if (pbn instanceof ContextPBN) {
            this.engine = new ContextEngine(pbn);
        }
        this.sm = sm;
    }

    public void setDisableGlobalAlias(boolean dis) {
        ((BitSetEngine)this.engine).setdisableGlobalcij(dis);
    }

    @Override
    public Object simulate(long length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, 0);
            current = next;
            ++i;
        }
        return current;
    }

    @Override
    public Object simulate(int length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        int i = 0;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, 0);
            current = next;
            ++i;
        }
        return current;
    }

    public Object simulate(long length, Object initialState, int chainIndex) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, chainIndex);
            current = next;
            ++i;
        }
        return current;
    }
}

