/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;

public class GelmanFullStateNoBurnin
extends SimulationMethod {
    private List<Integer> trajectory;
    private List<List> trajectories;
    private BitSetPBN pbn;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEngine engine;
    int statesize;
    private boolean convergeRun = false;
    int Nmax;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double alpha;
    private double beta;
    private int meta1 = 0;
    private int meta2 = 0;
    private int countStep = 0;
    int[] index1;
    private int[][] transitionsLast;

    public GelmanFullStateNoBurnin(BitSetPBN pbn) {
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = 10;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.transitionsLast = new int[2][2];
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public void setM(int m) {
        this.m = m;
        this.index1 = new int[m];
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
        this.statesize = this.pbn.getN();
    }

    public void reInitialise() {
        this.trajectories = null;
        this.reInitialiseAlphaBeta();
        this.convergeRun = false;
    }

    private void reInitialiseAlphaBeta() {
        this.meta1 = 0;
        this.meta2 = 0;
        this.countStep = 0;
        if (this.transitionsLast == null) {
            this.transitionsLast = new int[2][2];
        } else {
            this.transitionsLast[0][0] = 0;
            this.transitionsLast[0][1] = 0;
            this.transitionsLast[1][0] = 0;
            this.transitionsLast[1][1] = 0;
        }
    }

    public void runConverge() throws Exception {
        this.initialise();
        this.n = 0;
        this.trajectories = new ArrayList<List>();
        int i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<Integer>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i2 = 0;
        while (i2 < this.m) {
            this.initialState[i2] = new StateBit(this.statesize);
            this.initialState[i2].putLongFromTo(statespace * (long)i2, 0, this.statesize - 1);
            ++i2;
        }
        this.trajectories = new ArrayList<List>();
        i2 = 0;
        while (i2 < this.m) {
            this.trajectory = new ArrayList<Integer>();
            this.trajectories.add(this.trajectory);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m) {
            this.count = i2;
            this.initialState[i2] = (StateBit)this.engine.simulate(this.n * 2, (Object)this.initialState[i2]);
            ++i2;
        }
        this.convergeRun = true;
    }

    public double[] computeSteadyState() throws Exception {
        int extentionPerChain;
        if (!this.convergeRun) {
            this.runConverge();
        }
        this.reInitialiseAlphaBeta();
        double[] result = new double[3];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        this.index1 = new int[this.m];
        this.meta1 = 0;
        this.meta2 = 0;
        double threshold = 0.0;
        threshold = 3.0 / (double)(this.countStep * this.m);
        while (this.alpha < threshold || this.beta < threshold || this.alpha > 0.9999999 && this.beta > 0.9999999) {
            extentionPerChain = 2;
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(extentionPerChain);
            threshold = 3.0 / (double)(this.countStep * this.m);
        }
        int N = (int)Math.ceil(this.alpha * this.beta / (Math.pow(this.alpha + this.beta, 2.0) * Math.pow(this.precision / invPhi, 2.0)));
        int current = 0;
        current = this.twon - 1;
        this.count = 0;
        boolean round = false;
        while (N > this.meta1 + this.meta2) {
            extentionPerChain = (int)Math.ceil((double)(N - this.meta1 - this.meta2) / (double)this.m);
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(extentionPerChain);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        }
        result[0] = (double)this.meta1 / (double)(this.meta1 + this.meta2);
        result[1] = N;
        if (N > this.Nmax) {
            this.Nmax = N;
        }
        return result;
    }

    public void calAlphaBeta(int length, boolean isTotalLength) throws Exception {
        if (isTotalLength) {
            if (length < this.countStep) {
                throw new Exception("The number of processed samples is bigger than the length. No need to recompute.");
            }
            this.calAlphaBeta(length - this.countStep);
        } else {
            this.calAlphaBeta(length);
        }
    }

    public void calAlphaBeta(int length) throws Exception {
        int index2 = 0;
        StateBit st = new StateBit(this.statesize);
        boolean first = false;
        int localCount = 0;
        if (this.countStep == 0) {
            first = true;
            --length;
        }
        if (this.countStep + length >= this.trajectories.get(0).size()) {
            throw new Exception("Trajectory is not long enough!");
        }
        int i = 0;
        while (i < this.m) {
            boolean eva;
            localCount = this.countStep;
            if (first) {
                st.putLongFromTo(((Integer)this.trajectories.get(i).get(0 + this.n)).intValue(), 0, this.statesize - 1);
                eva = this.evaluateState(st);
                if (eva) {
                    ++this.meta1;
                    this.index1[i] = 1;
                } else {
                    ++this.meta2;
                    this.index1[i] = 0;
                }
                ++localCount;
            }
            int j = 0;
            while (j < length) {
                st.putLongFromTo(((Integer)this.trajectories.get(i).get(localCount + this.n)).intValue(), 0, this.statesize - 1);
                eva = this.evaluateState(st);
                int bridge = this.index1[i];
                if (eva) {
                    ++this.meta1;
                    this.index1[i] = 1;
                    index2 = 1;
                    int[] nArray = this.transitionsLast[bridge];
                    int n = index2;
                    nArray[n] = nArray[n] + 1;
                } else {
                    ++this.meta2;
                    this.index1[i] = 0;
                    index2 = 0;
                    int[] nArray = this.transitionsLast[bridge];
                    int n = index2;
                    nArray[n] = nArray[n] + 1;
                }
                ++localCount;
                ++j;
            }
            ++i;
        }
        this.countStep = localCount;
        this.beta = this.transitionsLast[0][0] + this.transitionsLast[0][1] == 0 ? 0.0 : (double)this.transitionsLast[0][1] / (double)(this.transitionsLast[0][0] + this.transitionsLast[0][1]);
        this.alpha = this.transitionsLast[1][0] + this.transitionsLast[1][1] == 0 ? 0.0 : (double)this.transitionsLast[1][0] / (double)(this.transitionsLast[1][0] + this.transitionsLast[1][1]);
    }

    public void runPlot() throws Exception {
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        Random ran = RandomProvider.getInstance().getRandom();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(statespace * (long)i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<Integer>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        this.previousIndex = 0;
        int extension = this.n;
        int k = 1;
        while (k < 501) {
            int i2 = 0;
            while (i2 < this.m) {
                this.count = i2;
                initialState[i2] = (StateBit)engine.simulate(extension * 2, (Object)initialState[i2]);
                ++i2;
            }
            double within = 0.0;
            double grandmean = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                mean[i2] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i2;
                    mean[n] = mean[n] + (double)((Integer)this.trajectories.get(i2).get(j + this.n)).intValue();
                    ++j;
                }
                mean[i2] = mean[i2] / (double)this.n;
                mean_meansquare += mean[i2] * mean[i2];
                grandmean += mean[i2];
                sj[i2] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    int n = i2;
                    sj[n] = sj[n] + Math.pow((double)((Integer)this.trajectories.get(i2).get(j)).intValue() - mean[i2], 2.0);
                    ++j;
                }
                sj[i2] = sj[i2] / (double)(this.n - 1);
                within += sj[i2];
                ++i2;
            }
            within /= (double)this.m;
            grandmean /= (double)this.m;
            mean_meansquare /= (double)this.m;
            double between = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                between += Math.pow(grandmean - mean[i2], 2.0);
                ++i2;
            }
            between = between * (double)this.n / (double)(this.m - 1);
            double varianceW = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                varianceW += Math.pow(sj[i2] - within, 2.0);
                ++i2;
            }
            varianceW /= (double)(this.m - 1);
            varianceW /= (double)this.m;
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = 0.0;
            double covwx = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                covwxsquare += (sj[i2] - within) * (mean[i2] * mean[i2] - mean_meansquare);
                covwx += (sj[i2] - within) * (mean[i2] - grandmean);
                ++i2;
            }
            double covwb = (double)(this.n / this.m) * ((covwxsquare /= (double)(this.m - 1)) - 2.0 * grandmean * (covwx /= (double)(this.m - 1)));
            double varianceV = (Math.pow(this.n - 1, 2.0) * varianceW + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            System.out.println("m=" + this.m + ", n=" + this.n + ", psrf=" + psrf);
            extension = 5;
            this.n += extension;
            this.twon = this.n * 2;
            ++k;
        }
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        int tmp = (int)st.getLongFromTo(0, st.getN());
        this.trajectories.get(this.count).add(tmp);
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public void setExpressions(String property) throws IOException {
        int value;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        this.positiveIndex = new ArrayList<Integer>();
        this.negativeIndex = new ArrayList<Integer>();
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.positiveIndex.add(value);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.negativeIndex.add(value);
        }
        br.close();
        reader.close();
    }

    public double[][] computeDistribution() throws Exception {
        if (this.positiveIndex == null) {
            this.positiveIndex = new ArrayList<Integer>();
            this.negativeIndex = new ArrayList<Integer>();
        } else {
            this.positiveIndex.clear();
            this.negativeIndex.clear();
        }
        BitVector bs = new BitVector(this.pbn.getN());
        double[][] dis = new double[(int)Math.pow(2.0, this.pbn.getN())][2];
        this.runConverge();
        int i = 0;
        while ((double)i < Math.pow(2.0, this.pbn.getN())) {
            bs.clear();
            bs.putLongFromTo(i, 0, bs.size() - 1);
            int j = 0;
            while (j < bs.size()) {
                if (bs.get(j)) {
                    this.positiveIndex.add(j);
                } else {
                    this.negativeIndex.add(j);
                }
                ++j;
            }
            dis[i] = this.computeSteadyState();
            this.positiveIndex.clear();
            this.negativeIndex.clear();
            ++i;
        }
        return dis;
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)(Math.ceil(N / this.m) + (double)this.twon - (double)this.trajectories.get(0).size()) + 1;
        if (extentionPerChain > 0) {
            int i = 0;
            while (i < this.m) {
                this.count = i;
                this.initialState[i] = (StateBit)this.engine.simulate(extentionPerChain, (Object)this.initialState[i]);
                ++i;
            }
        }
    }

    public void printStatistic() {
        System.out.println("m=" + this.m + ", n=" + this.n + ", Nmax=" + this.Nmax);
    }

    public int getNmax() {
        return this.Nmax;
    }

    public static void main(String[] args) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO();
        BitSetPBN pbn = io.loadPBN("PBN_vegelman_7.txt");
        boolean in = false;
        GelmanFullStateNoBurnin gelman = new GelmanFullStateNoBurnin(pbn);
        gelman.setExpressions("model/property_2.txt");
        gelman.setParameters(0.01, 0.95);
        gelman.setM(5);
        double[] re = gelman.computeSteadyState();
        System.out.println(String.valueOf(re[0]) + "\t" + re[1]);
        gelman.printStatistic();
        gelman.reInitialise();
        re = gelman.computeSteadyState();
        System.out.println(String.valueOf(re[0]) + "\t" + re[1]);
        gelman.printStatistic();
    }
}

