/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import functionLib.RandomProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import parallel.Simulate;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;

public class ParallelSimulatingTest
extends SimulationMethod {
    private List<Long> trajectory;
    private List<List> trajectories;
    private BitSetPBN pbn;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEngine engine;
    int statesize;
    private boolean convergeRun = false;
    int Nmax;
    int kstep = 1;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double alpha;
    private double beta;
    private int meta1 = 0;
    private int meta2 = 0;
    private int countStep = 0;
    int[] index1;
    private int[][] transitionsLast;
    private Simulate parallelSimulate;
    private ForkJoinPool pool;

    public ParallelSimulatingTest(BitSetPBN pbn) {
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = 4;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.transitionsLast = new int[2][2];
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
        this.statesize = this.pbn.getN();
    }

    public void runConverge(int steps) throws Exception {
        this.initialise();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<Long>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = 1000000000;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, steps, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(steps);
        this.pool.invoke(this.parallelSimulate);
    }

    public void runSequential(int steps) throws Exception {
        this.initialise();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<Long>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = 1000000000;
        this.previousIndex = 0;
        i = 0;
        while (i < this.m) {
            this.count = i;
            this.initialState[i] = (StateBit)this.engine.simulate(steps, (Object)this.initialState[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        BitSetPBNIO io = new BitSetPBNIO();
        try {
            BitSetPBN pbn = io.loadPBN("PBN_vegelman_7.txt");
            ParallelSimulatingTest pst = new ParallelSimulatingTest(pbn);
            int steps = 2000000;
            long start = System.currentTimeMillis();
            pst.runSequential(steps);
            System.out.println("run 4*" + steps + " sequencially cost " + (double)(System.currentTimeMillis() - start) / 1000.0);
            start = System.currentTimeMillis();
            pst.runConverge(steps);
            System.out.println("run 4*" + steps + " in parallel cost " + (double)(System.currentTimeMillis() - start) / 1000.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateTransition(StateBit st, int parameter) {
    }
}

