/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.StateBit;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import jsc.distributions.StudentsT;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationEngine;
import simulationMethod.SimulationMethod;

public class SkartPBNLarge
extends SimulationMethod {
    private BitSet trajectory;
    private List<BitSet> trajectories;
    private long n;
    private long traIndex;
    private BitSetPBN pbn;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private boolean precisionSet = false;
    private double precision;
    private boolean isRelative = false;
    private double alpha;
    private final double ZERO = 1.0E-12;
    private final long maxInt = 0x80000000L;
    private boolean debug = false;
    private String outputName;
    private boolean disableGlobalAlias;

    public SkartPBNLarge(BitSetPBN pbn) {
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "skart" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
    }

    public SkartPBNLarge(BitSetPBN pbn, List<Integer> positiveIndex, List<Integer> negativeIndex) {
        this.pbn = pbn;
        this.positiveIndex = positiveIndex;
        this.negativeIndex = negativeIndex;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "skart" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
    }

    public String getLogFile() {
        return this.outputName;
    }

    public void setLogFile(String outputName) {
        this.outputName = outputName;
    }

    public void setDisableGlobalAlias(boolean dis) {
        this.disableGlobalAlias = dis;
    }

    public void setExpressions(String property) throws IOException {
        int value;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        this.positiveIndex = new ArrayList<Integer>();
        this.negativeIndex = new ArrayList<Integer>();
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.positiveIndex.add(value);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            value = Integer.parseInt(token.nextToken());
            if (value < 0) continue;
            this.negativeIndex.add(value);
        }
        br.close();
        reader.close();
    }

    public void setPrecision(double precision) {
        this.precision = precision;
        this.precisionSet = true;
    }

    public void setPrecision(double precision, boolean isRelative) {
        this.precision = precision;
        this.isRelative = isRelative;
        this.precisionSet = true;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public double[] run() throws Exception {
        double yjm_element;
        int m;
        if (this.positiveIndex == null && this.negativeIndex == null) {
            throw new Exception("Meta states not defined!");
        }
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        long time = System.currentTimeMillis();
        int ext_step2 = 0;
        int ext_step5 = 0;
        int d_max = 10;
        PrintWriter pw = new PrintWriter(new FileWriter(this.outputName, true));
        double alpha_ran = 0.2;
        int b = 0;
        this.n = 1280L;
        this.traIndex = 0L;
        int l = 1024;
        this.trajectory = new BitSet((int)this.n);
        this.trajectories = new ArrayList<BitSet>();
        this.trajectories.add(this.trajectory);
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        if (this.disableGlobalAlias) {
            engine.setDisableGlobalAlias(this.disableGlobalAlias);
        }
        StateBit initialState = new StateBit(this.pbn.getN());
        initialState = (StateBit)engine.simulate(this.n, (Object)initialState);
        BitSet trajectoryCopy = (BitSet)this.trajectory.clone();
        trajectoryCopy.clear(0, (int)this.n - l - 1);
        double average = (double)trajectoryCopy.cardinality() / (double)l;
        double sVariance = 0.0;
        double skewness = 0.0;
        int i = 0;
        while (i < l) {
            boolean bit = trajectoryCopy.get((int)this.n - 1 - i);
            boolean xjm = bit;
            sVariance += Math.pow((double)xjm - average, 2.0);
            skewness += Math.pow((double)xjm - average, 3.0);
            ++i;
        }
        if (Math.abs(skewness = skewness * (double)l / (Math.pow(sVariance = Math.sqrt(sVariance / (double)(l - 1)), 3.0) * (double)(l - 1) * (double)(l - 2))) <= 4.0) {
            m = 1;
        } else {
            m = 16;
            initialState = (StateBit)engine.simulate(this.n * (long)(m - 1), (Object)initialState);
        }
        int k = (int)this.n;
        this.n = k * m;
        ArrayList<Double> yjm = new ArrayList<Double>();
        i = 0;
        while (i < k) {
            yjm_element = 0.0;
            int j = 0;
            while (j < m) {
                if (this.trajectory.get(m * i + j)) {
                    yjm_element += 1.0;
                }
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
        if (Math.abs(skewness) > 0.5) {
            d_max = 3;
        }
        if (this.debug) {
            System.out.println("Finish step 1, d_max=" + d_max);
        }
        pw.println("Finish step 1, d_max=" + d_max);
        int d = 0;
        boolean pass = false;
        double invPhi = StatUtil.getInvCDF(1.0 - alpha_ran / 2.0, false);
        int k_prime = k;
        while (!pass) {
            double Ck;
            int j;
            int i2;
            ++ext_step2;
            if (b != 0 || d != 0) {
                yjm = new ArrayList();
                System.gc();
                i2 = 0;
                while (i2 < k_prime) {
                    yjm_element = 0.0;
                    j = 0;
                    while (j < m) {
                        if (this.trajectory.get(m * ((i2 + 1) * (d + 1) - 1) + j)) {
                            yjm_element += 1.0;
                        }
                        ++j;
                    }
                    yjm.add(yjm_element /= (double)m);
                    ++i2;
                }
            }
            if (Math.abs(Ck = this.Ck(yjm, 0, yjm.size())) <= invPhi * Math.sqrt(((double)k_prime - 2.0) / ((double)k_prime * (double)k_prime - 1.0))) {
                pass = true;
                continue;
            }
            k_prime = (int)Math.floor(this.n / (long)((++d + 1) * m));
            if (d <= d_max) continue;
            m = (int)Math.ceil((double)m * Math.sqrt(2.0));
            k = (int)Math.ceil(0.9 * (double)k);
            long previousN = this.n;
            this.n = k * m;
            initialState = (StateBit)engine.simulate(this.n - previousN, (Object)initialState);
            d = 0;
            ++b;
            d_max = 10;
            if (this.debug) {
                System.out.println("k=" + k + ",b=" + b);
            }
            pw.println("k=" + k + ",b=" + b);
            yjm = new ArrayList();
            i2 = 0;
            while (i2 < k) {
                yjm_element = 0.0;
                j = 0;
                while (j < m) {
                    if (this.trajectory.get(m * i2 + j)) {
                        yjm_element += 1.0;
                    }
                    ++j;
                }
                yjm.add(yjm_element /= (double)m);
                ++i2;
            }
            skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
            if (Math.abs(skewness) > 0.5) {
                d_max = 3;
            }
            k_prime = k;
        }
        int w = d * m;
        if (Math.floor(this.n / (long)(k_prime = (int)Math.ceil((double)k_prime * Math.pow(1.1111111111111112, b)))) > (double)m) {
            m = (int)Math.floor(this.n / (long)k_prime);
        }
        if (this.debug) {
            System.out.println("Finish step 2, k_prime=" + k_prime + ",m=" + m);
        }
        pw.println("Finish step 2, k_prime=" + k_prime + ",m=" + m);
        double[] estimator = this.thirdStep(w, m, d, k_prime, initialState, engine);
        if (this.debug) {
            System.out.println("Finish step 3, varEstimator=" + estimator[0] + ", mean=" + estimator[1]);
        }
        pw.println("Finish step 3, varEstimator=" + estimator[0] + ", mean=" + estimator[1]);
        double[] CI = this.fourthStep(w, d, m, k_prime, estimator);
        if (this.debug) {
            System.out.println("Finish step 4, CI=[" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        }
        pw.println("Finish step 4, CI=[" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        if (this.precisionSet) {
            average = CI[2];
            double halfLength = Math.abs(CI[0] - average);
            if (halfLength < Math.abs(CI[1] - average)) {
                halfLength = Math.abs(CI[1] - average);
            }
            double absolutePrecision = this.isRelative ? average * this.precision : this.precision;
            while (halfLength > absolutePrecision) {
                ++ext_step5;
                long k_star = (long)Math.ceil(Math.pow(halfLength / absolutePrecision, 2.0) * (double)k_prime);
                if (k_star > 1024L) {
                    k_prime = 1024;
                    m = (int)Math.ceil((double)m * this.mid(1.02, k_star / (long)k_prime, 2.0));
                } else {
                    k_prime = (int)k_star;
                }
                estimator = this.thirdStep(w, m, d, k_prime, initialState, engine);
                CI = this.fourthStep(w, d, m, k_prime, estimator);
                average = CI[2];
                halfLength = Math.abs(CI[0] - average);
                if (!(halfLength < Math.abs(CI[1] - average))) continue;
                halfLength = Math.abs(CI[1] - average);
            }
        }
        if (this.debug) {
            System.out.println("The CI is [" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        }
        pw.println("The CI is [" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        pw.println("The total trajectory length is " + this.n + ".");
        pw.println("*************Finish this run****************");
        pw.close();
        return new double[]{CI[0], CI[1], CI[2], this.n, (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9, (double)(System.currentTimeMillis() - time) / 1000.0, ext_step2, ext_step5};
    }

    @Override
    public void updateTransition(StateBit current, int para) {
        int quotien = (int)(this.traIndex / 0x80000000L);
        int remainder = (int)(this.traIndex % 0x80000000L);
        if (this.trajectories.size() <= quotien) {
            this.trajectory = new BitSet();
            this.trajectories.add(this.trajectory);
        }
        this.trajectories.get(quotien).set(remainder, this.evaluateState(current));
        ++this.traIndex;
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public double variance(List<Double> yjm, int start, int end) throws Exception {
        double mean = this.mean(yjm, start, end);
        return this.variance(yjm, start, end, mean);
    }

    public double variance(List<Double> yjm, int start, int end, double mean) throws Exception {
        if (start > end || start < 0) {
            throw new Exception("start index should be smaller than end index");
        }
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total / (double)(end - start - 1);
    }

    public double skewness(List<Double> yjm, int start, int end) throws Exception {
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end, mean);
        return this.skewness(yjm, start, end, variance, mean);
    }

    public double skewness(List<Double> yjm, int start, int end, double variance, double mean) throws Exception {
        double total = 0.0;
        double l = end - start;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total * l / ((l - 1.0) * (l - 2.0) * Math.pow(variance, 1.5));
    }

    public double Ck(List<Double> yjm, int start, int end) {
        double mean = this.mean(yjm, start, end);
        double total1 = 0.0;
        double total2 = 0.0;
        int i = start;
        while (i < end - 1) {
            total1 += Math.pow(yjm.get(i + 1) - yjm.get(i), 2.0);
            total2 += Math.pow(yjm.get(i) - mean, 2.0);
            ++i;
        }
        double result = 1.0 - total1 / (2.0 * (total2 += Math.pow(yjm.get(end - 1) - mean, 2.0)));
        return result;
    }

    public double phiym(List<Double> yjm, int start, int end) throws Exception {
        int k_prime = yjm.size();
        double total = 0.0;
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end);
        int i = 0;
        while (i < k_prime - 1) {
            total += (yjm.get(i) - mean) * (yjm.get(i + 1) - mean);
            ++i;
        }
        return total / ((double)(k_prime - 1) * variance);
    }

    public double Gr(double r, double skewnessSample, double sVariance, int k_doubleprime) {
        double beta = skewnessSample / (6.0 * Math.sqrt(k_doubleprime));
        double tmp = 1.0 + 6.0 * beta * (r - beta);
        double result = Math.cbrt(tmp);
        result = (result - 1.0) / (2.0 * beta);
        return result;
    }

    public double mid(double a, double x, double b) {
        if (x < a) {
            return a;
        }
        if (x > b) {
            return b;
        }
        return x;
    }

    private double[] thirdStep(int w, int m, int d, int k_prime, StateBit initialState, SimulationEngine engine) throws Exception {
        if ((long)m * (long)(d + k_prime) > this.n) {
            long previousN = this.n;
            this.n = (long)m * (long)(d + k_prime);
            initialState = (StateBit)engine.simulate(this.n - previousN, (Object)initialState);
        }
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        long i = 0L;
        while (i < (long)k_prime) {
            double yjm_element = 0.0;
            long j = 0L;
            while (j < (long)m) {
                long total = (long)w + i * (long)m + j;
                int quotien = (int)(total / 0x80000000L);
                int remainder = (int)(total % 0x80000000L);
                if (this.trajectories.get(quotien).get(remainder)) {
                    yjm_element += 1.0;
                }
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        double mean = this.mean(yjm, 0, yjm.size());
        double phiym = this.phiym(yjm, 0, yjm.size());
        double A = (1.0 + phiym) / (1.0 - phiym);
        double varEstimator = A * this.variance(yjm, 0, yjm.size()) / (double)k_prime;
        return new double[]{varEstimator, mean};
    }

    private double[] fourthStep(int w, int d, int m, int k_prime, double[] estimator) throws Exception {
        double skewness;
        int d_prime = (int)Math.ceil((double)w / (double)m);
        int k_doubleprime = 1 + (int)Math.floor((k_prime - 1) / (d_prime + 1));
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        long i = 0L;
        while (i < (long)k_doubleprime) {
            double yjm_element = 0.0;
            long j = 0L;
            while (j < (long)m) {
                long total = (long)w + (long)m * (i * (long)(d_prime + 1)) + j;
                int quotien = (int)(total / Integer.MAX_VALUE);
                int remainder = (int)(total % Integer.MAX_VALUE);
                if (this.trajectories.get(quotien).get(remainder)) {
                    yjm_element += 1.0;
                }
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        double sVariance = Math.sqrt(this.variance(yjm, 0, yjm.size()));
        double skewnessSample = skewness = this.skewness(yjm, 0, yjm.size());
        StudentsT studentT = new StudentsT((double)(k_doubleprime - 1));
        if (this.alpha < 1.0E-12) {
            System.out.println("Alpha value is not set, using defalut value 0.05");
            this.alpha = 0.05;
        }
        if (this.debug) {
            System.out.println("m=" + m + ",k=" + k_doubleprime + ",n=" + this.n + ",d=" + d);
        }
        double left = studentT.inverseCdf(1.0 - this.alpha / 2.0);
        double right = studentT.inverseCdf(this.alpha / 2.0);
        double CI_bottom = estimator[1] - this.Gr(left, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        double CI_top = estimator[1] - this.Gr(right, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        return new double[]{CI_bottom, CI_top, estimator[1]};
    }
}

