/*
 * Decompiled with CFR 0.152.
 */
package jsc.contingencytables;

import jsc.contingencytables.ContingencyTable2x2;
import jsc.distributions.ChiSquared;
import jsc.distributions.ExtendedHypergeometric;
import jsc.distributions.Hypergeometric;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class FishersExactTest
implements SignificanceTest {
    private double chiSquared;
    private double p1;
    private double p1x = 0.0;
    private double midP;
    private double SP;
    private int testStatistic;

    public FishersExactTest(ContingencyTable2x2 contingencyTable2x2) {
        this(contingencyTable2x2, H1.NOT_EQUAL);
    }

    public FishersExactTest(ContingencyTable2x2 contingencyTable2x2, H1 h1) {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        Hypergeometric hypergeometric = null;
        int n5 = contingencyTable2x2.getFrequency(0, 0);
        int n6 = contingencyTable2x2.getFrequency(0, 1);
        int n7 = contingencyTable2x2.getFrequency(1, 0);
        int n8 = contingencyTable2x2.getFrequency(1, 1);
        int n9 = n5 + n6 + n7 + n8;
        if (n5 * n8 > n6 * n7) {
            if (n6 < n7) {
                n4 = n6;
                n3 = n5;
                n2 = n8;
                n = n7;
            } else {
                n4 = n7;
                n3 = n8;
                n2 = n5;
                n = n6;
            }
        } else if (n5 < n8) {
            n4 = n5;
            n3 = n6;
            n2 = n7;
            n = n8;
        } else {
            n4 = n8;
            n3 = n7;
            n2 = n6;
            n = n5;
        }
        this.testStatistic = n4;
        int n10 = n4 + n3;
        int n11 = n4 + n2;
        double d2 = -1.0;
        if (n9 == 0) {
            throw new IllegalArgumentException("All frequencies are zero.");
        }
        hypergeometric = new Hypergeometric(n10, n9, n11);
        this.p1 = hypergeometric.cdf(n4);
        this.midP = 0.5 * hypergeometric.pdf(n4) + hypergeometric.cdf(n4 - 1);
        double d3 = n4 > 0 ? hypergeometric.pdf(n4) : this.p1;
        int n12 = Math.min(n4 + n3, n4 + n2);
        while (n12 >= n4 + 1) {
            if (hypergeometric.pdf(n12) - d3 > 1.0E-16) {
                d2 = hypergeometric.cdf(n12);
                break;
            }
            --n12;
        }
        if (d2 < 0.0) {
            d = 1.0;
            this.p1x = 1.0 - this.p1;
        } else {
            this.p1x = 1.0 - d2;
            d = this.p1 + this.p1x;
        }
        double d4 = (double)Math.abs(n5 * n8 - n6 * n7) - 0.5 * (double)n9;
        this.chiSquared = (double)n9 * d4 * d4 / ((double)(n5 + n6) * (double)(n7 + n8) * (double)(n5 + n7) * (double)(n6 + n8));
        if (h1 == H1.NOT_EQUAL) {
            this.SP = Math.min(d, 1.0);
        } else {
            ExtendedHypergeometric extendedHypergeometric = new ExtendedHypergeometric(n5 + n7, n6 + n8, n5 + n6, 1.0);
            this.SP = h1 == H1.LESS_THAN ? extendedHypergeometric.cdf(n5) : 1.0 - extendedHypergeometric.cdf(n5 - 1);
        }
    }

    public double getApproxSP() {
        return ChiSquared.upperTailProb(this.chiSquared, 1.0);
    }

    public double getChiSquared() {
        return this.chiSquared;
    }

    public double getOneTailedMidP() {
        return this.midP;
    }

    public double getOneTailedSP() {
        return this.p1;
    }

    public double getOppositeTailProb() {
        return this.p1x;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.testStatistic;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 9;
            ContingencyTable2x2[] contingencyTable2x2Array = new ContingencyTable2x2[n];
            contingencyTable2x2Array[0] = new ContingencyTable2x2(3, 1, 1, 3);
            contingencyTable2x2Array[1] = new ContingencyTable2x2(8, 2, 3, 5);
            contingencyTable2x2Array[2] = new ContingencyTable2x2(2, 6, 18, 14);
            contingencyTable2x2Array[3] = new ContingencyTable2x2(2, 3, 4, 5);
            contingencyTable2x2Array[4] = new ContingencyTable2x2(8, 1, 4, 5);
            contingencyTable2x2Array[5] = new ContingencyTable2x2(100, 210, 310, 410);
            contingencyTable2x2Array[6] = new ContingencyTable2x2(200, 410, 620, 820);
            contingencyTable2x2Array[7] = new ContingencyTable2x2(400, 410, 420, 420);
            contingencyTable2x2Array[8] = new ContingencyTable2x2(1000, 2101, 3104, 4105);
            int n2 = 0;
            while (n2 < n) {
                FishersExactTest fishersExactTest = new FishersExactTest(contingencyTable2x2Array[n2]);
                System.out.println("\n    One tail = " + fishersExactTest.getOneTailedSP());
                System.out.println("      opp.tail = " + fishersExactTest.getOppositeTailProb());
                System.out.println("            SP = " + fishersExactTest.getSP());
                System.out.println("One tail mid-P = " + fishersExactTest.getOneTailedMidP());
                System.out.println("     Approx SP = " + fishersExactTest.getApproxSP());
                fishersExactTest = new FishersExactTest(contingencyTable2x2Array[n2], H1.LESS_THAN);
                System.out.println("\"Less than\" SP = " + fishersExactTest.getSP());
                fishersExactTest = new FishersExactTest(contingencyTable2x2Array[n2], H1.GREATER_THAN);
                System.out.println("\"Greater than\" SP = " + fishersExactTest.getSP());
                ++n2;
            }
        }
    }
}

