/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import Jama.Matrix;
import jsc.curvefitting.GeneralLinearLeastSquares;
import jsc.curvefitting.PolynomialFunctionVector;
import jsc.datastructures.PairedData;
import jsc.distributions.Normal;
import jsc.util.Polynomial;

public class PolynomialFit
extends GeneralLinearLeastSquares {
    private final Polynomial poly = new Polynomial(this.getA());

    public PolynomialFit(PairedData pairedData, double[] dArray, int n) {
        super(pairedData, dArray, n + 1, new PolynomialFunctionVector(n));
    }

    public PolynomialFit(PairedData pairedData, int n) {
        this(pairedData, null, n);
    }

    public Polynomial getPolynomial() {
        return this.poly;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n;
            int n2 = 20;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[]{1.0, 2.0, 3.0, -1.0, 0.5};
            int n3 = dArray3.length;
            int n4 = n3 - 1;
            Normal normal = new Normal(0.0, 0.01);
            int n5 = 0;
            while (n5 < n2) {
                dArray[n5] = 1.0 + (double)n5;
                double d = 1.0;
                n = 1;
                while (n <= n4) {
                    d += dArray3[n] * Math.pow(dArray[n5], n);
                    ++n;
                }
                dArray2[n5] = d + normal.random();
                ++n5;
            }
            PolynomialFit polynomialFit = new PolynomialFit(new PairedData(dArray, dArray2), n4);
            Polynomial polynomial = polynomialFit.getPolynomial();
            n = 0;
            while (n < polynomialFit.getM()) {
                System.out.println("a(" + n + ") = " + polynomial.getCoefficient(n));
                ++n;
            }
            System.out.println("Sum of squares = " + polynomialFit.getSumOfSquares());
            System.out.println("\nCovariance matrix");
            Matrix matrix = polynomialFit.getCovariance();
            matrix.print(12, 4);
        }
    }
}

