/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractContinuousDistribution;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.distributions.Normal;
import jsc.distributions.StudentsT;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class NoncentralStudentsT
extends AbstractContinuousDistribution {
    static final int VMAX = 340;
    static final int ITRMAX = 1000;
    static final double R2PI = Math.sqrt(0.6366197723675814);
    static final double ALNRPI = 0.5 * Math.log(Math.PI);
    static final double LGHALF = Maths.logGamma(0.5);
    private double df;
    private double delta;
    private ChiSquared chiSquared;
    private Normal normalApprox;
    private StudentsT studentsT;
    private double logGammaHalfV;
    private double logSqrt2dv;
    private double constant;
    private double HD2;
    private double albeta;
    private double pConst;

    public NoncentralStudentsT(double d, double d2) {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
        this.setParameters(d, d2);
    }

    public double cdf(double d) {
        if (this.delta == 0.0) {
            return this.studentsT.cdf(d);
        }
        double d2 = 0.0;
        double d3 = d;
        double d4 = this.delta;
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d3 = -d3;
            d4 = -d4;
        }
        double d5 = 1.0;
        double d6 = d * d;
        double d7 = d6 / (d6 + this.df);
        if (d7 > 0.0) {
            double d8;
            double d9 = d4 * d4;
            double d10 = this.pConst;
            double d11 = R2PI * d10 * d4;
            double d12 = 0.5 - d10;
            double d13 = 0.5;
            double d14 = 0.5 * this.df;
            double d15 = Math.pow(1.0 - d7, d14);
            double d16 = Beta.incompleteBeta(d7, d13, d14, this.albeta);
            double d17 = 2.0 * d15 * Math.exp(d13 * Math.log(d7) - this.albeta);
            double d18 = 1.0 - d15;
            double d19 = d14 * d7 * d15;
            d2 = d10 * d16 + d11 * d18;
            do {
                d16 -= d17;
                d18 -= d19;
                d17 = d17 * d7 * ((d13 += 1.0) + d14 - 1.0) / d13;
                d19 = d19 * d7 * (d13 + d14 - 0.5) / (d13 + 0.5);
                double d20 = d5 + d5;
                d10 = d10 * d9 / d20;
                d11 = d11 * d9 / (d20 + 1.0);
                d2 = d2 + d10 * d16 + d11 * d18;
            } while ((d8 = 2.0 * (d12 -= d10) * (d16 - d17)) > this.tolerance && (d5 += 1.0) <= 1000.0);
        }
        if (d5 > 1000.0) {
            throw new RuntimeException("Cannot calculate cdf to required accuracy.");
        }
        d2 += Normal.standardTailProb(d4, true);
        if (bl) {
            d2 = 1.0 - d2;
        }
        return d2;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getDf() {
        return this.df;
    }

    public double inverseCdf(double d) {
        if (this.delta == 0.0) {
            return this.studentsT.inverseCdf(d);
        }
        return super.inverseCdf(d);
    }

    public double mean() {
        if (this.df <= 1.0) {
            return Double.NaN;
        }
        if (this.delta == 0.0) {
            return 0.0;
        }
        return this.delta * Math.sqrt(0.5 * this.df) * Math.exp(Maths.logGamma(0.5 * (this.df - 1.0)) - this.logGammaHalfV);
    }

    public Normal normalApproximation() {
        return this.normalApprox;
    }

    public double pdf(double d) {
        if (this.delta == 0.0) {
            return this.studentsT.pdf(d);
        }
        if (d == 0.0) {
            return Math.exp(-this.HD2 + Maths.logGamma(0.5 * (this.df + 1.0))) / this.constant;
        }
        if (this.df > 340.0) {
            return this.normalApprox.pdf(d);
        }
        double d2 = this.delta * d;
        boolean bl = d2 < 0.0;
        double d3 = 0.0;
        double d4 = this.logSqrt2dv + Math.log(Math.abs(d2));
        double d5 = 0.5 * Math.log(1.0 + d * d / this.df);
        int n = 0;
        while (n < 1000) {
            double d6 = Math.exp((double)n * d4 - this.HD2 + Maths.logGamma(0.5 * (this.df + (double)n + 1.0)) - Maths.logGamma(n + 1) - (this.df + (double)n + 1.0) * d5);
            d3 = bl && n % 2 > 0 ? (d3 -= d6) : (d3 += d6);
            if (Math.abs(d6) < this.tolerance) {
                return d3 / this.constant;
            }
            ++n;
        }
        throw new RuntimeException("Cannot calculate pdf to required accuracy.");
    }

    public double random() {
        return (this.rand.nextGaussian() + this.delta) / Math.sqrt(this.chiSquared.random() / this.df);
    }

    public void setParameters(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid degrees of freedom.");
        }
        this.df = d;
        this.delta = d2;
        if (d2 == 0.0) {
            this.studentsT = new StudentsT(d);
        } else {
            this.studentsT = null;
            this.HD2 = 0.5 * d2 * d2;
            this.pConst = 0.5 * Math.exp(-this.HD2);
            double d3 = 0.5 * d;
            this.logGammaHalfV = Maths.logGamma(0.5 * d);
            this.logSqrt2dv = Math.log(Math.sqrt(2.0 / d));
            this.albeta = ALNRPI + this.logGammaHalfV - Maths.logGamma(0.5 * (d + 1.0));
            this.constant = Math.exp(LGHALF + Maths.logGamma(0.5 * d) + 0.5 * Math.log(d));
        }
        this.chiSquared = new ChiSquared(d);
        this.chiSquared.setSeed(this.rand.nextLong());
        this.normalApprox = new Normal(d2, Math.sqrt(1.0 + d2 * d2 / (d + d)));
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        this.chiSquared.setSeed(this.rand.nextLong() + 1L);
    }

    public String toString() {
        return new String("Noncentral Student's t distribution: df = " + this.df + ", delta = " + this.delta + ".");
    }

    public double variance() {
        if (this.df <= 2.0) {
            return Double.NaN;
        }
        double d = this.mean();
        return (1.0 + this.delta * this.delta) * (this.df / (this.df - 2.0)) - d * d;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            NoncentralStudentsT noncentralStudentsT = new NoncentralStudentsT(100.0, 10.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = noncentralStudentsT.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, noncentralStudentsT, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

