/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Normal
extends AbstractDistribution {
    static final double SQRPI2 = Math.sqrt(Math.PI * 2);
    private double mean;
    private double sd;

    public Normal() {
        this(0.0, 1.0);
    }

    public Normal(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.mean = d;
        this.sd = d2;
    }

    public double cdf(double d) {
        return Normal.standardTailProb((d - this.mean) / this.sd, false);
    }

    public double getMaximumPdf() {
        return 1.0 / (this.sd * SQRPI2);
    }

    public double inverseCdf(double d) {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mean + this.sd * Normal.inverseStandardCdf(d);
    }

    public static double inverseStandardCdf(double d) {
        double d2;
        double d3 = d - 0.5;
        if (Math.abs(d3) <= 0.425) {
            double d4 = 0.180625 - d3 * d3;
            double d5 = d3 * (((((((2509.0809287301227 * d4 + 33430.57558358813) * d4 + 67265.7709270087) * d4 + 45921.95393154987) * d4 + 13731.69376550946) * d4 + 1971.5909503065513) * d4 + 133.14166789178438) * d4 + 3.3871328727963665) / (((((((5226.495278852854 * d4 + 28729.085735721943) * d4 + 39307.89580009271) * d4 + 21213.794301586597) * d4 + 5394.196021424751) * d4 + 687.1870074920579) * d4 + 42.31333070160091) * d4 + 1.0);
            return d5;
        }
        double d6 = d2 = d3 < 0.0 ? d : 1.0 - d;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d7 = (d2 = Math.sqrt(-Math.log(d2))) <= 5.0 ? (((((((7.745450142783414E-4 * (d2 -= 1.6) + 0.022723844989269184) * d2 + 0.2417807251774506) * d2 + 1.2704582524523684) * d2 + 3.6478483247632045) * d2 + 5.769497221460691) * d2 + 4.630337846156546) * d2 + 1.4234371107496835) / (((((((1.0507500716444169E-9 * d2 + 5.475938084995345E-4) * d2 + 0.015198666563616457) * d2 + 0.14810397642748008) * d2 + 0.6897673349851) * d2 + 1.6763848301838038) * d2 + 2.053191626637759) * d2 + 1.0) : (((((((2.0103343992922881E-7 * (d2 -= 5.0) + 2.7115555687434876E-5) * d2 + 0.0012426609473880784) * d2 + 0.026532189526576124) * d2 + 0.29656057182850487) * d2 + 1.7848265399172913) * d2 + 5.463784911164114) * d2 + 6.657904643501103) / (((((((2.0442631033899397E-15 * d2 + 1.421511758316446E-7) * d2 + 1.8463183175100548E-5) * d2 + 7.868691311456133E-4) * d2 + 0.014875361290850615) * d2 + 0.1369298809227358) * d2 + 0.599832206555888) * d2 + 1.0);
        if (d3 < 0.0) {
            d7 = -d7;
        }
        return d7;
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        double d2 = (d - this.mean) / this.sd;
        return Math.exp(-0.5 * d2 * d2) / (SQRPI2 * this.sd);
    }

    public double random() {
        return this.mean + this.sd * this.rand.nextGaussian();
    }

    public double sd() {
        return this.sd;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public void setSd(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.sd = d;
    }

    public void setVariance(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.sd = Math.sqrt(d);
    }

    public static double standardTailProb(double d, boolean bl) {
        double d2;
        boolean bl2 = bl;
        double d3 = d;
        if (d3 < 0.0) {
            bl2 = !bl2;
            d3 = -d3;
        }
        if (d3 <= 8.0 || bl2 && d3 <= 37.0) {
            double d4 = 0.5 * d3 * d3;
            d2 = d3 >= 1.28 ? 0.398942280385 * Math.exp(-d4) / (d3 - 3.8052E-8 + 1.00000615302 / (d3 + 3.98064794E-4 + 1.98615381364 / (d3 - 0.151679116635 + 5.29330324926 / (d3 + 4.8385912808 - 15.1508972451 / (d3 + 0.742380924027 + 30.789933034 / (d3 + 3.99019417011)))))) : 0.5 - d3 * (0.398942280444 - 0.399903438504 * d4 / (d4 + 5.75885480458 - 29.8213557808 / (d4 + 2.62433121679 + 48.6959930692 / (d4 + 5.92885724438))));
        } else {
            d2 = 0.0;
        }
        if (!bl2) {
            d2 = 1.0 - d2;
        }
        return d2;
    }

    public String toString() {
        return new String("Normal distribution: mean = " + this.mean + ", sd = " + this.sd + ".");
    }

    public double upperTailProb(double d) {
        return Normal.standardTailProb((d - this.mean) / this.sd, true);
    }

    public double variance() {
        return this.sd * this.sd;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            Normal normal = new Normal(-5.0, 10.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = normal.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, normal, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

