/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.datastructures.GroupedData;
import jsc.distributions.MannWhitneyU;
import jsc.distributions.Normal;
import jsc.independentsamples.MannWhitneyTest;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;
import jsc.util.Arrays;
import jsc.util.Maths;

public class JonckheereTest
implements SignificanceTest {
    static final int MAX_PRODUCT = (int)Math.pow(15.0, 6.0);
    final int N;
    double W;
    final int[] n;
    private double SP;

    public JonckheereTest(GroupedData groupedData, String[] stringArray, double d, boolean bl) {
        int n = groupedData.getGroupCount();
        if (n < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        this.N = groupedData.getN();
        if (this.N < 5) {
            throw new IllegalArgumentException("Less than five data values.");
        }
        if (stringArray.length != n) {
            throw new IllegalArgumentException("Alternative array wrong length.");
        }
        this.n = new int[n];
        this.W = 0.0;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            double[] dArray = groupedData.getData(stringArray[n2]);
            this.n[n2] = n3 = dArray.length;
            int n4 = n2 + 1;
            while (n4 < n) {
                double[] dArray2 = groupedData.getData(stringArray[n4]);
                if (dArray2 == null) {
                    throw new IllegalArgumentException("Invalid alternative sample label.");
                }
                int n5 = dArray2.length;
                MannWhitneyTest mannWhitneyTest = new MannWhitneyTest(dArray, dArray2, H1.LESS_THAN, d, true);
                double d2 = mannWhitneyTest.getTestStatistic();
                this.W += d2;
                ++n4;
            }
            ++n2;
        }
        if (bl) {
            this.SP = JonckheereTest.approxSP(this.n, this.W);
        } else {
            try {
                this.SP = JonckheereTest.exactSP(this.n, this.W);
            }
            catch (RuntimeException runtimeException) {
                this.SP = JonckheereTest.approxSP(this.n, this.W);
            }
        }
    }

    public JonckheereTest(GroupedData groupedData, String[] stringArray) {
        this(groupedData, stringArray, 0.0, groupedData.getMaxSize() > 4);
    }

    public static double approxSP(int[] nArray, double d) {
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 2) {
                throw new IllegalArgumentException("Less than two data values in a sample.");
            }
            d2 += (double)(nArray[n2] * nArray[n2]);
            d3 += (double)(nArray[n2] * nArray[n2]) * ((double)(nArray[n2] + nArray[n2]) + 3.0);
            n += nArray[n2];
            ++n2;
        }
        double d4 = 0.25 * ((double)(n * n) - d2);
        double d5 = Math.sqrt(((double)(n * n) * ((double)(n + n) + 3.0) - d3) / 72.0);
        double d6 = (d - d4 + 0.5) / d5;
        return Normal.standardTailProb(d6, false);
    }

    public static double exactSP(int[] nArray, double d) {
        int n = (int)Arrays.sum(nArray);
        if (d > (double)(MAX_PRODUCT / 2)) {
            throw new RuntimeException("Insufficient memory for exact distribution: try normal approximation.");
        }
        int n2 = (int)Math.ceil(d);
        double[] dArray = new double[1 + n2];
        MannWhitneyU.harding(false, nArray[0], n -= nArray[0], n2, dArray);
        int n3 = 1;
        while (n3 < nArray.length - 1) {
            MannWhitneyU.harding(true, nArray[n3], n -= nArray[n3], n2, dArray);
            ++n3;
        }
        double d2 = Maths.logMultinomialCoefficient(nArray);
        double d3 = 0.0;
        int n4 = 0;
        while (n4 <= n2) {
            double d4 = Math.exp(Math.log(dArray[n4]) - d2);
            if (Double.isNaN(d4)) {
                throw new RuntimeException("Cannot calculate exact distribution: try normal approximation.");
            }
            d3 += d4;
            ++n4;
        }
        return d3;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.W;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{19.0, 21.0, 40.0, 49.0, 20.0, 61.0, 99.0, 110.0, 60.0, 80.0, 100.0, 151.0, 130.0, 129.0, 149.0, 160.0};
            String[] stringArray2 = new String[]{"I", "II", "III", "IV", "I", "II", "III", "IV", "I", "II", "III", "IV", "I", "II", "III", "IV"};
            String[] stringArray3 = new String[]{"I", "II", "III", "IV"};
            GroupedData groupedData = new GroupedData(dArray, stringArray2);
            JonckheereTest jonckheereTest = new JonckheereTest(groupedData, stringArray3, 0.0, false);
            double d = jonckheereTest.getTestStatistic();
            System.out.println("W = " + d);
            System.out.println("       SP = " + jonckheereTest.getSP());
            System.out.println("Approx SP = " + JonckheereTest.approxSP(groupedData.getSizes(), d));
            System.out.println(" Exact SP = " + JonckheereTest.exactSP(groupedData.getSizes(), d));
        }
    }
}

