/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.distributions.Tail;
import jsc.event.StatisticListener;
import jsc.independentsamples.TwoSampleBootstrapTest;
import jsc.independentsamples.TwoSampleStatistic;
import jsc.independentsamples.TwoSampleTtest;
import jsc.tests.H1;
import jsc.util.Arrays;

public class TwoSampleBootstrapDistsTest
extends TwoSampleBootstrapTest {
    private double[] xA;
    private double[] xB;
    private double[] x;

    public TwoSampleBootstrapDistsTest(TwoSampleStatistic twoSampleStatistic, Tail tail, int n) {
        this(twoSampleStatistic, tail, n, null);
    }

    public TwoSampleBootstrapDistsTest(TwoSampleStatistic twoSampleStatistic, Tail tail, int n, StatisticListener statisticListener) {
        super(twoSampleStatistic, tail, statisticListener);
        this.x = Arrays.append(twoSampleStatistic.getSampleA(), twoSampleStatistic.getSampleB());
        this.xA = new double[this.nA];
        this.xB = new double[this.nB];
        this.calculateSP(n);
    }

    protected double bootstrapSample() {
        int n = 0;
        while (n < this.nA) {
            this.xA[n] = this.x[this.rand.nextInt(this.N)];
            ++n;
        }
        n = 0;
        while (n < this.nB) {
            this.xB[n] = this.x[this.rand.nextInt(this.N)];
            ++n;
        }
        return this.t.resampleStatistic(this.xA, this.xB);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{94.0, 197.0, 16.0, 38.0, 99.0, 141.0, 23.0};
            double[] dArray2 = new double[]{52.0, 104.0, 146.0, 10.0, 50.0, 31.0, 40.0, 27.0, 46.0};
            TwoSampleTtest twoSampleTtest = new TwoSampleTtest(dArray, dArray2, H1.GREATER_THAN, true);
            long l = System.currentTimeMillis();
            TwoSampleBootstrapDistsTest twoSampleBootstrapDistsTest = new TwoSampleBootstrapDistsTest((TwoSampleStatistic)twoSampleTtest, Tail.UPPER, 5000000);
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("T = " + twoSampleTtest.getTestStatistic() + " SP = " + twoSampleTtest.getSP());
            System.out.println("Bootstrap SP = " + twoSampleBootstrapDistsTest.getSP());
        }
    }
}

