/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.ci.AbstractConfidenceInterval;
import jsc.distributions.Normal;

public class LargeSampleProportionCI
extends AbstractConfidenceInterval {
    private final double pHat;

    public LargeSampleProportionCI(long l, long l2, double d) {
        super(d);
        if (l2 < 1L) {
            throw new IllegalArgumentException("Invalid number of trials.");
        }
        if (l < 0L || l > l2) {
            throw new IllegalArgumentException("Invalid number of successes.");
        }
        Normal normal = new Normal();
        double d2 = 1.0 - d;
        double d3 = normal.inverseCdf(1.0 - 0.5 * d2);
        this.pHat = (double)l / (double)l2;
        double d4 = d3 * Math.sqrt(this.pHat * (1.0 - this.pHat) / (double)l2);
        this.lowerLimit = this.pHat - d4;
        this.upperLimit = this.pHat + d4;
    }

    public double getP() {
        return this.pHat;
    }
}

