/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.descriptive.MeanVar;
import jsc.distributions.Normal;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class Ztest
implements SignificanceTest {
    private final double z;
    private final MeanVar mv;
    private double SP;

    public Ztest(double[] dArray, double d, double d2, H1 h1) {
        this.mv = new MeanVar(dArray);
        this.z = (this.mv.getMean() - d) / (d2 / Math.sqrt(this.mv.getN()));
        this.SP = Ztest.getSP(this.z, h1);
    }

    public Ztest(double[] dArray, double d, double d2) {
        this(dArray, d, d2, H1.NOT_EQUAL);
    }

    public Ztest(double[] dArray, double d, H1 h1) {
        this.mv = new MeanVar(dArray);
        this.z = (this.mv.getMean() - d) / (this.mv.getSd() / Math.sqrt(this.mv.getN()));
        this.SP = Ztest.getSP(this.z, h1);
    }

    public Ztest(double[] dArray, double d) {
        this(dArray, d, H1.NOT_EQUAL);
    }

    public double getMean() {
        return this.mv.getMean();
    }

    public double getSd() {
        return this.mv.getSd();
    }

    public double getSP() {
        return this.SP;
    }

    public static double getSP(double d, H1 h1) {
        if (h1 == H1.NOT_EQUAL) {
            return 2.0 * Normal.standardTailProb(Math.abs(d), true);
        }
        if (h1 == H1.LESS_THAN) {
            return Normal.standardTailProb(d, false);
        }
        return Normal.standardTailProb(d, true);
    }

    public double getTestStatistic() {
        return this.z;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{4.9, 5.1, 4.6, 5.0, 5.1, 4.7, 4.4, 4.7, 4.6};
            Ztest ztest = new Ztest(dArray, 5.0, 0.2, H1.NOT_EQUAL);
            System.out.println("z = " + ztest.getTestStatistic() + " SP = " + ztest.getSP());
            Ztest ztest2 = new Ztest(dArray, 5.0, 0.2, H1.LESS_THAN);
            System.out.println("z = " + ztest2.getTestStatistic() + " SP = " + ztest2.getSP());
            Ztest ztest3 = new Ztest(dArray, 5.0, 0.2, H1.GREATER_THAN);
            System.out.println("z = " + ztest3.getTestStatistic() + " SP = " + ztest3.getSP());
        }
    }
}

