/*
 * Decompiled with CFR 0.152.
 */
package jsc.relatedsamples;

import jsc.datastructures.MatchedData;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.distributions.FriedmanM;
import jsc.tests.SignificanceTest;
import jsc.util.Maths;

public class FriedmanTest
implements SignificanceTest {
    int k;
    int n;
    double C;
    double M;
    double S;
    double W;
    private double SP;
    private final MatchedData ranks;

    public FriedmanTest(MatchedData matchedData, double d, boolean bl) {
        int n = 0;
        double d2 = 0.0;
        this.S = 0.0;
        this.n = matchedData.getBlockCount();
        this.k = matchedData.getTreatmentCount();
        if (this.k < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (this.n < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        this.ranks = matchedData.copy();
        double d3 = 0.5 * ((double)this.k + 1.0);
        n = this.ranks.rankByBlocks(d);
        double[][] dArray = this.ranks.getData();
        int n2 = 0;
        while (n2 < this.k) {
            d2 = 0.0;
            int n3 = 0;
            while (n3 < this.n) {
                d2 += dArray[n3][n2];
                ++n3;
            }
            this.S += ((d2 /= (double)this.n) - d3) * (d2 - d3);
            ++n2;
        }
        double d4 = this.k * (this.k + 1);
        double d5 = this.k * (this.k * this.k - 1);
        this.C = 1.0 - (double)n / ((double)this.n * d5);
        this.M = 12.0 * (double)this.n * this.S / d4 / this.C;
        this.W = this.M / ((double)this.n * ((double)this.k - 1.0));
        this.SP = bl ? FriedmanTest.betaApproxSP(this.n, this.k, this.S, this.C) : (this.k == 2 && this.n < 25 || this.k == 3 && this.n < 11 || this.k == 4 && this.n < 7 || this.k == 5 && this.n < 5 || this.k == 6 && this.n < 4 || this.k == 7 && this.n < 3 || this.k == 8 && this.n < 3 || this.k == 9 && this.n < 3 || this.k == 10 && this.n < 3 ? FriedmanTest.exactSP(this.n, this.k, this.M) : FriedmanTest.betaApproxSP(this.n, this.k, this.S, this.C));
    }

    public FriedmanTest(MatchedData matchedData) {
        this(matchedData, 0.0, false);
    }

    public static double betaApproxSP(int n, int n2, double d, double d2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid S value.");
        }
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Invalid correction factor for ties.");
        }
        double d3 = 0.5 * ((double)n2 - 1.0) - 1.0 / (double)n;
        double d4 = ((double)n - 1.0) * d3;
        double d5 = (double)(n * n) * d;
        double d6 = d2 * 12.0 * (d5 - 1.0) / ((double)(n * n * n2) * ((double)(n2 * n2) - 1.0) + 2.0);
        try {
            return 1.0 - Beta.incompleteBeta(d6, d3, d4, Maths.lnB(d3, d4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Cannot calculate beta approximation.");
        }
    }

    public static double chiSquaredApproxSP(int n, double d) {
        if (n < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid M value.");
        }
        ChiSquared chiSquared = new ChiSquared(n - 1);
        return 1.0 - chiSquared.cdf(d);
    }

    public static double exactSP(int n, int n2, double d) {
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid M value.");
        }
        FriedmanM friedmanM = new FriedmanM(n, n2);
        return 1.0 - friedmanM.cdf(d);
    }

    public double getC() {
        return this.C;
    }

    public MatchedData getRanks() {
        return this.ranks;
    }

    public double getS() {
        return this.S;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.M;
    }

    public double getW() {
        return this.W;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"1", "2", "3"};
            String[] stringArray3 = new String[]{"A", "B", "C", "D"};
            double[][] dArrayArray = new double[][]{{8.5, 8.9, 8.8, 8.8}, {8.2, 8.4, 8.2, 8.2}, {8.9, 9.1, 9.1, 8.9}};
            MatchedData matchedData = new MatchedData((double[][])dArrayArray, stringArray2, stringArray3);
            int n = matchedData.getTreatmentCount();
            int n2 = matchedData.getBlockCount();
            System.out.println("n = " + n2 + " k = " + n);
            FriedmanTest friedmanTest = new FriedmanTest(matchedData, 0.0, false);
            System.out.print(friedmanTest.getRanks().toString());
            double d = friedmanTest.getTestStatistic();
            double d2 = friedmanTest.getS();
            double d3 = friedmanTest.getC();
            System.out.println("S = " + friedmanTest.getS() + " M = " + d + " W = " + friedmanTest.getW());
            System.out.println("Chi-squared approx SP = " + FriedmanTest.chiSquaredApproxSP(n, d));
            System.out.println("                   SP = " + friedmanTest.getSP());
            System.out.println("       Beta approx SP = " + FriedmanTest.betaApproxSP(n2, n, d2, d3));
            System.out.println("       Exact(test) SP = " + FriedmanTest.exactSP(n2, n, d));
        }
    }
}

