/*
 * Decompiled with CFR 0.152.
 */
package jsc.relatedsamples;

import jsc.datastructures.MatchedData;
import jsc.descriptive.MeanVar;
import jsc.distributions.FishersF;
import jsc.tests.SignificanceTest;

public class TwoWayANOVA
implements SignificanceTest {
    private final int N;
    private final int treatmentCount;
    private final int blockCount;
    private final double F;
    private final double SP;
    private double tess;
    private double bess;
    private final double tems;
    private final double bems;
    private double tss;
    private final double rss;
    private final double rms;
    private final MatchedData resids;

    public TwoWayANOVA(MatchedData matchedData) {
        this.treatmentCount = matchedData.getTreatmentCount();
        this.blockCount = matchedData.getBlockCount();
        if (this.treatmentCount < 2) {
            throw new IllegalArgumentException("Less than two treatments.");
        }
        if (this.blockCount < 2) {
            throw new IllegalArgumentException("Less than two blocks.");
        }
        this.N = matchedData.getN();
        this.resids = matchedData.copy();
        MeanVar meanVar = new MeanVar(matchedData.getBlockPackedCopy());
        this.tss = ((double)this.N - 1.0) * meanVar.getVariance();
        double d = this.resids.sweepByBlocks();
        System.out.println("brss = " + d);
        this.bess = this.tss - d;
        this.rss = this.resids.sweepByTreatments();
        System.out.println("rss = " + this.rss);
        this.tess = d - this.rss;
        this.bems = this.bess / (double)(this.blockCount - 1);
        this.tems = this.tess / (double)(this.treatmentCount - 1);
        this.rms = this.rss / (double)((this.blockCount - 1) * (this.treatmentCount - 1));
        this.F = this.tems / this.rms;
        this.SP = FishersF.upperTailProb(this.F, this.treatmentCount - 1, (this.treatmentCount - 1) * (this.blockCount - 1));
    }

    public int getN() {
        return this.N;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public double getBlockEss() {
        return this.bess;
    }

    public double getBlockEms() {
        return this.bems;
    }

    public int getTreatmentCount() {
        return this.treatmentCount;
    }

    public double getTreatmentEss() {
        return this.tess;
    }

    public double getTreatmentEms() {
        return this.tems;
    }

    public double getRss() {
        return this.rss;
    }

    public double getRms() {
        return this.rms;
    }

    public double getTss() {
        return this.tss;
    }

    public MatchedData getResiduals() {
        return this.resids;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.F;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[][] dArrayArray = new double[][]{{3.93, 3.99, 4.08}, {3.78, 3.96, 3.94}, {3.88, 3.96, 4.02}, {3.93, 4.03, 4.06}, {3.84, 4.1, 3.94}, {3.75, 4.02, 4.09}, {3.98, 4.06, 4.17}, {3.84, 3.92, 4.12}};
            MatchedData matchedData = new MatchedData(dArrayArray);
            TwoWayANOVA twoWayANOVA = new TwoWayANOVA(matchedData);
            System.out.print(twoWayANOVA.getResiduals().toString());
            System.out.println("Treatment SS = " + twoWayANOVA.getTreatmentEss() + " MS = " + twoWayANOVA.getTreatmentEms());
            System.out.println("    Block SS = " + twoWayANOVA.getBlockEss() + " MS = " + twoWayANOVA.getBlockEms());
            System.out.println("         RSS = " + twoWayANOVA.getRss() + " RMS = " + twoWayANOVA.getRms());
            System.out.println("         TSS = " + twoWayANOVA.getTss());
            System.out.println("F = " + twoWayANOVA.getTestStatistic() + " SP = " + twoWayANOVA.getSP());
        }
    }
}

