/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.accessory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.StandardMathFunction;
import jsc.swt.control.LegalCharactersField;

public class Calculator {
    StandardMathFunction smf;
    JOptionPane pane;
    JDialog dialog;
    Component parentComponent;
    LegalCharactersField expression;
    JComboBox expressionCombo;
    JTextField errorMessage;

    public Calculator(Component component) {
        JComponent jComponent;
        Serializable serializable;
        this.parentComponent = component;
        this.smf = new StandardMathFunction();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        this.expression = new LegalCharactersField(0, this.smf.getLegalCharacters());
        this.expression.addActionListener(new CalcButtonListener());
        this.expressionCombo = new JComboBox();
        this.expressionCombo.setEditable(true);
        this.expressionCombo.setEditor(new ExpressionEditor());
        this.expressionCombo.setMaximumRowCount(10);
        this.errorMessage = new JTextField();
        this.errorMessage.setEditable(false);
        this.errorMessage.setFocusable(false);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 2, 2));
        jPanel2.add(this.expressionCombo);
        jPanel2.add(this.errorMessage);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ButtonListener buttonListener = new ButtonListener();
        Font font = new Font("Monospaced", 0, 14);
        JPanel jPanel4 = new JPanel(new GridLayout(4, 3, 2, 2));
        String[] stringArray = new String[]{"+", "-", "*", "/", "^", "%", "(", ")", " ", "pi", "e"};
        int n = 0;
        while (n < stringArray.length) {
            serializable = new JButton(stringArray[n]);
            serializable.setFont(font);
            serializable.addActionListener(buttonListener);
            if (n == 8) {
                serializable.setVisible(false);
            }
            jPanel4.add((Component)serializable);
            ++n;
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        serializable = new Font("SanSerif", 0, 12);
        JPanel jPanel5 = new JPanel(new GridLayout(6, 3, 2, 2));
        String[] stringArray2 = new String[]{"sqrt", "log", "exp", "int", "nint", "sign", "abs", "deg", "rad", "sin", "asin", "sinh", "cos", "acos", "cosh", "tan", "atan", "tanh"};
        n = 0;
        while (n < stringArray2.length) {
            jComponent = new JButton(stringArray2[n].toUpperCase());
            jComponent.setFont((Font)serializable);
            ((AbstractButton)jComponent).addActionListener(buttonListener);
            jPanel5.add(jComponent);
            ++n;
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        jComponent = new JPanel(new GridLayout(4, 3, 2, 2));
        JButton[] jButtonArray = new JButton[10];
        n = 0;
        while (n <= 9) {
            jButtonArray[n] = new JButton(new Integer(n).toString());
            jButtonArray[n].addActionListener(buttonListener);
            jButtonArray[n].setFont((Font)serializable);
            ++n;
        }
        jComponent.add(jButtonArray[7]);
        jComponent.add(jButtonArray[8]);
        jComponent.add(jButtonArray[9]);
        jComponent.add(jButtonArray[4]);
        jComponent.add(jButtonArray[5]);
        jComponent.add(jButtonArray[6]);
        jComponent.add(jButtonArray[1]);
        jComponent.add(jButtonArray[2]);
        jComponent.add(jButtonArray[3]);
        jComponent.add(jButtonArray[0]);
        JButton jButton = new JButton(".");
        jButton.addActionListener(buttonListener);
        jComponent.add(jButton);
        JButton jButton2 = new JButton("E");
        jButton2.addActionListener(buttonListener);
        jComponent.add(jButton2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel3.add((Component)jComponent, gridBagConstraints);
        jPanel.add((Component)jPanel3, "Center");
        JButton jButton3 = new JButton("Calculate");
        jButton3.addActionListener(new CalcButtonListener());
        JButton jButton4 = new JButton("Clear");
        jButton4.addActionListener(new ClearButtonListener());
        JButton jButton5 = new JButton("Close");
        jButton5.addActionListener(new CloseButtonListener());
        jButton5.setDefaultCapable(false);
        this.pane = new JOptionPane(jPanel, -1, -1, null, new Object[]{jButton4, jButton3, jButton5});
        this.dialog = this.pane.createDialog(component, "Calculator");
        this.dialog.setModal(false);
        this.dialog.setResizable(false);
    }

    void insertToken(String string) {
        int n = this.expression.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer(this.expression.getText());
        stringBuffer.insert(n, string);
        this.expression.setText(stringBuffer.toString());
    }

    public void setSize(int n, int n2) {
        this.dialog.setSize(n, n2);
        this.dialog.setLocationRelativeTo(this.parentComponent);
    }

    public Object show() {
        if (this.expressionCombo.getItemCount() > 1) {
            this.expression.setText("");
        }
        this.errorMessage.setText("");
        this.dialog.show();
        return null;
    }

    class ExpressionEditor
    implements ComboBoxEditor {
        ExpressionEditor() {
        }

        public void addActionListener(ActionListener actionListener) {
            Calculator.this.expression.addActionListener(actionListener);
        }

        public Component getEditorComponent() {
            return Calculator.this.expression;
        }

        public Object getItem() {
            return Calculator.this.expression.getText();
        }

        public void removeActionListener(ActionListener actionListener) {
            Calculator.this.expression.removeActionListener(actionListener);
        }

        public void selectAll() {
            Calculator.this.expression.selectAll();
        }

        public void setItem(Object object) {
            if (object != null) {
                Calculator.this.expression.setText(object.toString());
                Calculator.this.errorMessage.setText("");
            }
        }
    }

    class CloseButtonListener
    implements ActionListener {
        CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Calculator.this.dialog.dispose();
        }
    }

    class ClearButtonListener
    implements ActionListener {
        ClearButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Calculator.this.expression.setText("");
            Calculator.this.errorMessage.setText("");
        }
    }

    class CalcButtonListener
    implements ActionListener {
        CalcButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Calculator.this.errorMessage.setText("");
            try {
                String string = Calculator.this.expression.getText();
                double d = Calculator.this.smf.parse(string);
                Calculator.this.expressionCombo.addItem(string);
                Calculator.this.expressionCombo.setSelectedIndex(Calculator.this.expressionCombo.getItemCount() - 1);
                if (!Double.isNaN(d)) {
                    Calculator.this.errorMessage.setText("Value of expression = " + d);
                }
            }
            catch (MathFunctionException mathFunctionException) {
                Calculator.this.errorMessage.setText(mathFunctionException.getMessage());
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Calculator.this.insertToken(string);
        }
    }
}

