/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public IntegerField(int n, int n2) {
        super(n2);
        this.integerFormatter.setParseIntegerOnly(true);
        this.integerFormatter.setGroupingUsed(false);
        this.setBackground(Color.white);
        this.setValue(n);
    }

    public int getValue() {
        try {
            return this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
            return 0;
        }
    }

    protected boolean isNegative() throws BadLocationException {
        return this.getText(0, 1).charAt(0) == '-';
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            if (this.getLength() + string.length() > (IntegerField.this.isNegative() || n == 0 && cArray[0] == '-' ? 10 : 9)) {
                IntegerField.this.toolkit.beep();
                return;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (Character.isDigit(cArray[n3])) {
                    cArray2[n2++] = cArray[n3];
                } else if (cArray[n3] == '-' && n == 0 && !IntegerField.this.isNegative()) {
                    cArray2[n2++] = cArray[n3];
                } else {
                    IntegerField.this.toolkit.beep();
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

