/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class IntegerLogSlider
extends JSlider {
    double dminVal;
    double logRange;

    public IntegerLogSlider(int n, int n2, int n3, int n4, int[] nArray) {
        super(0);
        if (n <= 0 || n2 <= n) {
            throw new IllegalArgumentException("Illegal range for logarithmic slider.");
        }
        this.dminVal = n;
        this.logRange = Math.log((double)n2 / this.dminVal);
        this.setMinimum(0);
        this.setMaximum(n4);
        this.setValue(this.getSliderValue(n3));
        this.setPaintTicks(false);
        int n5 = nArray.length;
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(n5);
        int n6 = 0;
        while (n6 < n5) {
            int n7 = nArray[n6];
            if (n7 >= n && n7 <= n2) {
                hashtable.put(new Integer(this.getSliderValue(n7)), new JLabel(Integer.toString(n7)));
            }
            ++n6;
        }
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
    }

    public int getIntegerValue() {
        return this.getIntegerValue(this.getValue());
    }

    int getIntegerValue(int n) {
        return (int)Math.round(this.dminVal * Math.exp((double)n * this.logRange / (double)this.getMaximum()));
    }

    int getSliderValue(int n) {
        double d = (double)this.getMaximum() * Math.log((double)n / this.dminVal) / this.logRange;
        return (int)Math.round(d);
    }

    public void setIntegerValue(int n) {
        this.setValue(this.getSliderValue(n));
    }
}

